from tkinter import *
import numpy as np
import os
import sys
import shutil
import glob
from glob import glob

# for command=donothing
def donothing():
   filewin = Toplevel(root)
   button = Button(filewin, text="Do nothing button")
   button.pack()

#-----------------------------START Sentinel - 1A/B Level 1C------------  

#-------------------------------S1 HELP-----------------------------------
#for command under Help = quick help = openS1Manual
def openS1Manual():
   import os
   os.startfile(sent_path +'\help\S1_quickhelp.pdf')

def openS1UH():
   import os
   os.startfile(sent_path +'\help\Sentinel1_User_Handbook.pdf')

#-----------------------------START Sentinel - 1A / B Level 1C-----------  
#for command under S1 = A / B = 
def S1AB_L1C_GRD():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S1AB_L1C_GRD.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove (WorkDir + '/' + InFileName)

  print("Import completed!")

#-----------------------------START Sentinel - 2A/B MSI Level 1C------------  

#-------------------------------S2-----------------------------------
#for command under Help = quick help = openS1Manual
def openS2Manual():
   import os
   os.startfile(sent_path +'\help\S2_quickhelp.pdf')


def openS2UH():
   import os
   os.startfile(sent_path +'\help\Sentinel2_User_Handbook.pdf')

#-----------------------------START Sentinel - 2A/B MSI Level 1C-----------  
#for command under S2 = MSI = 
def S2AB_L1C_MSI():

  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S2AB_L1C_MSI.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove((WorkDir.replace('\\','/')) + '/' + InFileName)

  print("Import completed!")

#-----------------------------END Sentinel - 2A MSI Level 1C------------  


#-----------------------------START Sentinel - 2A MSI Level 1C TCI -----------  
#for command under S2 = MSI = 
def S2AB_L1C_MSI_TCI():
  
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S2AB_L1C_MSI_TCI.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove((WorkDir.replace('\\','/')) + '/' + InFileName)

  print("Import completed!")

#-----------------------------END Sentinel - 2A MSI Level 1C TCI------------ 

#-----------------------------START Sentinel - 2A MSI Level 2-----------  
#for command under S2 = MSI = 
def S2AB_L2_MSI():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S2AB_L2_MSI.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove((WorkDir.replace('\\','/')) + '/' + InFileName)

  print("Import completed!")

#-----------------------------END Sentinel - 2A MSI Level 2------------  


#-----------------------------START Sentinel - 2A MSI Level 2 TCI -----------  
#for command under S2 = MSI = 
def S2AB_L2_MSI_TCI():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S2AB_L2_MSI_TCI.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove((WorkDir.replace('\\','/')) + '/' + InFileName)

  print("Import completed!")

#-----------------------------END Sentinel - 2A MSI Level 2 TCI------------ 




#-------------------------------S3-----------------------------------
#for command under Help = quick help = openS1Manual
def openS3Manual():
   import os
   os.startfile(sent_path +'\help\S3_quickhelp.pdf')

def openS3UH():
   import os
   os.startfile(sent_path +'\help\Sentinel3_User_Handbook.pdf')

#-----------------------------START Sentinel - 3 OLCI Level 1 EFR-----------  
#for command under S3 = OLCI = L1 = R
def S3_OL_L1_R():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S3_OL_L1_Land_FR_Rad.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove((WorkDir.replace('\\','/')) + '/' + InFileName)

  print("Import completed!")

#-----------------------------END Sentinel - 3 OLCI Level 1 EFR------------    


#-----------------------------START Sentinel - 3 SLSTR Level 1 EFR R-----------  
#for command under S3 = SLSTR = L1
def S3_RBT_L1_R():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S3_SLSTR_L1_Land_FR_Rad.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove((WorkDir.replace('\\','/')) + '/' + InFileName)

  print("Import completed!")
#-----------------------------END Sentinel - 3 SLSTR Level 1 EFR R------------    


#-----------------------------START Sentinel - 3 SLSTR Level 1 EFR TIR-----------  
#for command under S3 = SLSTR = L1
def S3_RBT_L1_BT():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S3_SLSTR_L1_Land_TIR_BT.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove((WorkDir.replace('\\','/')) + '/' + InFileName)

  print("Import completed!")
#-----------------------------END Sentinel - 3 SLSTR Level 1 EFR TIR------------   



#-----------------------------START Sentinel - 3 SLSTR Level 1 EFR F-----------  
#for command under S3 = SLSTR = L1
def S3_RBT_F_BT():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S3_SLSTR_L1_Land_F_BT.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove((WorkDir.replace('\\','/')) + '/' + InFileName)

  print("Import completed!")
#-----------------------------END Sentinel - 3 SLSTR Level 1 EFR F------------   


#-----------------------------START Sentinel - 3 OLCI Level 2 OGVI-----------  
#for command under S3 = L2 = OLCI = OVGI
def S3_OLCI_L2_OGVI():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S3_L2_Land_OGVI.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove (WorkDir + '/' + InFileName)

  print("Import completed!")
  
#-----------------------------END Sentinel - 3 OLCI Level 2 OGVI------------
  
#-----------------------------START Sentinel - 3 OLCI Level 2 OTCI-----------  
#for command under S3 = L2 = OLCI = OTCI
def S3_OLCI_L2_OTCI():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S3_L2_Land_OTCI.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove (WorkDir + '/' + InFileName)

  print("Import completed!")
  
#-----------------------------END Sentinel - 3 OLCI Level 2 OTCI------------


#-----------------------------START Sentinel - 3 SLSTR Level 2 LST-----------  
#for command under S3 = L2 = LST
def S3_LST_L2_LST():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S3_L2_Land_LST.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove (WorkDir + '/' + InFileName)
     os.remove (WorkDir + '/flags_in.nc')
 
  print("Import completed!")
#-----------------------------END Sentinel - 3 SLSTR Level 2 LST------------   



#-------------------------------S3-L2-Marine-----------------------------------
#for command under Help = quick help = openS1Manual
def openMarManual():
   import os
   os.startfile(sent_path +'\help\S3_CODA_EUMETCast_help.pdf')

def openOLCIMarUH():
   import os
   os.startfile(sent_path +'\help\Sentinel3_OLCI_Marine_Handbook.pdf')

def openSLSTRMarUH():
   import os
   os.startfile(sent_path +'\help\Sentinel3_SLSTR_Marine_Handbook.pdf')

#-----------------------------START Sentinel - 3 Marine OLCI Level 2 Ocean Colour-----------  
#for command under S3 Marine Level 2 OLCI Ocean colour - Reflectance
def S3_MAR_L2_OLCI_Refl():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S3_OL_L2_Mar_FR_Refl.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove (WorkDir + '/' + InFileName)

  print("Import completed!")

#for command under S3 Marine Level 2 OLCI Ocean colour - Chl Open Water
def S3_MAR_L2_OLCI_chl_oc4me():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S3_OL_L2_Mar_FR_chl_oc4me.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove (WorkDir + '/' + InFileName)
 
  print("Import completed!")


#for command under S3 Marine Level 2 OLCI Ocean colour - KD490 Open Water
def S3_MAR_L2_OLCI_trsp_KD490():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S3_OL_L2_Mar_FR_trsp.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove (WorkDir + '/' + InFileName)
 
  print("Import completed!")


#for command under S3 Marine Level 2 OLCI Ocean colour - Chl Complex Water
def S3_MAR_L2_OLCI_chl_nn():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S3_OL_L2_Mar_FR_chl_nn.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove (WorkDir + '/' + InFileName)
 
  print("Import completed!")


#for command under S3 Marine Level 2 OLCI Ocean colour - ADG443 Complex Water
def S3_MAR_L2_OLCI_iop_nn():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S3_OL_L2_Mar_FR_iop_nn.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove (WorkDir + '/' + InFileName)
 
  print("Import completed!")

#for command under S3 Marine Level 2 OLCI Ocean colour - TSM Complex Water
def S3_MAR_L2_OLCI_tsm_nn():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S3_OL_L2_Mar_FR_tsm_nn.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove (WorkDir + '/' + InFileName)
 
  print("Import completed!")

  
#-----------------------------END Sentinel - 3 Marine OLCI Level 2 Ocean Colour------------ 



#-----------------------------START Sentinel - 3 Marine SLSTR Level 2 WST-----------  
#for command under S3 Marine WST
def S3_MAR_L2_WST():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S3_Mar_L2_WST.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove (WorkDir + '/' + InFileName)

  print("Import completed!")
  
#-----------------------------END Sentinel - 3 SLSTR Level 2 WST------------  




#-------------------------------Generic SNAP DIMAP Import START-----------------------------------
#for command under Help = quick help = openS1Manual
def openImportSNAP():
   import os
   os.startfile(sent_path +'\help\Import_SNAPhelp.pdf')


#-------------------------------Generic SNAP DIMAP Import END-----------------------------------
   
#-----------------------------START SNAP DIMAP Import-----------  
#for command underImport from SNAP = Generic SNAP DIMAP Import
def SNAP_DIMAP_Import():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_SNAP_Dimap.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove (WorkDir + '/' + (InFileName[:-3]) +'img')
     os.remove (WorkDir + '/' + (InFileName[:-3]) +'hdr')

  print("Import completed!")

#-----------------------------END SNAP DIMAP Import------------  



#-------------------------------S5P- Tropomi HELP START-----------------------------------
#for command under Help = quick help = openS5PManual
def openS5PManual():
   import os
   os.startfile(sent_path +'\help\Sentinel5P_tropomi_quickhelp.pdf')
 
#for command under Help = Earth Weather = openEarthWeather
def open_Earth_Weather():
   #system should be connected to internet
   import webbrowser
   webbrowser.open ('https://earth.nullschool.net')
   
#-------------------------------S5P- Tropomi HELP END-----------------------------------

#-------------------------------S5P- Tropomi Level 2 Products-----------------------------------

 #for command under Help = Tropomi level 2 products
def open_Tropomi_level2_product_references():
   #system should be connected to internet
   import webbrowser
   webbrowser.open ('http://www.tropomi.eu/data-products/level-2-products')

#-----------------------------START Sentinel - 5P  Level 1b Quality Maps-----------  
#for command under S5P Level 1b
def import_S5P_l1b_qa():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S5P_L1b_quality_mask.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove (WorkDir + '/' + InFileName)

  print("Import completed!")
  
#-----------------------------END Sentinel - 5P  Level 1b Quality Maps------------    

#-----------------------------START Sentinel - 5P  Level Level 1B-----------  
#for command under S5P Level 1B
def import_S5P_L1B():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S5P_L1B.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']  

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove (WorkDir + '/' + InFileName)
     fileList = glob(WorkDir + '/' + OutFileName+'_Radiance_?.mp#')
     for filePath in fileList:
        try:
           os.remove(filePath)
        except:
           pass

     fileList = glob(WorkDir + '/' + OutFileName+'_Radiance_??.mp#')
     for filePath in fileList:
        try:
           os.remove(filePath)
        except:
           pass

     fileList = glob(WorkDir + '/' + OutFileName+'_Radiance_???.mp#')
     for filePath in fileList:
        try:
           os.remove(filePath)
        except:
           pass 

  print("Import completed!")
  
#-----------------------------END Sentinel - 5P  Level Level 1B------------ 

#-----------------------------START Sentinel - 5P  Level 2 Quality Maps-----------  
#for command under S5P Level NO2
def import_S5P_qa():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S5P_qa.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove (WorkDir + '/' + InFileName)

  print("Import completed!")
  
#-----------------------------END Sentinel - 5P  Level 2 Quality Maps------------ 

#-----------------------------START Sentinel - 5P  Level 2 CO-----------  
#for command under S5P Level CO
def import_S5P_CO_column():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S5P_CO_column.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove (WorkDir + '/' + InFileName)

  print("Import completed!")
  
#-----------------------------END Sentinel - 5P  Level 2 CO------------  

#-----------------------------START Sentinel - 5P  Level 2 HCHO-----------  
#for command under S5P Level HCHO
def import_S5P_HCHO_column():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S5P_HCHO_column.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove (WorkDir + '/' + InFileName)

  print("Import completed!")
  
#-----------------------------END Sentinel - 5P  Level 2 HCHO------------ 

#-----------------------------START Sentinel - 5P  Level 2 CH4-----------  
#for command under S5P Level CH4
def import_S5P_CH4_column():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S5P_CH4_column.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove (WorkDir + '/' + InFileName)

  print("Import completed!")
  
#-----------------------------END Sentinel - 5P  Level 2 CH4------------ 

#-----------------------------START Sentinel - 5P  Level 2 NO2-----------  
#for command under S5P Level NO2
def import_S5P_NO2_column():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S5P_NO2_column.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove (WorkDir + '/' + InFileName)

  print("Import completed!")
  
#-----------------------------END Sentinel - 5P  Level 2 NO2------------  

#-----------------------------START Sentinel - 5P  Level 2 SO2-----------  
#for command under S5P Level CH4
def import_S5P_SO2_column():
  from subprocess import Popen,PIPE
  pr1 = Popen(["pythonw",sent_path + '/lib/import_S5P_SO2_column.py'], stdout=PIPE, stderr=PIPE)
  pr1_stdout,pr1_stderr=pr1.communicate()
  pr1.wait()
  variables = {}
  stringlist = pr1_stdout.decode('ascii').splitlines()
  for element in stringlist:
     namevalue = element.split('=')
     if len(namevalue) == 2:
        variables[namevalue[0]] = namevalue[1]
     else:
        print(element)
  print(pr1_stderr)

#passing parameters from sub script

  InFileName = variables['inputFile']
  WorkDir = variables['outputDir']
  OutFileName = variables['outputFile']

  print (WorkDir, InFileName, OutFileName)

  if len(WorkDir) > 0 and len(InFileName) > 0 and os.path.exists(WorkDir + '/' + InFileName):
     #print('Deleting file: ' + WorkDir + '/' + InFileName)
     os.remove (WorkDir + '/' + InFileName)

  print("Import completed!")
  
#-----------------------------END Sentinel - 5P  Level 2 SO2------------ 

#-------------------------------START HELP-----------------------------------
#for command under Help = UserManual = openUserManual
def openUserManual():
   import os
   os.startfile(sent_path +'\help\Sentinel_manualV2.pdf')

#for command under Help = Further Info...= openFurtherInfo
#system should be connected to internet
def openFurtherInfo():
   import webbrowser
   webbrowser.open ('http://eo4sd-water.net/')


#for command under Help = About... = openAbout
def openAbout():
   filewin = Toplevel(root)
   filewin.title ('About')
   filewin.iconbitmap(sent_path +'\pics\esa.ico')
   filewin.geometry("500x335")
   msg = Message(filewin, text="""Background:

EO4SD – Earth Observation for Sustainable Development – is a new ESA initiative which aims to achieve a step increase in the uptake of satellite-based environmental information 
Further information on the other projects can be found at http://eo4sd.esa.int/about/
This toolbox supports the pre-processing on Sentinel data using low bandwidth for internet based data retrieval at ESA Science Hub and CODA portal but also supports marine products disseminated through EUMETCast

This is version 2 of the toolbox, with additional 
Sentinel 5 Precursor pre-processing routines
In case of comments, please contact the main developer:

Dr. Ben Maathuis
Department of Water Resources
Faculty ITC
University of Twente - the Netherlands
b.h.p.maathuis@utwente.nl""")
   msg.pack()



#for command under Help = License... = openN52L
def openN52L():
   import os
   os.startfile(sent_path +'/help/Sentinel_license.txt')

#-------------------------------HELP END------------------------------------




#set directory Sentinel toolbox
import os

sent_path = os.path.realpath('.')
print (sent_path)
os.chdir(sent_path)
os.environ["sent_lib"] = sent_path
   
root = Tk()
root.title("Sentinel EO4SD Toolbox V-2")
root.iconbitmap(sent_path +'\pics\esa.ico')
photo = PhotoImage(file=sent_path +'\pics\sentinel.gif')
label = Label(image=photo)

label.image = photo 
label.pack()

menubar = Menu(root)

confmenu = Menu(menubar, tearoff=0)
submenu1 = Menu(confmenu, tearoff=0)


S1menu = Menu(menubar, tearoff=0)
S1menu.add_command(label="Sentinel 1 Help", command=openS1Manual)
S1menu.add_command(label="Sentinel 1 User Handbook", command=openS1UH)
S1menu.add_separator()
S1menu.add_command(label="Sentinel 1A / B L1C GRD", command=S1AB_L1C_GRD)
menubar.add_cascade(label="Sentinel 1", menu=S1menu)


S2menu = Menu(menubar, tearoff=0)
S2menu.add_command(label="Sentinel 2 Help", command=openS2Manual)
S2menu.add_command(label="Sentinel 2 User Handbook", command=openS2UH)
S2menu.add_separator()

S2submenu = Menu(S2menu, tearoff=0)
S2submenu = Menu(S2submenu, tearoff=0)
S2submenu.add_command(label="Sentinel 2A / B L1C MSI Bands", command=S2AB_L1C_MSI)
S2submenu.add_command(label="Sentinel 2A / B L1C MSI TCI", command=S2AB_L1C_MSI_TCI)
S2menu.add_cascade(label='Level 1', menu=S2submenu)

S2submenu = Menu(S2menu, tearoff=0)
S2submenu = Menu(S2submenu, tearoff=0)
S2submenu.add_command(label="Sentinel 2A / B L2 MSI Bands", command=S2AB_L2_MSI)
S2submenu.add_command(label="Sentinel 2A / B L2 MSI TCI", command=S2AB_L2_MSI_TCI)
S2menu.add_cascade(label='Level 2', menu=S2submenu)
menubar.add_cascade(label="Sentinel 2", menu=S2menu)

S3menu = Menu(menubar, tearoff=0)
S3menu.add_command(label="Sentinel 3 Help", command=openS3Manual)
S3menu.add_command(label="Sentinel 3 User Handbook", command=openS3UH)
S3menu.add_separator()

S3submenu = Menu(S3menu, tearoff=0)
S3submenu = Menu(S3submenu, tearoff=0)
S3subsubmenu = Menu(S3submenu, tearoff=0)
S3subsubmenu.add_command(label='Radiance 01 - 21', command=S3_OL_L1_R)
S3submenu.add_cascade(label="OLCI", menu=S3subsubmenu)

S3subsubmenu = Menu(S3submenu, tearoff=0)
S3subsubmenu.add_command(label='VIS-SWIR', command=S3_RBT_L1_R)
S3subsubmenu.add_command(label='TIR', command=S3_RBT_L1_BT)
S3subsubmenu.add_command(label='F', command=S3_RBT_F_BT)
S3submenu.add_cascade(label="SLSTR", menu=S3subsubmenu)
S3menu.add_cascade(label='Level 1', menu=S3submenu)


S3submenu = Menu(S3menu, tearoff=0)
S3subsubmenu = Menu(S3submenu, tearoff=0)
S3subsubmenu.add_command(label='OGVI', command=S3_OLCI_L2_OGVI)
S3subsubmenu.add_command(label='OTCI', command=S3_OLCI_L2_OTCI)
S3submenu.add_cascade(label="OLCI", menu=S3subsubmenu)

S3subsubmenu = Menu(S3submenu, tearoff=0)
S3subsubmenu.add_command(label='LST', command=S3_LST_L2_LST)
S3submenu.add_cascade(label="SLSTR", menu=S3subsubmenu)
S3menu.add_cascade(label="Level 2", menu=S3submenu)
menubar.add_cascade(label="Sentinel 3 - Land", menu=S3menu)



S3mmenu = Menu(menubar, tearoff=0)
S3mmenu.add_command(label="S3 Marine Help", command=openMarManual)
S3mmenu.add_command(label="Sentinel 3 OLCI Marine Handbook", command=openOLCIMarUH)
S3mmenu.add_command(label="Sentinel 3 SLSTR Marine Handbook", command=openSLSTRMarUH)
S3mmenu.add_separator()

S3msubmenu = Menu(S3mmenu, tearoff=0)
S3msubmenu.add_command(label='OLCI Radiance 01 - 21', command=S3_OL_L1_R)
S3mmenu.add_cascade(label="Level 1", menu=S3msubmenu)

S3msubmenu = Menu(S3mmenu, tearoff=0)
S3msubmenu.add_command(label="OLCI - Reflectance", command=S3_MAR_L2_OLCI_Refl)
S3msubmenu.add_command(label="OLCI - Chl Open Water", command=S3_MAR_L2_OLCI_chl_oc4me)
S3msubmenu.add_command(label="OLCI - KD490 Open Water", command=S3_MAR_L2_OLCI_trsp_KD490)
S3msubmenu.add_command(label="OLCI - Chl Complex Water", command=S3_MAR_L2_OLCI_chl_nn)
S3msubmenu.add_command(label="OLCI - ADG443 Complex Water", command=S3_MAR_L2_OLCI_iop_nn)
S3msubmenu.add_command(label="OLCI - TSM Complex Water", command=S3_MAR_L2_OLCI_tsm_nn)
S3msubmenu.add_command(label="SLSTR - SST Skin", command=S3_MAR_L2_WST)
S3mmenu.add_cascade(label="Level 2", menu=S3msubmenu)
menubar.add_cascade(label="Sentinel 3 - Marine", menu=S3mmenu)



S5menu = Menu(menubar, tearoff=0)
S5menu.add_command(label="Sentinel 5P Help", command=openS5PManual)
S5menu.add_command(label="Earth Weather", command=open_Earth_Weather)
S5menu.add_separator()

S5submenu = Menu(S5menu, tearoff=0)
S5submenu = Menu(S5submenu, tearoff=0)
S5submenu.add_command(label='S5P Quality Map for L1b product', command=import_S5P_l1b_qa)
S5submenu.add_command(label='Level 1B B1 - 8 import', command=import_S5P_L1B)
S5menu.add_cascade(label='Level 1B ', menu=S5submenu)

S5submenu = Menu(S5menu, tearoff=0)
S5submenu = Menu(S5submenu, tearoff=0)
S5submenu.add_command(label='S5P Online Level 2 PUM/ATBD', command=open_Tropomi_level2_product_references)
S5submenu.add_command(label='S5P Quality Map for L2 products', command=import_S5P_qa)
S5submenu.add_command(label='Carbon Monoxide (CO)', command=import_S5P_CO_column)
S5submenu.add_command(label='Formaldehyde (HCHO)', command=import_S5P_HCHO_column)
S5submenu.add_command(label='Methane (CH4)', command=import_S5P_CH4_column)
S5submenu.add_command(label='Nitrogen Dioxide (NO2)', command=import_S5P_NO2_column)
S5submenu.add_command(label='Sulphur Dioxide (SO2)', command=import_S5P_SO2_column)
S5menu.add_cascade(label='Level 2', menu=S5submenu)
menubar.add_cascade(label="Sentinel 5P", menu=S5menu)


importmenu = Menu(menubar, tearoff=0)
importmenu.add_command(label="SNAP import Help", command=openImportSNAP)
importmenu.add_separator()
importmenu.add_command(label="Generic SNAP - DIMAP import", command=SNAP_DIMAP_Import)
menubar.add_cascade(label="Import from SNAP", menu=importmenu)

helpmenu = Menu(menubar, tearoff=0)
helpmenu.add_command(label="User Manual", command=openUserManual)
helpmenu.add_command(label="Further Info...", command=openFurtherInfo)
helpmenu.add_command(label="About...", command=openAbout)
helpmenu.add_command(label="License...", command=openN52L)
menubar.add_cascade(label="Help", menu=helpmenu)



w = 657 # width for the Tk root
h = 400 # height for the Tk root

# get screen width and height
ws = root.winfo_screenwidth() # width of the screen
hs = root.winfo_screenheight() # height of the screen

# calculate x and y coordinates for the Tk root window
x = (ws/2) - (w/2)
y = (hs/2) - (h/2)

# set the dimensions of the screen 
# and where it is placed
root.geometry('%dx%d+%d+%d' % (w, h, x, y))


#root.resizable(0,0)

root.config(menu=menubar)
root.mainloop()
