@echo off
echo Extract Level 1 FAO Frame version-2 NDVI


echo File name format L1_NDVI_mask_0901.tif
echo Data extracted for Sudan only

echo.
echo.

set longfilename=%1
set shortfilename1=%longfilename:~0,4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%


echo your current working directory = %OutputDrive%\%OutputDir%
echo.
echo.

echo off
if not exist "%InputDrive%\%InputDir%\L1_NDVI_mask_%shortfilename1%.tif"  goto MESSAGE
echo The file(s) "L1_NDVI_mask_%shortfilename1%.tif" is available in the archive and will be transferred to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found in the archive.
echo Check your Date stamp settings
echo Your current Date stamp used is %shortfilename1%
echo Data is retrieved from ITC internal resources
echo Check if data access is granted

pause

GOTO END

:START
copy "%InputDrive%\%InputDir%\L1_NDVI_mask_%shortfilename1%.tif"
"%GdalDir%\gdal_translate.exe" -of ilwis -projwin 20.84 22.834 40.586 8.314 %OutputDrive%\%OutputDir%\L1_NDVI_mask_%shortfilename1%.tif %OutputDrive%\%OutputDir%\L1_NDVI_%shortfilename1%.mpr

"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\L1_NDVI_%shortfilename1%'.mpr '%utildir%\sudan'


rem delete obsolete objects

if exist "%OutputDrive%\%OutputDir%\L1_NDVI_mask_%shortfilename1%.tif" del "%OutputDrive%\%OutputDir%\L1_NDVI_mask_%shortfilename1%.tif"
if exist "%OutputDrive%\%OutputDir%\L1_NDVI_%shortfilename1%.grf" del "%OutputDrive%\%OutputDir%\L1_NDVI_%shortfilename1%.grf"
if exist "%OutputDrive%\%OutputDir%\L1_NDVI_%shortfilename1%.csy" del "%OutputDrive%\%OutputDir%\L1_NDVI_%shortfilename1%.csy"
if exist "%OutputDrive%\%OutputDir%\L1_NDVI_%shortfilename1%.mpr.aux.xml" del "%OutputDrive%\%OutputDir%\L1_NDVI_%shortfilename1%.mpr.aux.xml"

:END
"%IlwDir%\ilwis.exe" -C closeall