@echo off
echo Extracted CHIRPS Africa PCP per dekad
echo Dekad temporal resolution!
echo Data downloaded and preprocessed for the Africa window


echo File name format chirps_0801.tif
echo Data extracted for Sudan only
echo Data resampled using NN resampling

echo.
echo.

set longfilename=%1
set shortfilename1=%longfilename:~0,4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%


echo your current working directory = %OutputDrive%\%OutputDir%
echo.
echo.

echo off
if not exist "%InputDrive%\%InputDir%\chirps_%shortfilename1%.tif"  goto MESSAGE
echo The file(s) "chirps_%shortfilename1%.tif" is available in the archive and will be transferred to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found in the archive.
echo Check your Date stamp settings
echo Your current Date stamp used is %shortfilename1%
echo Data is retrieved from ITC internal resources
echo Check if data access is granted

pause

GOTO END

:START
copy "%InputDrive%\%InputDir%\chirps_%shortfilename1%.tif"

"%GdalDir%\gdal_translate.exe" -of ilwis %OutputDrive%\%OutputDir%\chirps_%shortfilename1%.tif %OutputDrive%\%OutputDir%\L1_PCP.mpr

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\chirps_%shortfilename1%'.mpr:=MapResample('%OutputDrive%\%OutputDir%\L1_PCP',sudan.grf,nearest)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\L1_chirps_%shortfilename1%'{dom=value;vr=0:1000:1}:=('%OutputDrive%\%OutputDir%\chirps_%shortfilename1%')



rem delete obsolete objects

if exist "%OutputDrive%\%OutputDir%\chirps_%shortfilename1%.tif" del "%OutputDrive%\%OutputDir%\chirps_%shortfilename1%.tif"
if exist "%OutputDrive%\%OutputDir%\chirps_%shortfilename1%.grf" del "%OutputDrive%\%OutputDir%\chirps_%shortfilename1%.grf"
if exist "%OutputDrive%\%OutputDir%\chirps_%shortfilename1%.csy" del "%OutputDrive%\%OutputDir%\chirps_%shortfilename1%.csy"
if exist "%OutputDrive%\%OutputDir%\chirps_%shortfilename1%.mpr.aux.xml" del "%OutputDrive%\%OutputDir%\chirps_%shortfilename1%.mpr.aux.xml"
if exist "%OutputDrive%\%OutputDir%\L1_PCP.mp*" del "%OutputDrive%\%OutputDir%\L1_PCP.mp*"
if exist "%OutputDrive%\%OutputDir%\L1_PCP.grf" del "%OutputDrive%\%OutputDir%\L1_PCP.grf"
if exist "%OutputDrive%\%OutputDir%\L1_PCP.csy" del "%OutputDrive%\%OutputDir%\L1_PCP.csy"
if exist "%OutputDrive%\%OutputDir%\chirps_%shortfilename1%.mp*" del "%OutputDrive%\%OutputDir%\chirps_%shortfilename1%.mp*"

:END
"%IlwDir%\ilwis.exe" -C closeall