@echo off
echo Extract Level 2 FAO Frame version-2 NPP
echo I in mm/dekad

echo File name format L2_ETH_NPP_0901.tif
echo Data extracted for Amhara Region in Ethiopia only

echo.
echo.

set longfilename=%1
set shortfilename1=%longfilename:~0,4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%


echo your current working directory = %OutputDrive%\%OutputDir%
echo.
echo.

echo off
if not exist "%InputDrive%\%InputDir%\L2_ETH_NPP_%shortfilename1%.tif"  goto MESSAGE
echo The file(s) "L2_ETH_NPP_%shortfilename1%.tif" is available in the archive and will be transferred to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found in the archive.
echo Check your Date stamp settings
echo Your current Date stamp used is %shortfilename1%
echo Data is retrieved from ITC internal resources
echo Check if data access is granted

pause

GOTO END

:START
copy "%InputDrive%\%InputDir%\L2_ETH_NPP_%shortfilename1%.tif"


"%GdalDir%\gdal_translate.exe" -of ilwis -ot int16 -projwin 35.234622222222 13.802083333333 40.266369444444 8.717758333333 %OutputDrive%\%OutputDir%\L2_ETH_NPP_%shortfilename1%.tif %OutputDrive%\%OutputDir%\L2_NPP_%shortfilename1%.mpr > NUL 2>&1

"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\L2_NPP_%shortfilename1%'.mpr '%utildir%\amhara_100'


rem delete obsolete objects

if exist "%OutputDrive%\%OutputDir%\L2_ETH_NPP_%shortfilename1%.tif" del "%OutputDrive%\%OutputDir%\L2_ETH_NPP_%shortfilename1%.tif"
if exist "%OutputDrive%\%OutputDir%\L2_NPP_%shortfilename1%.grf" del "%OutputDrive%\%OutputDir%\L2_NPP_%shortfilename1%.grf"
if exist "%OutputDrive%\%OutputDir%\L2_NPP_%shortfilename1%.csy" del "%OutputDrive%\%OutputDir%\L2_NPP_%shortfilename1%.csy"
if exist "%OutputDrive%\%OutputDir%\L2_NPP_%shortfilename1%.mpr.aux.xml" del "%OutputDrive%\%OutputDir%\L2_NPP_%shortfilename1%.mpr.aux.xml"

:END
"%IlwDir%\ilwis.exe" -C closeall