/*
 * Decompiled with CFR 0.152.
 */
package org.n52.math;

import org.n52.math.AbstractAlgorithm;
import org.n52.math.Algorithm;
import org.n52.math.TerrainTriangulation;
import org.n52.math.Vector3D;

public class SatelliteTriangulation {
    private double lat = Double.NaN;
    private double lon = Double.NaN;
    private final double satPsi;
    private final double satLam;
    private final double pixelSizeAtNadir;
    private final double satOrbitRadius;
    private final double satHeight;
    private Vector3D satellitePosition = null;
    private TerrainTriangulation terrTriangulation;
    private double zenithAngle;
    private double azimuth;
    private double distance;
    private double pixelSize;
    private boolean zenithAngleCalculated;
    private boolean azimuthCalculated;
    private boolean distanceCalculated;
    private boolean pixelSizeCalculated;
    private static final String[] paramNames = new String[]{"lat", "lon"};
    private static final String[] paramDescr = new String[]{"latitude in degrees at terrain location", "longitude in degrees at terrain location"};

    public SatelliteTriangulation(TerrainTriangulation terrTri, double satLat, double satLon, double pixNadir, double satOrbitRadius) {
        this.terrTriangulation = terrTri;
        this.satPsi = satLat * Math.PI / 180.0;
        this.satLam = satLon * Math.PI / 180.0;
        this.pixelSizeAtNadir = pixNadir;
        this.satOrbitRadius = satOrbitRadius;
        this.satHeight = satOrbitRadius - terrTri.getEquatorRadius();
        this.clear();
    }

    private Vector3D getSatellitePositionVector() {
        if (this.satellitePosition == null) {
            Vector3D vec = new Vector3D();
            double posRadius = this.satOrbitRadius;
            vec.set(0, posRadius * Math.cos(this.satLam) * Math.cos(this.satPsi));
            vec.set(1, posRadius * Math.sin(this.satLam) * Math.cos(this.satPsi));
            vec.set(2, posRadius * Math.sin(this.satPsi));
            this.satellitePosition = vec;
        }
        return this.satellitePosition;
    }

    private Vector3D getTerrainToSatelliteVector(Vector3D vecTerrainPosition, Vector3D vecSatellitePosition) {
        return vecSatellitePosition.minus(vecTerrainPosition);
    }

    private double getZenithToSatelliteAngle(Vector3D vecTerrVerticalUnitVector, Vector3D vecTerrToSatellite) {
        double norm = vecTerrToSatellite.normF();
        Vector3D U2 = vecTerrToSatellite.times(1.0 / norm);
        return Math.acos(vecTerrVerticalUnitVector.dotProduct(U2));
    }

    private double getDistanceToSatellite(Vector3D vecTerrToSatellite) {
        double norm = vecTerrToSatellite.normF();
        return norm;
    }

    private void check(double lat, double lon) {
        if (this.lat != lat || this.lon != lon) {
            this.clear();
            this.lat = lat;
            this.lon = lon;
        }
    }

    private void clear() {
        this.zenithAngleCalculated = false;
        this.azimuthCalculated = false;
        this.distanceCalculated = false;
        this.pixelSizeCalculated = false;
    }

    private double getZenithAngle(double lat, double lon) {
        this.check(lat, lon);
        if (!this.zenithAngleCalculated) {
            Vector3D unitV1 = this.terrTriangulation.getUnitVerticalVector(lat, lon);
            Vector3D posVecTerr = this.terrTriangulation.getTerrainPositionVector(lat, lon);
            Vector3D posVecSat = this.getSatellitePositionVector();
            Vector3D V2 = this.getTerrainToSatelliteVector(posVecTerr, posVecSat);
            Vector3D unitV2 = V2.times(1.0 / V2.normF());
            this.zenithAngleCalculated = true;
            this.zenithAngle = Math.acos(unitV1.dotProduct(unitV2)) * 180.0 / Math.PI;
        }
        return this.zenithAngle;
    }

    private double getAzimuth(double lat, double lon) {
        this.check(lat, lon);
        if (!this.azimuthCalculated) {
            Vector3D unitNorth = this.terrTriangulation.getUnitNorthVector(lat, lon);
            Vector3D unitEast = this.terrTriangulation.getUnitEastVector(lat, lon);
            Vector3D posVecTerr = this.terrTriangulation.getTerrainPositionVector(lat, lon);
            Vector3D posVecSat = this.getSatellitePositionVector();
            Vector3D V2 = this.getTerrainToSatelliteVector(posVecTerr, posVecSat);
            Vector3D unitV2 = V2.times(1.0 / V2.normF());
            double nort = unitNorth.dotProduct(unitV2);
            double east = unitEast.dotProduct(unitV2);
            this.azimuth = Math.atan2(east, nort) * 180.0 / Math.PI;
            if (this.azimuth < 0.0) {
                this.azimuth += 360.0;
            }
            this.azimuthCalculated = true;
        }
        return this.azimuth;
    }

    private double getDistance(double lat, double lon) {
        this.check(lat, lon);
        if (!this.distanceCalculated) {
            Vector3D posVecTerr = this.terrTriangulation.getTerrainPositionVector(lat, lon);
            Vector3D posVecSat = this.getSatellitePositionVector();
            Vector3D V2 = this.getTerrainToSatelliteVector(posVecTerr, posVecSat);
            this.distanceCalculated = true;
            this.distance = V2.length();
        }
        return this.distance;
    }

    private double getPixelSize(double lat, double lon) {
        this.check(lat, lon);
        if (!this.pixelSizeCalculated) {
            Vector3D unitV1 = this.terrTriangulation.getUnitVerticalVector(lat, lon);
            Vector3D posVecTerr = this.terrTriangulation.getTerrainPositionVector(lat, lon);
            Vector3D posVecSat = this.getSatellitePositionVector();
            Vector3D V2 = this.getTerrainToSatelliteVector(posVecTerr, posVecSat);
            double dist = V2.length();
            Vector3D unitV2 = V2.times(1.0 / V2.normF());
            double cosZenithAngle = unitV1.dotProduct(unitV2);
            this.pixelSize = cosZenithAngle < 1.0E-4 ? Double.NaN : this.pixelSizeAtNadir * dist / cosZenithAngle / this.satHeight;
        }
        return this.pixelSize;
    }

    public Algorithm getZenithAngleAlgorithm() {
        return new AbstractAlgorithm("Zenith Angle", "angle between local vertical and satellite direction", paramNames, paramDescr){

            public double calculate(double[] params) {
                return SatelliteTriangulation.this.getZenithAngle(params[0], params[1]);
            }
        };
    }

    public Algorithm getAzimuthAlgorithm() {
        return new AbstractAlgorithm("Azimuth", "angle between local North and projected satellite direction", paramNames, paramDescr){

            public double calculate(double[] params) {
                return SatelliteTriangulation.this.getAzimuth(params[0], params[1]);
            }
        };
    }

    public Algorithm getDistanceAlgorithm() {
        return new AbstractAlgorithm("Distance", "distance from terrain point to satellite", paramNames, paramDescr){

            public double calculate(double[] params) {
                return SatelliteTriangulation.this.getDistance(params[0], params[1]);
            }
        };
    }

    public Algorithm getPixelSizeAlgorithm() {
        return new AbstractAlgorithm("Pixel Size", "area per pixel at location in square km", paramNames, paramDescr){

            public double calculate(double[] params) {
                return SatelliteTriangulation.this.getPixelSize(params[0], params[1]);
            }
        };
    }
}

