/*
 * Decompiled with CFR 0.152.
 */
package org.n52.math.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.n52.math.Algorithm;
import org.n52.math.SunTriangulation;
import org.n52.math.TerrainTriangulation;

public class SunTriangulationTest
extends TestCase {
    private double epsilon = 1.0E-10;
    private SunTriangulation sep21_2005;
    private SunTriangulation jan1_2005_0am;
    private SunTriangulation jan1_2005_12am;
    private SunTriangulation oct16_2005_10am;
    private TerrainTriangulation wgs84;
    private final double EQRADIUSWGS84 = 6378137.0;
    private final double INVFWGS84 = 298.257223563;

    private void setEpsilon(double eps) {
        this.epsilon = eps;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.wgs84 = new TerrainTriangulation(6378137.0, 298.257223563);
        this.sep21_2005 = new SunTriangulation(this.wgs84, 2005, 9, 21, 12.0);
        this.jan1_2005_0am = new SunTriangulation(this.wgs84, 2005, 1, 1, 0.0);
        this.jan1_2005_12am = new SunTriangulation(this.wgs84, 2005, 1, 1, 12.0);
        this.oct16_2005_10am = new SunTriangulation(this.wgs84, 2005, 10, 16, 10.0);
        this.setEpsilon(1.0E-5);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSunDistanceAtOct16_10hrsNorth() {
        Algorithm distAlg = this.oct16_2005_10am.getDistanceAlgorithm();
        double[] latlon = new double[]{72.0, 6.0};
        double r = 1.0 / Math.sqrt(1.0064);
        Assert.assertEquals((Object)r, (Object)distAlg.calculate(latlon));
    }

    public void testSunDistanceAtOct16_10hrsEquator() {
        Algorithm distAlg = this.oct16_2005_10am.getDistanceAlgorithm();
        double[] latlon = new double[]{0.0, 0.0};
        double r = 1.0 / Math.sqrt(1.0064);
        Assert.assertEquals((Object)r, (Object)distAlg.calculate(latlon));
    }

    public void testDeclinationAtOct16_10hrsDeBilt() {
        Algorithm zenAngleAlg = this.oct16_2005_10am.getSunDeclinationAlgorithm();
        double[] latlon = new double[]{52.0, 6.0};
        double zA = -8.67;
        Assert.assertEquals((Object)zA, (Object)zenAngleAlg.calculate(latlon));
    }

    public void testDeclinationAtOct16_10hrsBuenosAires() {
        Algorithm zenAngleAlg = this.oct16_2005_10am.getSunDeclinationAlgorithm();
        double[] latlon = new double[]{-40.0, -58.29};
        double zA = -8.67;
        Assert.assertEquals((Object)zA, (Object)zenAngleAlg.calculate(latlon));
    }

    public void testZenithAngleAtOct16_10hrsDeBilt() {
        Algorithm zenAngleAlg = this.oct16_2005_10am.getZenithAngleAlgorithm();
        double[] latlon = new double[]{52.0, 5.0};
        double zA = 63.6666;
        Assert.assertEquals((Object)zA, (Object)zenAngleAlg.calculate(latlon));
    }
}

