/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation.cropmodeling;

import java.util.Calendar;
import java.util.TimeZone;
import org.n52.math.AlgorithmOnValues;
import org.n52.operation.cropmodeling.GridWeatherData;
import org.n52.operation.cropmodeling.JulianTime;
import org.n52.operation.cropmodeling.TemporalEnvironmentState;

public class TemperatureModelAlgorithm
implements AlgorithmOnValues {
    GridWeatherData weatherData = new GridWeatherData();
    protected Calendar cal;
    double resolution;
    double lat;

    public void setLatitude(double lat) {
        this.lat = lat;
    }

    public void setResolution(double resolution) {
        this.resolution = resolution;
    }

    public void setStartTime(int year, int month, int day, int hours, int minutes) {
        TimeZone zone = TimeZone.getTimeZone("GMT+0");
        this.cal = Calendar.getInstance(zone);
        this.cal.set(year, month, day, hours, minutes, 0);
        this.cal.get(1);
    }

    public double[] calculate(double[] temperatures) {
        if (temperatures == null) {
            throw new IllegalArgumentException("Unexpected parameter value");
        }
        JulianTime start = new JulianTime(this.lat, this.cal);
        this.weatherData.setTemperatures(temperatures, start, this.resolution);
        this.weatherData.setUseRealData(false);
        JulianTime begin = this.weatherData.getBeginMeasurements();
        JulianTime end = JulianTime.subtract(this.weatherData.getEndMeasurements(), 48.0);
        TemporalEnvironmentState startState = new TemporalEnvironmentState("grid", this.weatherData, begin);
        TemporalEnvironmentState endState = new TemporalEnvironmentState("grid", this.weatherData, end);
        double[] res = new double[1440 - (int)(2880.0 / this.resolution) + 1];
        int i = 0;
        TemporalEnvironmentState current = startState;
        while (JulianTime.less(current.getTime(), endState.getTime())) {
            double temp = current.getCurrentWeather().getCurrentTemperature(current.getTime());
            res[i++] = temp;
            current.setTime(JulianTime.add(current.getTime(), this.resolution / 60.0));
        }
        return res;
    }
}

