/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation.cropmodeling;

import org.n52.operation.cropmodeling.DayWeatherData;
import org.n52.operation.cropmodeling.InterpolatedWeather;
import org.n52.operation.cropmodeling.JulianTime;
import org.n52.operation.cropmodeling.WeatherData;

public class Weather {
    protected WeatherData weatherData;

    DayWeatherData getWeatherData(JulianTime time) {
        return this.weatherData.getDayWeatherData(time);
    }

    double getWeatherData(JulianTime time, String attributeName) {
        return this.weatherData.getDayWeatherData(time).getAttributeData(attributeName);
    }

    Weather(WeatherData d) {
        this.weatherData = d;
    }

    double getCurrentTemperature(JulianTime time) {
        DayWeatherData dwd = this.weatherData.getDayWeatherData(time);
        return dwd.getDailyAverageTemperature();
    }

    double getCurrentTemperatureFromData(JulianTime time) {
        return this.weatherData.getCurrentTemperatureFromData(time);
    }

    double getAverageIntervalTemperature(double MinTemp, double MaxTemp) {
        return 0.0;
    }

    double getTemperatureCorrectionFactor(JulianTime time) {
        double tMain;
        DayWeatherData dwd = this.weatherData.getDayWeatherData(time);
        double dailyAverageTemperature = dwd.getDailyAverageTemperature();
        if (dailyAverageTemperature > (tMain = this.getReferenceTemperature(time))) {
            return Math.pow(2.0, (dailyAverageTemperature - tMain) / 10.0);
        }
        return dailyAverageTemperature / tMain;
    }

    double getReferenceTemperature(JulianTime time) {
        int currentDay = time.getCurrentJulianDay();
        JulianTime begin = this.weatherData.getBeginMeasurements();
        int interval = 10;
        int beginInterval = currentDay - begin.getCurrentJulianDay() - interval;
        if (beginInterval < 1) {
            interval = 10 + beginInterval;
            beginInterval = 1;
        }
        double average = 0.0;
        int count = 0;
        int day = beginInterval;
        while (day < beginInterval + interval) {
            JulianTime intervalTime = new JulianTime(time.getAtLatitude(), time.getYear(), (double)day * 24.0);
            DayWeatherData dwd = this.weatherData.getDayWeatherData(intervalTime);
            if (dwd != null) {
                double dailyAverageTemperature = dwd.getDailyAverageTemperature();
                average = dailyAverageTemperature > 15.0 && dailyAverageTemperature < 30.0 ? (average += dailyAverageTemperature) : (average += 15.0);
                ++count;
            }
            ++day;
        }
        if (count > 0) {
            return average / (double)count;
        }
        return this.weatherData.getDayWeatherData(time).getDailyAverageTemperature();
    }

    static Weather create(String type, WeatherData wd) {
        if (type == "wageningen") {
            return new InterpolatedWeather(wd);
        }
        if (type == "grid") {
            return new InterpolatedWeather(wd);
        }
        return new Weather(wd);
    }

    double getDailyDiffuseRadiation(JulianTime time) {
        double[] rads = this.weatherData.getDailyDiffuseRadiations(time);
        double total = 0.0;
        int i = 0;
        while (i < rads.length) {
            if (rads[i] > 0.0) {
                total += rads[i] * 10.0 * 60.0 / 1000000.0;
            }
            ++i;
        }
        return total;
    }

    double getDailyDirectRadiation(JulianTime time) {
        double[] rads = this.weatherData.getDailyDirectRadiations(time);
        double total = 0.0;
        int i = 0;
        while (i < rads.length) {
            if (rads[i] > 0.0) {
                total += rads[i] * 10.0 * 60.0 / 1000000.0;
            }
            ++i;
        }
        return total;
    }

    WeatherData getWeatherData() {
        return this.weatherData;
    }
}

