/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation.smac;

import java.io.IOException;
import org.n52.math.AbstractAlgorithm;
import org.n52.math.Algorithm;
import org.n52.math.testforms.AlgorithmForm;
import org.n52.operation.smac.CoeffData;

public class SmacAlgorithm
extends AbstractAlgorithm
implements Algorithm {
    private static final String[] paramNames = new String[]{"Reflectance", "Optical Depth", "Water Vapour", "Ozone", "Pressure", "Solar Zenith", "Solar Azimuth", "Satellite Zenith", "Satellite Azimuth"};
    private static final String[] paramDescr = new String[]{"Reflectance at top of atmosphere", "Continental aerosol optical depth at 550nm", "Water vapour content (g/cm2)", "Ozone content (atm.cm)", "Surface Pressure (hPa)", "Solar Zenith Angle (degree)", "Solar Azimuth (degree)", "Satellite Zenith Angle (degree)", "Satellite Azimuth (degree)"};
    private final CoeffData coeff;

    SmacAlgorithm(String coeffDataFileName) throws IOException {
        super("SMAC", "SMAC Athmospheric Correction", paramNames, paramDescr);
        this.coeff = new CoeffData(coeffDataFileName);
    }

    public double calculate(double[] params) {
        double r_toa = params[0];
        double taup550 = params[1];
        double uh2o = params[2];
        double uo3 = params[3];
        double pression = params[4];
        double tetas = params[5];
        double phis = params[6];
        double tetav = params[7];
        double phiv = params[8];
        if (taup550 < 0.05 || taup550 > 0.8) {
            throw new IllegalArgumentException("Optical depth at 550nm expected between 0.05 and 0.8");
        }
        if (uh2o < 0.0 || uh2o > 6.0) {
            throw new IllegalArgumentException("Vapour value expected between 0.0 and 6.0");
        }
        if (uo3 < 0.0 || uo3 > 0.7) {
            throw new IllegalArgumentException("Ozone content value expected between 0.0 and 0.7");
        }
        if (pression < 800.0 || pression > 1200.0) {
            throw new IllegalArgumentException("Surface pressure expected in hPa, thus approximately 1013 hPa");
        }
        if (Math.abs(tetas) > 360.0) {
            throw new IllegalArgumentException("Solar Zenith Angle expected in degrees");
        }
        if (Math.abs(phis) > 360.0) {
            throw new IllegalArgumentException("Solar Azimuth expected in degrees");
        }
        if (Math.abs(tetav) > 360.0) {
            throw new IllegalArgumentException("Satellite Zenith Angle expected in degrees");
        }
        if (Math.abs(phiv) > 360.0) {
            throw new IllegalArgumentException("Satellite Azimuth expected in degrees");
        }
        return this.applySmac(r_toa, taup550, uh2o, uo3, pression, tetas, phis, tetav, phiv);
    }

    private double applySmac(double r_toa, double taup550, double uh2o, double uo3, double pression, double tetas, double phis, double tetav, double phiv) {
        double crd = 57.29577951308232;
        double cdr = Math.PI / 180;
        double us = Math.cos(tetas * cdr);
        double uv = Math.cos(tetav * cdr);
        double dphi = (phis - phiv) * cdr;
        double Peq = pression / 1013.0;
        double m = 1.0 / us + 1.0 / uv;
        double taup = this.coeff.a0taup + this.coeff.a1taup * taup550;
        double to3 = 1.0;
        double th2o = 1.0;
        double to2 = 1.0;
        double tco2 = 1.0;
        double tch4 = 1.0;
        double tno2 = 1.0;
        double tco = 1.0;
        double uo2 = Math.pow(Peq, this.coeff.po2);
        double uco2 = Math.pow(Peq, this.coeff.pco2);
        double uch4 = Math.pow(Peq, this.coeff.pch4);
        double uno2 = Math.pow(Peq, this.coeff.pno2);
        double uco = Math.pow(Peq, this.coeff.pco);
        if (uh2o > 0.0 || uo3 > 0.0) {
            to3 = Math.exp(this.coeff.ao3 * Math.pow(uo3 * m, this.coeff.no3));
            th2o = Math.exp(this.coeff.ah2o * Math.pow(uh2o * m, this.coeff.nh2o));
            to2 = Math.exp(this.coeff.ao2 * Math.pow(uo2 * m, this.coeff.no2));
            tco2 = Math.exp(this.coeff.aco2 * Math.pow(uco2 * m, this.coeff.nco2));
            tch4 = Math.exp(this.coeff.ach4 * Math.pow(uch4 * m, this.coeff.nch4));
            tno2 = Math.exp(this.coeff.ano2 * Math.pow(uno2 * m, this.coeff.nno2));
            tco = Math.exp(this.coeff.aco * Math.pow(uco * m, this.coeff.nco));
        }
        double ttetas = this.coeff.a0T + this.coeff.a1T * taup550 / us + (this.coeff.a2T * Peq + this.coeff.a3T) / (1.0 + us);
        double ttetav = this.coeff.a0T + this.coeff.a1T * taup550 / uv + (this.coeff.a2T * Peq + this.coeff.a3T) / (1.0 + uv);
        double s = this.coeff.a0s * Peq + this.coeff.a3s + this.coeff.a1s * taup550 + this.coeff.a2s * Math.pow(taup550, 2.0);
        double cksi = -(us * uv + Math.sqrt(1.0 - us * us) * Math.sqrt(1.0 - uv * uv) * Math.cos(dphi));
        if (cksi < -1.0) {
            cksi = -1.0;
        }
        double ksiD = crd * Math.acos(cksi);
        double ray_phase = 0.7190443 * (1.0 + cksi * cksi) + 0.0412742;
        double taurz = this.coeff.taur * Peq;
        double ray_ref = taurz * ray_phase / (4.0 * us * uv);
        double Res_ray = this.coeff.Resr1 + this.coeff.Resr2 * taurz * ray_phase / (us * uv) + this.coeff.Resr3 * Math.pow(taurz * ray_phase / (us * uv), 2.0);
        double aer_phase = this.coeff.a0P + this.coeff.a1P * ksiD + this.coeff.a2P * ksiD * ksiD + this.coeff.a3P * Math.pow(ksiD, 3.0) + this.coeff.a4P * Math.pow(ksiD, 4.0);
        double ak2 = (1.0 - this.coeff.wo) * (3.0 - this.coeff.wo * 3.0 * this.coeff.gc);
        double ak = Math.sqrt(ak2);
        double e = -3.0 * us * us * this.coeff.wo / (4.0 * (1.0 - ak2 * us * us));
        double f = -(1.0 - this.coeff.wo) * 3.0 * this.coeff.gc * us * us * this.coeff.wo / (4.0 * (1.0 - ak2 * us * us));
        double dp = e / (3.0 * us) + us * f;
        double d = e + f;
        double b = 2.0 * ak / (3.0 - this.coeff.wo * 3.0 * this.coeff.gc);
        double del = Math.exp(ak * taup) * (1.0 + b) * (1.0 + b) - Math.exp(-ak * taup) * (1.0 - b) * (1.0 - b);
        double ww = this.coeff.wo / 4.0;
        double ss = us / (1.0 - ak2 * us * us);
        double q1 = 2.0 + 3.0 * us + (1.0 - this.coeff.wo) * 3.0 * this.coeff.gc * us * (1.0 + 2.0 * us);
        double q2 = 2.0 - 3.0 * us - (1.0 - this.coeff.wo) * 3.0 * this.coeff.gc * us * (1.0 - 2.0 * us);
        double q3 = q2 * Math.exp(-taup / us);
        double c1 = ww * ss / del * (q1 * Math.exp(ak * taup) * (1.0 + b) + q3 * (1.0 - b));
        double c2 = -(ww * ss / del) * (q1 * Math.exp(-ak * taup) * (1.0 - b) + q3 * (1.0 + b));
        double cp1 = c1 * ak / (3.0 - this.coeff.wo * 3.0 * this.coeff.gc);
        double cp2 = -c2 * ak / (3.0 - this.coeff.wo * 3.0 * this.coeff.gc);
        double z = d - this.coeff.wo * 3.0 * this.coeff.gc * uv * dp + this.coeff.wo * aer_phase / 4.0;
        double x = c1 - this.coeff.wo * 3.0 * this.coeff.gc * uv * cp1;
        double y = c2 - this.coeff.wo * 3.0 * this.coeff.gc * uv * cp2;
        double aa1 = uv / (1.0 + ak * uv);
        double aa2 = uv / (1.0 - ak * uv);
        double aa3 = us * uv / (us + uv);
        double aer_ref = x * aa1 * (1.0 - Math.exp(-taup / aa1));
        aer_ref += y * aa2 * (1.0 - Math.exp(-taup / aa2));
        aer_ref += z * aa3 * (1.0 - Math.exp(-taup / aa3));
        double Res_aer = this.coeff.Resa1 + this.coeff.Resa2 * (taup * m * cksi) + this.coeff.Resa3 * Math.pow(taup * m * cksi, 2.0) + this.coeff.Resa4 * Math.pow(taup * m * cksi, 3.0);
        double tautot = taup + taurz;
        double Res_6s = this.coeff.Rest1 + this.coeff.Rest2 * (tautot * m * cksi) + this.coeff.Rest3 * Math.pow(tautot * m * cksi, 2.0) + this.coeff.Rest4 * Math.pow(tautot * m * cksi, 3.0);
        double atm_ref = ray_ref - Res_ray + (aer_ref /= us * uv) - Res_aer + Res_6s;
        double tg = th2o * to3 * to2 * tco2 * tch4 * tco * tno2;
        double r_surf = r_toa - atm_ref * tg;
        r_surf /= tg * ttetas * ttetav + r_surf * s;
        return r_surf;
    }

    public static void main(String[] args) throws IOException {
        String coeffile = args[0];
        SmacAlgorithm alg = new SmacAlgorithm(coeffile);
        double[] defaults = new double[]{50.0, 0.5, 0.0, 0.0, 1013.0, 0.0, 0.0, 0.0, 0.0};
        AlgorithmForm frame = new AlgorithmForm(alg, defaults);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

