/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.dom;

import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.core.Assert;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppDomReader;
import com.thoughtworks.xstream.io.xml.xppdom.XppDom;
import java.io.StringWriter;
import java.util.HashMap;

public class XppDomElement
implements DomElement {
    private final XppDom xppDom;
    private DomElement parent;
    private HashMap<XppDom, DomElement> children;

    public XppDomElement(String name) {
        this(new XppDom(name));
    }

    public XppDomElement(XppDom xppDom) {
        Assert.notNull(xppDom, "xppDom");
        Assert.notNull(xppDom.getName(), "xppDom.getName()");
        this.xppDom = xppDom;
    }

    public XppDom getXppDom() {
        return this.xppDom;
    }

    @Override
    public String getName() {
        return this.xppDom.getName();
    }

    @Override
    public String getValue() {
        return this.xppDom.getValue();
    }

    @Override
    public void setValue(String value) {
        this.xppDom.setValue(value);
    }

    @Override
    public DomElement getParent() {
        return this.parent;
    }

    @Override
    public void setParent(DomElement parent) {
        if (parent instanceof XppDomElement) {
            XppDomElement xppDomElement = (XppDomElement)parent;
            this.xppDom.setParent(xppDomElement.getXppDom());
        }
        this.parent = parent;
    }

    public DomElement[] getChildren() {
        return this.getChildren(this.xppDom.getChildren());
    }

    public DomElement[] getChildren(String elementName) {
        return this.getChildren(this.xppDom.getChildren(elementName));
    }

    @Override
    public DomElement getChild(int index) {
        XppDom child = this.xppDom.getChild(index);
        if (child == null) {
            return null;
        }
        return this.getChild(child);
    }

    @Override
    public DomElement getChild(String elementName) {
        XppDom child = this.xppDom.getChild(elementName);
        if (child == null) {
            return null;
        }
        return this.getChild(child);
    }

    @Override
    public int getChildCount() {
        return this.xppDom.getChildCount();
    }

    @Override
    public DomElement createChild(String name) {
        XppDomElement child = new XppDomElement(new XppDom(name));
        this.addChild(child);
        return child;
    }

    @Override
    public void addChild(DomElement child) {
        XppDom dom = child instanceof XppDomElement ? ((XppDomElement)child).getXppDom() : this.toXppDom(child);
        this.xppDom.addChild(dom);
        child.setParent(this);
    }

    @Override
    public String[] getAttributeNames() {
        return this.xppDom.getAttributeNames();
    }

    @Override
    public String getAttribute(String attributeName) {
        return this.xppDom.getAttribute(attributeName);
    }

    @Override
    public void setAttribute(String name, String value) {
        this.xppDom.setAttribute(name, value);
    }

    @Override
    public String toXml() {
        StringWriter writer = new StringWriter();
        new HierarchicalStreamCopier().copy(new XppDomReader(this.xppDom), new PrettyPrintWriter(writer));
        return writer.toString();
    }

    private XppDom toXppDom(DomElement domElement) {
        DomElement[] children;
        String[] names;
        XppDom xppDom = new XppDom(domElement.getName());
        if (domElement.getValue() != null) {
            xppDom.setValue(domElement.getValue());
        }
        String[] stringArray = names = domElement.getAttributeNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            xppDom.setAttribute(name, domElement.getAttribute(name));
            ++n2;
        }
        DomElement[] domElementArray = children = (DomElement[])domElement.getChildren();
        int n3 = children.length;
        n = 0;
        while (n < n3) {
            DomElement child = domElementArray[n];
            xppDom.addChild(this.toXppDom(child));
            ++n;
        }
        return xppDom;
    }

    private DomElement[] getChildren(XppDom[] xppChildren) {
        DomElement[] domElements = new XppDomElement[xppChildren.length];
        int i = 0;
        while (i < xppChildren.length) {
            domElements[i] = this.getChild(xppChildren[i]);
            ++i;
        }
        return domElements;
    }

    private DomElement getChild(XppDom child) {
        DomElement childElement;
        if (this.children != null) {
            childElement = this.children.get(child);
            if (childElement != null) {
                return childElement;
            }
        } else {
            this.children = new HashMap();
        }
        childElement = new XppDomElement(child);
        childElement.setParent(this);
        this.children.put(child, childElement);
        return childElement;
    }
}

