/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.internal.AbstractType;
import com.bc.ceres.core.Assert;
import java.util.HashMap;

public final class CompoundTypeImpl
extends AbstractType
implements CompoundType {
    private final String name;
    private final CompoundMember[] members;
    private volatile HashMap<String, Integer> indices;
    private volatile Object metadata;
    private int size;

    public CompoundTypeImpl(String name, CompoundMember[] members) {
        this(name, members, null);
    }

    public CompoundTypeImpl(String name, CompoundMember[] members, Object metadata) {
        this.name = name;
        this.members = (CompoundMember[])members.clone();
        this.metadata = metadata;
        this.size = -1;
    }

    @Override
    public Object getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    @Override
    public CompoundMember[] getMembers() {
        return (CompoundMember[])this.members.clone();
    }

    @Override
    public int getMemberCount() {
        return this.members.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMemberIndex(String name) {
        Integer index;
        if (this.indices == null) {
            CompoundTypeImpl compoundTypeImpl = this;
            synchronized (compoundTypeImpl) {
                if (this.indices == null) {
                    this.indices = new HashMap(2 * this.getMemberCount());
                    int i = 0;
                    while (i < this.members.length) {
                        CompoundMember member = this.members[i];
                        this.indices.put(member.getName(), i);
                        ++i;
                    }
                }
            }
        }
        return (index = this.indices.get(name)) != null ? index : -1;
    }

    @Override
    public CompoundMember getMember(int memberIndex) {
        return this.members[memberIndex];
    }

    public void setMember(int memberIndex, CompoundMember member) {
        Assert.notNull(member, "member");
        this.members[memberIndex] = member;
        this.size = -1;
    }

    @Override
    public String getMemberName(int memberIndex) {
        return this.getMember(memberIndex).getName();
    }

    @Override
    public Type getMemberType(int memberIndex) {
        return this.getMember(memberIndex).getType();
    }

    @Override
    public int getMemberSize(int memberIndex) {
        return this.getMember(memberIndex).getType().getSize();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getSize() {
        if (this.size == -1) {
            this.size = this.computeSize();
        }
        return this.size;
    }

    @Override
    public final boolean isCollectionType() {
        return true;
    }

    @Override
    public boolean isCompoundType() {
        return true;
    }

    private int computeSize() {
        int size = 0;
        CompoundMember[] compoundMemberArray = this.members;
        int n = this.members.length;
        int n2 = 0;
        while (n2 < n) {
            CompoundMember member = compoundMemberArray[n2];
            int memberSize = member.getType().getSize();
            if (memberSize >= 0 && size >= 0) {
                size += memberSize;
            } else {
                size = -1;
                break;
            }
            ++n2;
        }
        return size;
    }
}

