/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime;

import com.bc.ceres.core.Assert;

public class Version
implements Comparable {
    private String text;
    private int[] numbers;
    private String qualifier;

    public Version(int major, int minor, int micro, String qualifier) {
        Assert.argument(major >= 0, "major");
        Assert.argument(minor >= 0, "minor");
        Assert.argument(micro >= 0, "micro");
        Assert.notNull(qualifier, "qualifier");
        this.text = null;
        this.numbers = new int[]{major, minor, micro};
        this.qualifier = qualifier;
    }

    public static Version parseVersion(String text) {
        return new Version(text.trim());
    }

    public int getNumberCount() {
        return this.numbers.length;
    }

    public int getNumber(int i) {
        return i < this.numbers.length ? this.numbers[i] : 0;
    }

    public int getMajor() {
        return this.getNumber(0);
    }

    public int getMinor() {
        return this.getNumber(1);
    }

    public int getMicro() {
        return this.getNumber(2);
    }

    public String getQualifier() {
        return this.qualifier;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Version(String text) {
        int[] numbers = new int[10];
        numbers[0] = 1;
        String qualifier = "";
        int numberCount = 0;
        int startPos = 0;
        int pos = 0;
        while (pos <= text.length()) {
            block6: {
                char c;
                char c2 = c = pos < text.length() ? text.charAt(pos) : (char)'\u0000';
                if (Version.isPartSeparator(c) || c == '\u0000') {
                    if (startPos < pos) {
                        if (numberCount < numbers.length) {
                            numbers[numberCount] = Version.parseInt(text, startPos, pos);
                            ++numberCount;
                            startPos = pos + 1;
                            break block6;
                        } else {
                            qualifier = text.substring(startPos);
                            break;
                        }
                    }
                    qualifier = text.substring(startPos);
                    break;
                }
                if (!Character.isDigit(c)) {
                    qualifier = text.substring(startPos);
                    break;
                }
            }
            ++pos;
        }
        numberCount = numberCount > 0 ? numberCount : 1;
        this.text = text;
        this.qualifier = qualifier;
        this.numbers = new int[numberCount];
        System.arraycopy(numbers, 0, this.numbers, 0, numberCount);
    }

    private static boolean isPartSeparator(char c) {
        return c == '.' || c == '-' || c == '_';
    }

    private static int parseInt(String s, int i1, int i2) {
        int n = 0;
        int m = 1;
        int i = i1;
        while (i < i2) {
            n *= m;
            n += s.charAt(i) - 48;
            m = 10;
            ++i;
        }
        return n;
    }

    public static int compare(Version v1, Version v2) {
        int d = Version.compareVersionNumbers(v1.numbers, v2.numbers);
        if (d != 0) {
            return d;
        }
        return Version.compareQualifiers(v1.qualifier, v2.qualifier);
    }

    private static int compareVersionNumbers(int[] v1, int[] v2) {
        int n = Math.max(v1.length, v2.length);
        int i = 0;
        while (i < n) {
            int n1 = 0;
            int n2 = 0;
            if (i >= v1.length) {
                n2 = v2[i];
            } else if (i >= v2.length) {
                n1 = v1[i];
            } else {
                n1 = v1[i];
                n2 = v2[i];
            }
            int d = n1 - n2;
            if (d != 0) {
                return d;
            }
            ++i;
        }
        return 0;
    }

    private static int compareQualifiers(String q1, String q2) {
        int n = Math.max(q1.length(), q2.length());
        int i = 0;
        while (i < n) {
            char c1;
            char c2;
            if (i >= q1.length()) {
                c2 = q2.charAt(i);
                c1 = Version.deriveMissingQualifierCharacter(c2);
            } else if (i >= q2.length()) {
                c1 = q1.charAt(i);
                c2 = Version.deriveMissingQualifierCharacter(c1);
            } else {
                c1 = q1.charAt(i);
                c2 = q2.charAt(i);
            }
            int d = c1 - c2;
            if (d != 0) {
                return d;
            }
            ++i;
        }
        return 0;
    }

    private static char deriveMissingQualifierCharacter(char c) {
        if (Character.isDigit(c)) {
            return '0';
        }
        if (Character.isLowerCase(c)) {
            return 'z';
        }
        if (Character.isUpperCase(c)) {
            return 'Z';
        }
        return c;
    }

    public String toString() {
        if (this.text == null) {
            StringBuilder sb = new StringBuilder(16);
            int[] nArray = this.numbers;
            int n = this.numbers.length;
            int n2 = 0;
            while (n2 < n) {
                int versionNumber = nArray[n2];
                if (sb.length() > 0) {
                    sb.append('.');
                }
                sb.append(versionNumber);
                ++n2;
            }
            if (!this.qualifier.isEmpty()) {
                sb.append('-');
                sb.append(this.qualifier);
            }
            this.text = sb.toString();
        }
        return this.text;
    }

    public int compareTo(Object o) {
        Version other = (Version)o;
        return Version.compare(this, other);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Version) {
            Version other = (Version)obj;
            return Version.compare(this, other) == 0;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        int[] nArray = this.numbers;
        int n2 = this.numbers.length;
        int n3 = 0;
        while (n3 < n2) {
            int versionNumber = nArray[n3];
            n += versionNumber;
            n *= 17;
            ++n3;
        }
        return n + this.qualifier.hashCode();
    }
}

