/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import com.bc.ceres.core.runtime.internal.UrlHelper;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class ModuleClassLoader
extends URLClassLoader {
    private ClassLoader[] delegates;
    private URL[] nativeUrls;
    private Map<ClassLoader, Map<String, List<URL>>> resolvedResources;

    public ModuleClassLoader(ClassLoader[] delegates, URL[] dependencyUrls, URL[] nativeUrls, ClassLoader parent) {
        super(dependencyUrls, parent);
        this.nativeUrls = nativeUrls;
        this.delegates = delegates;
        this.resolvedResources = new HashMap<ClassLoader, Map<String, List<URL>>>();
    }

    @Override
    protected String findLibrary(String libname) {
        String path;
        Object[] objectArray = this.nativeUrls;
        int n = this.nativeUrls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = objectArray[n2];
            if (url.toExternalForm().endsWith(System.mapLibraryName(libname))) {
                String absolutePath = UrlHelper.urlToFile(url).getAbsolutePath();
                Logger logger = Logger.getLogger(System.getProperty("ceres.context", "ceres"));
                Throwable throwable = new Throwable("This is not an exception.");
                logger.log(Level.FINEST, "Native library found: " + absolutePath, throwable);
                return absolutePath;
            }
            ++n2;
        }
        objectArray = this.delegates;
        n = this.delegates.length;
        n2 = 0;
        while (n2 < n) {
            String path2;
            Object classLoader = objectArray[n2];
            if (classLoader instanceof ModuleClassLoader && (path2 = ((ModuleClassLoader)classLoader).findLibrary(libname)) != null) {
                return path2;
            }
            ++n2;
        }
        ClassLoader parent = this.getParent();
        if (parent instanceof ModuleClassLoader && (path = ((ModuleClassLoader)parent).findLibrary(libname)) != null) {
            return path;
        }
        return super.findLibrary(libname);
    }

    @Override
    public URL findResource(String name) {
        URL localResource = super.findResource(name);
        if (localResource != null) {
            return localResource;
        }
        ClassLoader[] classLoaderArray = this.delegates;
        int n = this.delegates.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader delegate = classLoaderArray[n2];
            URL resource = delegate.getResource(name);
            if (resource != null) {
                return resource;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> resources = super.findResources(name);
        if (this.delegates.length == 0) {
            return resources;
        }
        HashSet<URL> urls = new HashSet<URL>(Collections.list(resources));
        ClassLoader[] classLoaderArray = this.delegates;
        int n = this.delegates.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader delegate = classLoaderArray[n2];
            Map<String, List<URL>> resourceMap = this.getResourceMap(delegate);
            if (resourceMap.containsKey(name)) {
                urls.addAll((Collection<URL>)resourceMap.get(name));
            } else {
                ArrayList<URL> urlArrayList = Collections.list(delegate.getResources(name));
                urls.addAll(urlArrayList);
                resourceMap.put(name, urlArrayList);
            }
            ++n2;
        }
        return Collections.enumeration(urls);
    }

    private Map<String, List<URL>> getResourceMap(ClassLoader delegate) {
        HashMap<String, List<URL>> resourceMap;
        if (this.resolvedResources.containsKey(delegate)) {
            resourceMap = this.resolvedResources.get(delegate);
        } else {
            resourceMap = new HashMap();
            this.resolvedResources.put(delegate, resourceMap);
        }
        return resourceMap;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            var6_3 = this.delegates;
            var5_4 = this.delegates.length;
            var4_5 = 0;
            ** while (var4_5 < var5_4)
        }
lbl-1000:
        // 1 sources

        {
            delegate = var6_3[var4_5];
            try {
                return delegate.loadClass(name);
            }
            catch (ClassNotFoundException v0) {
                ++var4_5;
            }
            continue;
        }
lbl14:
        // 1 sources

        throw e;
    }

    public ClassLoader[] getDelegates() {
        return this.delegates;
    }

    public URL[] getNativeUrls() {
        return this.nativeUrls;
    }
}

