/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.runtime.Activator;
import com.bc.ceres.core.runtime.Dependency;
import com.bc.ceres.core.runtime.Extension;
import com.bc.ceres.core.runtime.ExtensionPoint;
import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.ModuleContext;
import com.bc.ceres.core.runtime.ModuleState;
import com.bc.ceres.core.runtime.Version;
import com.bc.ceres.core.runtime.internal.DependencyImpl;
import com.bc.ceres.core.runtime.internal.ExtensionImpl;
import com.bc.ceres.core.runtime.internal.ExtensionPointImpl;
import com.bc.ceres.core.runtime.internal.ModuleRegistry;
import com.bc.ceres.core.runtime.internal.ModuleStarter;
import com.bc.ceres.core.runtime.internal.ModuleStopper;
import com.bc.ceres.core.runtime.internal.ModuleUninstaller;
import com.bc.ceres.core.runtime.internal.ResolveException;
import com.bc.ceres.core.runtime.internal.RuntimeImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class ModuleImpl
implements Module {
    public static final ModuleImpl[] EMPTY_ARRAY = new ModuleImpl[0];
    private String manifestVersion;
    private String symbolicName;
    private String name;
    private Version version;
    private String description;
    private String packaging;
    private String activatorClassName;
    private String categoriesString;
    private String changelog;
    private String copyright;
    private String vendor;
    private String contactAddress;
    private String funding;
    private String url;
    private boolean usingJni;
    private String aboutUrl;
    private String licenseUrl;
    private ArrayList<DependencyImpl> declaredDependencies;
    private ArrayList<ExtensionPointImpl> extensionPoints;
    private ArrayList<ExtensionImpl> extensions;
    private transient String[] categories;
    private transient RuntimeImpl runtime;
    private transient long moduleId;
    private transient ModuleState state;
    private transient ModuleRegistry registry;
    private transient URL location;
    private transient String[] impliciteLibs;
    private transient String[] impliciteNativeLibs;
    private transient long contentLength;
    private transient long lastModified;
    private transient String[] declaredLibs;
    private transient URL[] libDependencies;
    private transient ModuleImpl[] moduleDependencies;
    private transient ClassLoader classLoader;
    private List<ResolveException> resolveWarnings;
    private List<ResolveException> resolveErrors;
    private transient int refCount;
    private transient Activator activator;
    private transient ModuleContext context;

    private ModuleImpl() {
    }

    @Override
    public String getManifestVersion() {
        return this.manifestVersion;
    }

    @Override
    public long getModuleId() {
        return this.moduleId;
    }

    @Override
    public String getSymbolicName() {
        return this.symbolicName;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public ModuleState getState() {
        return this.state;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public String getChangelog() {
        return this.changelog;
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    @Override
    public String getContactAddress() {
        return this.contactAddress;
    }

    @Override
    public String getFunding() {
        return this.funding == null ? "" : this.funding;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String[] getCategories() {
        return this.categories;
    }

    @Override
    public String getActivatorClassName() {
        return this.activatorClassName;
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public URL getLocation() {
        return this.location;
    }

    @Override
    public boolean isNative() {
        return this.usingJni;
    }

    @Override
    public String getAboutUrl() {
        return this.aboutUrl;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        this.checkClassLoader();
        return this.getClassLoader().loadClass(name);
    }

    @Override
    public URL getResource(String name) {
        this.checkClassLoader();
        return this.getClassLoader().getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        this.checkClassLoader();
        return this.getClassLoader().getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        this.checkClassLoader();
        return this.getClassLoader().getResources(name);
    }

    @Override
    public Dependency[] getDeclaredDependencies() {
        return this.declaredDependencies != null ? (Dependency[])this.declaredDependencies.toArray(new DependencyImpl[this.declaredDependencies.size()]) : DependencyImpl.EMPTY_ARRAY;
    }

    @Override
    public ExtensionPoint[] getExtensionPoints() {
        return this.extensionPoints != null ? this.extensionPoints.toArray(new ExtensionPointImpl[this.extensionPoints.size()]) : ExtensionPointImpl.EMPTY_ARRAY;
    }

    @Override
    public Extension[] getExtensions() {
        return this.extensions != null ? this.extensions.toArray(new ExtensionImpl[this.extensions.size()]) : ExtensionImpl.EMPTY_ARRAY;
    }

    @Override
    public ExtensionPoint getExtensionPoint(String extensionPointId) {
        if (this.extensionPoints == null) {
            return null;
        }
        for (ExtensionPointImpl extensionPoint : this.extensionPoints) {
            if (!extensionPoint.getId().equals(extensionPointId)) continue;
            return extensionPoint;
        }
        return this.registry.getExtensionPoint(extensionPointId);
    }

    @Override
    public Extension getExtension(String extensionId) {
        if (this.extensions == null) {
            return null;
        }
        for (Extension extension : this.extensions) {
            if (!extensionId.equals(extension.getId())) continue;
            return extension;
        }
        return null;
    }

    public int hashCode() {
        return this.symbolicName.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[moduleId=" + this.moduleId + ", symbolicName=" + this.symbolicName + ", version=" + this.version + "]";
    }

    @Override
    public void uninstall(ProgressMonitor pm) throws CoreException {
        ModuleUninstaller moduleUninstaller = new ModuleUninstaller(this.runtime.getLogger());
        try {
            moduleUninstaller.uninstallModule(this);
        }
        catch (IOException e) {
            throw new CoreException(e);
        }
    }

    String getCategoriesString() {
        return this.categoriesString;
    }

    public void setManifestVersion(String manifestVersion) {
        this.manifestVersion = manifestVersion;
    }

    void setCategories(String[] categories) {
        this.categories = categories;
    }

    void setModuleId(long moduleId) {
        this.checkRegistered();
        this.moduleId = moduleId;
    }

    public void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    void setName(String name) {
        this.name = name;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    void setDescription(String description) {
        this.description = description;
    }

    public void setAboutUrl(String aboutUrl) {
        this.aboutUrl = aboutUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    void setActivatorClassName(String activatorClassName) {
        this.activatorClassName = activatorClassName;
    }

    void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    void setRefCount(int refCount) {
        this.refCount = refCount;
    }

    void initDeclaredComponents() {
        if (this.declaredDependencies != null) {
            for (DependencyImpl dependency : this.declaredDependencies) {
                dependency.setDeclaringModule(this);
            }
        }
        if (this.extensionPoints != null) {
            for (ExtensionPointImpl extensionPoint : this.extensionPoints) {
                extensionPoint.setDeclaringModule(this);
            }
        }
        if (this.extensions != null) {
            for (ExtensionImpl extension : this.extensions) {
                extension.setDeclaringModule(this);
            }
        }
    }

    ModuleRegistry getRegistry() {
        return this.registry;
    }

    void setRegistry(ModuleRegistry registry) {
        this.checkRegistered();
        this.registry = registry;
    }

    public void setLocation(URL location) {
        this.checkRegistered();
        this.location = location;
    }

    String[] getImpliciteLibs() {
        return this.impliciteLibs;
    }

    void setImpliciteLibs(String[] impliciteLibs) {
        this.impliciteLibs = impliciteLibs;
    }

    String[] getImpliciteNativeLibs() {
        return this.impliciteNativeLibs;
    }

    void setImpliciteNativeLibs(String[] impliciteNativeLibs) {
        this.impliciteNativeLibs = impliciteNativeLibs;
    }

    String[] getDeclaredLibs() {
        return this.declaredLibs;
    }

    void setDeclaredLibs(String[] declaredLibs) {
        this.declaredLibs = declaredLibs;
    }

    URL[] getLibDependencies() {
        return this.libDependencies;
    }

    void setLibDependencies(URL[] libDependencies) {
        this.libDependencies = libDependencies;
    }

    ModuleImpl[] getModuleDependencies() {
        return this.moduleDependencies;
    }

    void setModuleDependencies(ModuleImpl[] moduleDependencies) {
        this.moduleDependencies = moduleDependencies;
    }

    public void setState(ModuleState state) {
        this.state = state;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    Activator getActivator() {
        return this.activator;
    }

    void setActivator(Activator activator) {
        this.activator = activator;
    }

    ModuleContext getContext() {
        return this.context;
    }

    void setContext(ModuleContext context) {
        this.context = context;
    }

    int getRefCount() {
        return this.refCount;
    }

    void incrementRefCount() {
        ++this.refCount;
    }

    RuntimeImpl getRuntime() {
        return this.runtime;
    }

    void setRuntime(RuntimeImpl runtime) {
        this.runtime = runtime;
    }

    void start() throws CoreException {
        new ModuleStarter(this).run();
    }

    void stop() throws CoreException {
        new ModuleStopper(this).run();
    }

    private void checkClassLoader() {
        if (this.classLoader == null) {
            throw new IllegalStateException("classLoader == null");
        }
    }

    private void checkRegistered() {
        if (this.registry != null) {
            throw new IllegalStateException("illegal operation, module already registered");
        }
    }

    boolean hasResolveErrors() {
        return this.hasResolveExceptions(this.resolveErrors);
    }

    ResolveException[] getResolveErrors() {
        return this.getResolveExceptions(this.resolveErrors);
    }

    void addResolveError(ResolveException resolveException) {
        this.resolveErrors = this.addResolveException(resolveException, this.resolveErrors);
    }

    ResolveException[] getResolveWarnings() {
        return this.getResolveExceptions(this.resolveWarnings);
    }

    void addResolveWarning(ResolveException resolveException) {
        this.resolveWarnings = this.addResolveException(resolveException, this.resolveWarnings);
    }

    private boolean hasResolveExceptions(List<ResolveException> resolveExceptions) {
        return resolveExceptions != null && !resolveExceptions.isEmpty();
    }

    private ResolveException[] getResolveExceptions(List<ResolveException> resolveExceptionList) {
        if (resolveExceptionList == null) {
            return new ResolveException[0];
        }
        return resolveExceptionList.toArray(new ResolveException[resolveExceptionList.size()]);
    }

    private List<ResolveException> addResolveException(ResolveException resolveException, List<ResolveException> resolveExceptionList) {
        int n;
        if (resolveExceptionList == null) {
            resolveExceptionList = new ArrayList<ResolveException>(3);
        }
        if ((n = resolveExceptionList.size()) > 0) {
            String message = resolveException.getMessage();
            String lastMessage = resolveExceptionList.get(n - 1).getMessage();
            if (lastMessage != null && lastMessage.equals(message)) {
                return resolveExceptionList;
            }
        }
        resolveExceptionList.add(resolveException);
        return resolveExceptionList;
    }

    @Override
    public int compareTo(Module o) {
        return this.getName().compareTo(o.getName());
    }
}

