/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.CanceledException;
import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.core.runtime.ModuleState;
import com.bc.ceres.core.runtime.internal.IOHelper;
import com.bc.ceres.core.runtime.internal.InstallInfo;
import com.bc.ceres.core.runtime.internal.JarFilenameFilter;
import com.bc.ceres.core.runtime.internal.ModuleImpl;
import com.bc.ceres.core.runtime.internal.ModuleReader;
import com.bc.ceres.core.runtime.internal.UrlHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ModuleLoader {
    private static final String MODULE_LOCATION_REJECTED_0 = "Module location rejected: [{0}]";
    private Logger logger;
    private HashSet<URL> visitedLocations;

    public ModuleLoader(Logger logger) {
        Assert.notNull(logger, "logger");
        this.logger = logger;
        this.visitedLocations = new HashSet(32);
    }

    public ModuleImpl[] loadModules(ClassLoader classLoader, ProgressMonitor pm) throws IOException {
        Assert.notNull(classLoader, "classLoader");
        Assert.notNull(pm, "pm");
        Enumeration<URL> resources = classLoader.getResources("module.xml");
        ArrayList<URL> resourceList = new ArrayList<URL>(32);
        while (resources.hasMoreElements()) {
            resourceList.add(resources.nextElement());
        }
        pm.beginTask("Scanning classpath for modules", resourceList.size());
        try {
            ArrayList<ModuleImpl> moduleList = new ArrayList<ModuleImpl>(32);
            for (URL manifestUrl : resourceList) {
                URL locationUrl = UrlHelper.manifestToLocationUrl(manifestUrl);
                if (locationUrl != null) {
                    if (!this.visitedLocations.contains(locationUrl)) {
                        try {
                            ModuleImpl module = new ModuleReader(this.logger).readFromLocation(locationUrl);
                            module.setState(ModuleState.INSTALLED);
                            moduleList.add(module);
                            this.visitedLocations.add(locationUrl);
                        }
                        catch (CoreException e) {
                            this.logger.log(Level.WARNING, MessageFormat.format(MODULE_LOCATION_REJECTED_0, locationUrl), e);
                        }
                    }
                } else {
                    this.logger.log(Level.WARNING, MessageFormat.format(MODULE_LOCATION_REJECTED_0, manifestUrl));
                }
                pm.worked(1);
            }
            ModuleImpl[] moduleImplArray = moduleList.toArray(new ModuleImpl[moduleList.size()]);
            return moduleImplArray;
        }
        finally {
            pm.done();
        }
    }

    public ModuleImpl[] loadModules(File modulesDir, ProgressMonitor pm) throws IOException {
        Assert.notNull(modulesDir, "modulesDir");
        Assert.notNull(pm, "pm");
        if (!modulesDir.isDirectory()) {
            throw new IOException(MessageFormat.format("Directory not found: [{0}]", modulesDir));
        }
        File[] moduleFiles = modulesDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return JarFilenameFilter.isJarName(file.getPath()) || file.isDirectory();
            }
        });
        if (moduleFiles == null) {
            return ModuleImpl.EMPTY_ARRAY;
        }
        pm.beginTask("Scanning directory for modules", moduleFiles.length);
        try {
            ArrayList<ModuleImpl> moduleList = new ArrayList<ModuleImpl>(32);
            File[] fileArray = moduleFiles;
            int n = moduleFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File moduleFile = fileArray[n2];
                File uninstallMarker = new File(String.valueOf(moduleFile.getPath()) + ".uninstall");
                int toWork = 1;
                if (uninstallMarker.exists()) {
                    this.logger.warning(MessageFormat.format("Skipping uninstalled (but not yet deleted) module file [{0}].", moduleFile));
                } else {
                    URL locationUrl = UrlHelper.fileToUrl(moduleFile);
                    if (!this.visitedLocations.contains(locationUrl)) {
                        try {
                            ModuleImpl module = this.loadModule(moduleFile, SubProgressMonitor.create(pm, 1));
                            moduleList.add(module);
                            this.visitedLocations.add(locationUrl);
                            toWork = 0;
                        }
                        catch (CoreException e) {
                            this.logger.log(Level.WARNING, MessageFormat.format(MODULE_LOCATION_REJECTED_0, locationUrl), e);
                        }
                    }
                }
                pm.worked(toWork);
                ++n2;
            }
            ModuleImpl[] moduleImplArray = moduleList.toArray(new ModuleImpl[moduleList.size()]);
            return moduleImplArray;
        }
        finally {
            pm.done();
        }
    }

    public ModuleImpl loadModule(File moduleFile, ProgressMonitor pm) throws CoreException {
        pm.beginTask("Loading module", 2);
        try {
            ModuleImpl module = new ModuleReader(this.logger).readFromLocation(moduleFile);
            pm.worked(1);
            if ("dir".equalsIgnoreCase(module.getPackaging()) && !moduleFile.isDirectory()) {
                this.logger.info(MessageFormat.format("Unpacking [{0}]...", moduleFile.getName()));
                File archiveFile = moduleFile;
                try {
                    try {
                        moduleFile = this.unpack(archiveFile, module.isNative(), SubProgressMonitor.create(pm, 1));
                    }
                    catch (IOException e) {
                        throw new CoreException("Failed to install module [" + moduleFile + "]", e);
                    }
                }
                catch (Throwable throwable) {
                    if (!archiveFile.delete()) {
                        this.logger.warning(MessageFormat.format("Failed to delete file [{0}], reason unknown.", archiveFile));
                    }
                    throw throwable;
                }
                if (!archiveFile.delete()) {
                    this.logger.warning(MessageFormat.format("Failed to delete file [{0}], reason unknown.", archiveFile));
                }
                module = new ModuleReader(this.logger).readFromLocation(moduleFile);
            } else {
                pm.worked(1);
            }
            module.setState(ModuleState.INSTALLED);
            ModuleImpl moduleImpl = module;
            return moduleImpl;
        }
        finally {
            pm.done();
        }
    }

    private File unpack(File archiveFile, boolean isNative, ProgressMonitor pm) throws IOException, CanceledException {
        String dirName = IOHelper.getBaseName(archiveFile);
        File moduleDir = new File(archiveFile.getParent(), dirName);
        List<String> installedFiles = IOHelper.unpack(archiveFile, moduleDir, isNative, pm);
        try {
            this.writeInstallInfo(moduleDir, installedFiles);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Failed to write install info file.", e);
        }
        return moduleDir;
    }

    private void writeInstallInfo(File moduleDir, List<String> installedFiles) throws IOException {
        File installInfoFile = new File(moduleDir, "install-info.xml");
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(installInfoFile));){
            InstallInfo installInfo = new InstallInfo(installedFiles.toArray(new String[installedFiles.size()]));
            installInfo.write(writer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

