/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.runtime.Dependency;
import com.bc.ceres.core.runtime.Extension;
import com.bc.ceres.core.runtime.ExtensionPoint;
import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.ModuleState;
import com.bc.ceres.core.runtime.Version;
import com.bc.ceres.core.runtime.internal.ModuleClassLoader;
import com.bc.ceres.core.runtime.internal.ModuleImpl;
import com.bc.ceres.core.runtime.internal.ResolveException;
import com.bc.ceres.core.runtime.internal.UrlHelper;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class ModuleResolver {
    private ClassLoader moduleParentClassLoader;
    private boolean resolvingLibs;
    private Stack<String> moduleStack;

    public ModuleResolver(ClassLoader moduleParentClassLoader, boolean resolvingLibs) {
        Assert.notNull(moduleParentClassLoader, "moduleParentClassLoader");
        this.moduleParentClassLoader = moduleParentClassLoader;
        this.resolvingLibs = resolvingLibs;
        this.moduleStack = new Stack();
    }

    public void resolve(ModuleImpl module) throws ResolveException {
        Assert.notNull(module, "module");
        ModuleState previousState = module.getState();
        this.initModuleDependencies(module);
        if (module.getState() == ModuleState.RESOLVED) {
            this.initModuleClassLoader(module);
            ModuleResolver.initRefCount(module);
        }
        if (module.hasResolveErrors()) {
            module.setState(previousState);
            String msg = String.format("Failed to resolve module [%s].", module.getSymbolicName());
            throw new ResolveException(msg);
        }
    }

    private void initModuleDependencies(ModuleImpl module) {
        if (module.hasResolveErrors()) {
            return;
        }
        if (module.getState() == ModuleState.INSTALLED) {
            if (module.getModuleDependencies() == null) {
                ModuleImpl[] resolvedModules = this.resolveModuleDependencies(module);
                module.setModuleDependencies(resolvedModules);
            }
            if (module.getDeclaredLibs() == null) {
                String[] declaredLibs = ModuleResolver.findDeclaredLibs(module);
                module.setDeclaredLibs(declaredLibs);
            }
            if (module.getLibDependencies() == null) {
                URL[] libDependencies = this.findLibDependencies(module);
                module.setLibDependencies(libDependencies);
            }
            if (!module.hasResolveErrors()) {
                module.setState(ModuleState.RESOLVED);
            }
        }
    }

    private ModuleImpl[] resolveModuleDependencies(ModuleImpl module) {
        String moduleKey = String.valueOf(module.getSymbolicName()) + ":" + module.getVersion();
        if (this.moduleStack.contains(moduleKey)) {
            String message = this.createCyclicDependecyExceptionMessage(module);
            module.addResolveError(new ResolveException(message));
            return new ModuleImpl[0];
        }
        try {
            this.moduleStack.push(moduleKey);
            ModuleImpl[] moduleImplArray = this.resolveModuleDependenciesImpl(module);
            return moduleImplArray;
        }
        finally {
            this.moduleStack.pop();
        }
    }

    private String createCyclicDependecyExceptionMessage(ModuleImpl module) {
        StringBuilder trace = new StringBuilder();
        for (String s : this.moduleStack) {
            trace.append('[').append(s).append(']');
        }
        return MessageFormat.format("Cyclic dependencies detected for module [{0}], trace: {1}", module.getSymbolicName(), trace);
    }

    private ModuleImpl[] resolveModuleDependenciesImpl(ModuleImpl module) {
        DependencyItem[] moduleDependencies = ModuleResolver.findModuleDependencies(module);
        ArrayList<ModuleImpl> resolvedModules = new ArrayList<ModuleImpl>(moduleDependencies.length);
        DependencyItem[] dependencyItemArray = moduleDependencies;
        int n = moduleDependencies.length;
        int n2 = 0;
        while (n2 < n) {
            ResolveException[] resolveWarnings;
            int n3;
            ResolveException[] resolveErrors;
            DependencyItem dependencyItem = dependencyItemArray[n2];
            this.initModuleDependencies(dependencyItem.module);
            if (dependencyItem.module.getState() == ModuleState.RESOLVED) {
                resolvedModules.add(dependencyItem.module);
            }
            if ((resolveErrors = dependencyItem.module.getResolveErrors()).length > 0) {
                ResolveException[] resolveExceptionArray = resolveErrors;
                n3 = resolveErrors.length;
                int n4 = 0;
                while (n4 < n3) {
                    ResolveException resolveError = resolveExceptionArray[n4];
                    if (dependencyItem.optional) {
                        module.addResolveWarning(resolveError);
                    } else {
                        module.addResolveError(resolveError);
                    }
                    ++n4;
                }
            }
            if ((resolveWarnings = dependencyItem.module.getResolveWarnings()).length > 0) {
                ResolveException[] resolveExceptionArray = resolveWarnings;
                int n5 = resolveWarnings.length;
                n3 = 0;
                while (n3 < n5) {
                    ResolveException resolveWarning = resolveExceptionArray[n3];
                    module.addResolveWarning(resolveWarning);
                    ++n3;
                }
            }
            ++n2;
        }
        return resolvedModules.toArray(new ModuleImpl[resolvedModules.size()]);
    }

    private void initModuleClassLoader(ModuleImpl module) {
        if (module.getClassLoader() == null) {
            URL[] nativeLibs = ModuleResolver.getNativeLibs(module);
            URL[] dependencyLibs = module.getLibDependencies();
            if (dependencyLibs == null) {
                dependencyLibs = new URL[]{};
            }
            ClassLoader[] dependencyClassLoaders = this.getDependencyClassLoaders(module);
            module.setClassLoader(new ModuleClassLoader(dependencyClassLoaders, dependencyLibs, nativeLibs, this.moduleParentClassLoader));
        }
    }

    private ClassLoader[] getDependencyClassLoaders(ModuleImpl module) {
        ArrayList<ClassLoader> dependencyCl = new ArrayList<ClassLoader>();
        ModuleImpl[] moduleImplArray = module.getModuleDependencies();
        int n = moduleImplArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleImpl moduleDependency = moduleImplArray[n2];
            if (moduleDependency.getState() == ModuleState.RESOLVED) {
                if (moduleDependency.getClassLoader() == null) {
                    this.initModuleClassLoader(moduleDependency);
                }
                dependencyCl.add(moduleDependency.getClassLoader());
            }
            ++n2;
        }
        return dependencyCl.toArray(new ClassLoader[dependencyCl.size()]);
    }

    private static URL[] getNativeLibs(ModuleImpl module) {
        File moduleDir;
        ArrayList<URL> libPaths = new ArrayList<URL>();
        if (module.isNative() && (moduleDir = UrlHelper.urlToFile(module.getLocation())).isDirectory()) {
            String[] impliciteNativeLibs;
            String[] stringArray = impliciteNativeLibs = module.getImpliciteNativeLibs();
            int n = impliciteNativeLibs.length;
            int n2 = 0;
            while (n2 < n) {
                String libPath = stringArray[n2];
                File libFile = new File(moduleDir, libPath);
                if (libFile.isFile() && libFile.canRead()) {
                    libPaths.add(UrlHelper.fileToUrl(libFile));
                } else {
                    String msg = String.format("Native library [%s] found in module [%s] is not accessible.", libFile, module.getSymbolicName());
                    module.addResolveWarning(new ResolveException(msg));
                }
                ++n2;
            }
        }
        return libPaths.toArray(new URL[libPaths.size()]);
    }

    private static void initRefCount(ModuleImpl module) {
        module.incrementRefCount();
        if (module.getModuleDependencies() != null) {
            ModuleImpl[] moduleDependencies;
            ModuleImpl[] moduleImplArray = moduleDependencies = module.getModuleDependencies();
            int n = moduleDependencies.length;
            int n2 = 0;
            while (n2 < n) {
                ModuleImpl moduleDependency = moduleImplArray[n2];
                ModuleResolver.initRefCount(moduleDependency);
                ++n2;
            }
        }
    }

    private URL[] findLibDependencies(ModuleImpl module) {
        if (module.getLocation() == null) {
            throw new IllegalStateException("module.getLocation() == null");
        }
        if (module.getModuleDependencies() == null) {
            throw new IllegalStateException("module.getModuleDependencies() == null");
        }
        if (module.getDeclaredLibs() == null) {
            throw new IllegalStateException("module.getDeclaredLibs() == null");
        }
        if (module.getImpliciteLibs() == null) {
            throw new IllegalStateException("module.getImpliciteLibs() == null");
        }
        File moduleFile = UrlHelper.urlToFile(module.getLocation());
        if (moduleFile == null) {
            return new URL[0];
        }
        ArrayList<URL> libDependencies = new ArrayList<URL>(16);
        ModuleResolver.collectLibDependency(module, moduleFile, libDependencies);
        ModuleResolver.resolveLibs(module, moduleFile, this.resolvingLibs, libDependencies);
        String[] stringArray = module.getImpliciteLibs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String impliciteLib = stringArray[n2];
            ModuleResolver.collectLibDependency(module, new File(moduleFile, impliciteLib), libDependencies);
            ++n2;
        }
        return libDependencies.toArray(new URL[0]);
    }

    private static void resolveLibs(ModuleImpl module, File moduleFile, boolean resolvingLibs, List<URL> libDependencies) {
        Dependency[] declaredDependencies;
        Dependency[] dependencyArray = declaredDependencies = module.getDeclaredDependencies();
        int n = declaredDependencies.length;
        int n2 = 0;
        while (n2 < n) {
            Dependency dependency = dependencyArray[n2];
            if (dependency.getLibName() != null) {
                boolean libResolved = false;
                File file = ModuleResolver.resolveFile(moduleFile, dependency.getLibName(), resolvingLibs);
                if (file != null) {
                    ModuleResolver.collectLibDependency(module, file, libDependencies);
                    libResolved = true;
                } else {
                    ModuleImpl[] moduleImplArray = module.getModuleDependencies();
                    int n3 = moduleImplArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File file2;
                        ModuleImpl moduleDependency = moduleImplArray[n4];
                        File moduleDependencyFile = UrlHelper.urlToFile(moduleDependency.getLocation());
                        if (moduleDependencyFile != null && (file2 = ModuleResolver.resolveFile(moduleDependencyFile, dependency.getLibName(), resolvingLibs)) != null) {
                            ModuleResolver.collectLibDependency(module, file2, libDependencies);
                            libResolved = true;
                            break;
                        }
                        ++n4;
                    }
                }
                if (!libResolved && resolvingLibs && !dependency.isOptional()) {
                    String msg = String.format("Mandatory library [%s] declared by module [%s] not found.", dependency.getLibName(), module.getSymbolicName());
                    module.addResolveError(new ResolveException(msg));
                }
            }
            ++n2;
        }
    }

    private static File resolveFile(File parent, String libPath, boolean checkExists) {
        if (parent.isDirectory()) {
            File file = new File(parent, libPath);
            if (!checkExists || file.exists()) {
                return file;
            }
        }
        return null;
    }

    private static DependencyItem[] findModuleDependencies(ModuleImpl module) {
        ArrayList<DependencyItem> list = new ArrayList<DependencyItem>(16);
        ModuleResolver.collectDeclaredModuleDependencies(module, list);
        ModuleResolver.collectImpliciteModuleDependencies(module, list);
        return list.toArray(new DependencyItem[0]);
    }

    private static void collectDeclaredModuleDependencies(ModuleImpl module, List<DependencyItem> list) {
        Dependency[] dependencies;
        Dependency[] dependencyArray = dependencies = module.getDeclaredDependencies();
        int n = dependencies.length;
        int n2 = 0;
        while (n2 < n) {
            Dependency dependency = dependencyArray[n2];
            if (dependency.getModuleSymbolicName() != null) {
                ModuleImpl[] dependencyModules = module.getRegistry().getModules(dependency.getModuleSymbolicName());
                if (dependencyModules.length > 0) {
                    if (dependency.getVersion() != null) {
                        Version requiredVersion = Version.parseVersion(dependency.getVersion());
                        ModuleImpl dependencyModule = ModuleResolver.findBestMatchingModuleVersion(requiredVersion, dependencyModules);
                        if (dependencyModule != null && requiredVersion.compareTo(dependencyModule.getVersion()) <= 0) {
                            ModuleResolver.collectDependencyModule(module, dependencyModule, dependency.isOptional(), list);
                        } else if (!dependency.isOptional()) {
                            String msg = String.format("Mandatory dependency [%s:%s] declared by module [%s] not found.", dependency.getModuleSymbolicName(), dependency.getVersion(), module.getSymbolicName());
                            module.addResolveError(new ResolveException(msg));
                        }
                    } else if (dependencyModules.length > 0) {
                        ModuleImpl dependencyModule = ModuleResolver.findLatestModuleVersion(dependencyModules);
                        ModuleResolver.collectDependencyModule(module, dependencyModule, dependency.isOptional(), list);
                    }
                } else if (!dependency.isOptional()) {
                    String msg = String.format("Mandatory dependency [%s] declared by module [%s] not found.", dependency.getModuleSymbolicName(), module.getSymbolicName());
                    module.addResolveError(new ResolveException(msg));
                }
            }
            ++n2;
        }
    }

    private static void collectImpliciteModuleDependencies(ModuleImpl module, List<DependencyItem> list) {
        Extension[] extensions;
        Extension[] extensionArray = extensions = module.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            Extension extension = extensionArray[n2];
            ExtensionPoint extensionPoint = extension.getExtensionPoint();
            if (extensionPoint != null) {
                ModuleResolver.collectDependencyModule(module, (ModuleImpl)extensionPoint.getDeclaringModule(), true, list);
            } else {
                String msg = String.format("Extension point [%s] used by module [%s] not found. Extension will be ignored.", extension.getPoint(), module.getSymbolicName());
                module.addResolveWarning(new ResolveException(msg));
            }
            ++n2;
        }
    }

    private static ModuleImpl findLatestModuleVersion(ModuleImpl[] modules) {
        ModuleImpl latestModule = modules[0];
        Version latestVersion = latestModule.getVersion();
        int i = 1;
        while (i < modules.length) {
            ModuleImpl module = modules[i];
            Version version = module.getVersion();
            if (version.compareTo(latestVersion) > 0) {
                latestModule = module;
                latestVersion = version;
            }
            ++i;
        }
        return latestModule;
    }

    private static Version[] getVersions(Module[] modules) {
        Version[] versions = new Version[modules.length];
        int i = 0;
        while (i < modules.length) {
            versions[i] = modules[i].getVersion();
            ++i;
        }
        return versions;
    }

    private static ModuleImpl findBestMatchingModuleVersion(Version requiredVersion, ModuleImpl[] modules) {
        Version[] versions = ModuleResolver.getVersions(modules);
        int i = 0;
        while (i < modules.length) {
            ModuleImpl module = modules[i];
            if (versions[i].compareTo(requiredVersion) == 0) {
                return module;
            }
            ++i;
        }
        ModuleImpl bestModule = ModuleResolver.findLatestModuleVersion(modules);
        Version bestVersion = bestModule.getVersion();
        int i2 = 0;
        while (i2 < modules.length) {
            ModuleImpl module = modules[i2];
            Version version = versions[i2];
            if (version.compareTo(requiredVersion) == 0) {
                bestModule = module;
                break;
            }
            if (version.compareTo(requiredVersion) > 0 && version.compareTo(bestVersion) < 0) {
                bestModule = module;
                bestVersion = version;
            }
            ++i2;
        }
        return bestModule;
    }

    private static String[] findDeclaredLibs(ModuleImpl module) {
        Dependency[] dependencies = module.getDeclaredDependencies();
        ArrayList<String> libNames = new ArrayList<String>(dependencies.length);
        Dependency[] dependencyArray = dependencies;
        int n = dependencies.length;
        int n2 = 0;
        while (n2 < n) {
            Dependency dependency = dependencyArray[n2];
            if (dependency.getLibName() != null && !libNames.contains(dependency.getLibName())) {
                libNames.add(dependency.getLibName());
            }
            ++n2;
        }
        return libNames.toArray(new String[0]);
    }

    private static void collectDependencyModule(ModuleImpl module, ModuleImpl dependencyModule, boolean optional, List<DependencyItem> dependencyItems) {
        if (dependencyModule == module) {
            return;
        }
        for (DependencyItem dependencyItem : dependencyItems) {
            if (dependencyModule != dependencyItem.module) continue;
            return;
        }
        dependencyItems.add(new DependencyItem(dependencyModule, optional));
    }

    private static void collectLibDependency(ModuleImpl module, File lib, List<URL> list) {
        try {
            URL url = ModuleResolver.convertToURL(lib);
            if (!list.contains(url)) {
                list.add(url);
            }
        }
        catch (MalformedURLException e) {
            String msg = String.format("Library file path [%s] used by module [%s] cannot be converted to an URL.", lib.getPath(), module.getSymbolicName());
            module.addResolveError(new ResolveException(msg, e));
        }
    }

    private static URL convertToURL(File lib) throws MalformedURLException {
        return lib.toURI().toURL();
    }

    static class DependencyItem {
        ModuleImpl module;
        boolean optional;

        public DependencyItem(ModuleImpl module, boolean optional) {
            this.module = module;
            this.optional = optional;
        }
    }
}

