/*
 * Decompiled with CFR 0.152.
 */
package com.bc.jexp.impl;

import com.bc.jexp.EvalEnv;
import com.bc.jexp.EvalException;
import com.bc.jexp.Namespace;
import com.bc.jexp.Term;
import com.bc.jexp.impl.AbstractFunction;
import com.bc.jexp.impl.ExtMath;
import com.bc.jexp.impl.NamespaceImpl;
import com.bc.jexp.impl.SymbolFactory;
import org.apache.commons.math3.util.FastMath;

public final class DefaultNamespace
extends NamespaceImpl {
    private static final double EPS = 1.0E-6;

    public DefaultNamespace() {
        this(null);
    }

    public DefaultNamespace(Namespace parent) {
        super(parent);
        this.registerDefaultSymbols();
        this.registerDefaultFunctions();
    }

    private void registerDefaultSymbols() {
        this.registerSymbol(SymbolFactory.createConstant("PI", Math.PI));
        this.registerSymbol(SymbolFactory.createConstant("E", Math.E));
        this.registerSymbol(SymbolFactory.createConstant("NaN", Double.NaN));
    }

    private void registerDefaultFunctions() {
        this.registerFunction(new AbstractFunction.D("sin", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                return FastMath.sin(args[0].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("cos", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                return FastMath.cos(args[0].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("tan", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                return FastMath.tan(args[0].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("asin", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                return FastMath.asin(args[0].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("acos", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                return FastMath.acos(args[0].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("atan", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                return FastMath.atan(args[0].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("atan2", 2){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                return Math.atan2(args[0].evalD(env), args[1].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("log", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                return Math.log(args[0].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("log10", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) throws EvalException {
                return Math.log10(args[0].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("exp", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                return FastMath.exp(args[0].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("exp10", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) throws EvalException {
                return FastMath.pow(10.0, args[0].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("sqr", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                double v = args[0].evalD(env);
                return v * v;
            }
        });
        this.registerFunction(new AbstractFunction.D("sqrt", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                return Math.sqrt(args[0].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("pow", 2){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                return FastMath.pow(args[0].evalD(env), args[1].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.I("min", 2){

            @Override
            public int evalI(EvalEnv env, Term[] args) {
                return Math.min(args[0].evalI(env), args[1].evalI(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("min", 2){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                return Math.min(args[0].evalD(env), args[1].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.I("max", 2){

            @Override
            public int evalI(EvalEnv env, Term[] args) {
                return Math.max(args[0].evalI(env), args[1].evalI(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("max", 2){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                return Math.max(args[0].evalD(env), args[1].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("floor", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) throws EvalException {
                return Math.floor(args[0].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("round", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) throws EvalException {
                return Math.round(args[0].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("ceil", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) throws EvalException {
                return Math.ceil(args[0].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("rint", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) throws EvalException {
                return Math.rint(args[0].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.I("sign", 1){

            @Override
            public int evalI(EvalEnv env, Term[] args) {
                return ExtMath.sign(args[0].evalI(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("sign", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                return ExtMath.sign(args[0].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.I("abs", 1){

            @Override
            public int evalI(EvalEnv env, Term[] args) {
                return Math.abs(args[0].evalI(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("abs", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                return Math.abs(args[0].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("deg", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                return Math.toDegrees(args[0].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("rad", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                return Math.toRadians(args[0].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("ampl", 2){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                double a = args[0].evalD(env);
                double b = args[1].evalD(env);
                return Math.sqrt(a * a + b * b);
            }
        });
        this.registerFunction(new AbstractFunction.D("phase", 2){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                double a = args[0].evalD(env);
                double b = args[1].evalD(env);
                return Math.atan2(b, a);
            }
        });
        this.registerFunction(new AbstractFunction.B("feq", 2){

            @Override
            public boolean evalB(EvalEnv env, Term[] args) throws EvalException {
                double x1 = args[0].evalD(env);
                double x2 = args[1].evalD(env);
                return ExtMath.feq(x1, x2, 1.0E-6);
            }
        });
        this.registerFunction(new AbstractFunction.B("feq", 3){

            @Override
            public boolean evalB(EvalEnv env, Term[] args) throws EvalException {
                double x1 = args[0].evalD(env);
                double x2 = args[1].evalD(env);
                double eps = args[2].evalD(env);
                return ExtMath.feq(x1, x2, eps);
            }
        });
        this.registerFunction(new AbstractFunction.B("fneq", 2){

            @Override
            public boolean evalB(EvalEnv env, Term[] args) throws EvalException {
                double x1 = args[0].evalD(env);
                double x2 = args[1].evalD(env);
                return ExtMath.fneq(x1, x2, 1.0E-6);
            }
        });
        this.registerFunction(new AbstractFunction.B("fneq", 3){

            @Override
            public boolean evalB(EvalEnv env, Term[] args) throws EvalException {
                double x1 = args[0].evalD(env);
                double x2 = args[1].evalD(env);
                double eps = args[2].evalD(env);
                return ExtMath.fneq(x1, x2, eps);
            }
        });
        this.registerFunction(new AbstractFunction.B("inf", 1){

            @Override
            public boolean evalB(EvalEnv env, Term[] args) throws EvalException {
                return Double.isInfinite(args[0].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.B("nan", 1){

            @Override
            public boolean evalB(EvalEnv env, Term[] args) throws EvalException {
                return Double.isNaN(args[0].evalD(env));
            }
        });
        this.registerFunction(new AbstractFunction.D("distance", -1){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                double sqrSum = 0.0;
                int n = args.length / 2;
                int i = 0;
                while (i < n) {
                    double v = args[i + n].evalD(env) - args[i].evalD(env);
                    sqrSum += v * v;
                    ++i;
                }
                return Math.sqrt(sqrSum);
            }
        });
        this.registerFunction(new AbstractFunction.D("distance_deriv", -1){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                double sqrSum = 0.0;
                int n = args.length / 2;
                int i = 0;
                while (i < n - 1) {
                    double v1 = args[i + 1].evalD(env) - args[i].evalD(env);
                    double v2 = args[i + n + 1].evalD(env) - args[i + n].evalD(env);
                    sqrSum += (v1 - v2) * (v1 - v2);
                    ++i;
                }
                return Math.sqrt(sqrSum);
            }
        });
        this.registerFunction(new AbstractFunction.D("distance_integ", -1){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                double sqrSum = 0.0;
                double v1Sum = 0.0;
                double v2Sum = 0.0;
                int n = args.length / 2;
                int i = 0;
                while (i < n) {
                    sqrSum += ((v2Sum += args[i + n].evalD(env)) - (v1Sum += args[i].evalD(env))) * (v2Sum - v1Sum);
                    ++i;
                }
                return Math.sqrt(sqrSum);
            }
        });
        this.registerFunction(new AbstractFunction.B("inrange", -1){

            @Override
            public boolean evalB(EvalEnv env, Term[] args) {
                int n1 = args.length / 3;
                int n2 = n1 + args.length / 3;
                int i = 0;
                while (i < n1) {
                    double v = args[i].evalD(env);
                    double v1 = args[i + n1].evalD(env);
                    double v2 = args[i + n2].evalD(env);
                    if (v < v1 || v > v2) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        });
        this.registerFunction(new AbstractFunction.B("inrange_deriv", -1){

            @Override
            public boolean evalB(EvalEnv env, Term[] args) {
                int n1 = args.length / 3;
                int n2 = 2 * n1;
                int i = 0;
                while (i < n1 - 1) {
                    double v = args[i + 1].evalD(env) - args[i].evalD(env);
                    double v1 = args[i + n1 + 1].evalD(env) - args[i + n1].evalD(env);
                    double v2 = args[i + n2 + 1].evalD(env) - args[i + n2].evalD(env);
                    if (v < v1 || v > v2) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        });
        this.registerFunction(new AbstractFunction.B("inrange_integ", -1){

            @Override
            public boolean evalB(EvalEnv env, Term[] args) {
                int n1 = args.length / 3;
                int n2 = 2 * n1;
                double vSum = 0.0;
                double v1Sum = 0.0;
                double v2Sum = 0.0;
                int i = 0;
                while (i < n1) {
                    v2Sum += args[i + n2].evalD(env);
                    if ((vSum += args[i].evalD(env)) < (v1Sum += args[i + n1].evalD(env)) || vSum > v2Sum) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        });
    }
}

