/*
 * Decompiled with CFR 0.152.
 */
package com.bc.jexp.impl;

import com.bc.jexp.EvalEnv;
import com.bc.jexp.EvalException;
import com.bc.jexp.Term;
import com.bc.jexp.Variable;
import com.bc.jexp.impl.AbstractFunction;

public final class UserFunction
extends AbstractFunction {
    private static int stackSizeMax = 32;
    private static double[] stack;
    private static int stackIndex;
    private final Variable[] params;
    private final Term body;

    static {
        UserFunction.createStack();
    }

    public UserFunction(String name, Variable[] params, Term body) {
        super(name, body.getRetType(), params.length, UserFunction.getArgTypes(params));
        this.params = params;
        this.body = body;
    }

    @Override
    public boolean evalB(EvalEnv env, Term[] args) throws EvalException {
        if (this.body.isB()) {
            int si0 = stackIndex;
            this.prepareCall(env, args, si0);
            boolean ret = this.body.evalB(env);
            this.finishCall(env, si0);
            return ret;
        }
        return Term.toB(this.evalD(env, args));
    }

    @Override
    public int evalI(EvalEnv env, Term[] args) throws EvalException {
        if (this.body.isI()) {
            int si0 = stackIndex;
            this.prepareCall(env, args, si0);
            int ret = this.body.evalI(env);
            this.finishCall(env, si0);
            return ret;
        }
        return Term.toI(this.evalD(env, args));
    }

    @Override
    public double evalD(EvalEnv env, Term[] args) {
        int si0 = stackIndex;
        this.prepareCall(env, args, si0);
        double ret = this.body.evalD(env);
        this.finishCall(env, si0);
        return ret;
    }

    public static int getStackSizeMax() {
        return stackSizeMax;
    }

    public static void setStackSizeMax(int stackSizeMax) {
        UserFunction.stackSizeMax = stackSizeMax;
        UserFunction.createStack();
    }

    private static void createStack() {
        stack = new double[stackSizeMax];
        stackIndex = 0;
    }

    private void prepareCall(EvalEnv env, Term[] args, int si0) {
        if (stack.length >= si0 + this.params.length) {
            throw new EvalException("stack overflow");
        }
        int i = 0;
        while (i < this.params.length) {
            UserFunction.stack[si0 + i] = this.params[i].evalD(env);
            this.params[i].assignD(env, args[i].evalD(env));
            ++i;
        }
        stackIndex += this.params.length;
    }

    private void finishCall(EvalEnv env, int si0) {
        stackIndex -= this.params.length;
        int i = 0;
        while (i < this.params.length) {
            this.params[i].assignD(env, stack[si0 + i]);
            ++i;
        }
    }

    private static int[] getArgTypes(Variable[] params) {
        int[] argTypes = new int[params.length];
        int i = 0;
        while (i < argTypes.length) {
            argTypes[i] = params[i].getRetType();
            ++i;
        }
        return argTypes;
    }
}

