/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr;

public interface AvhrrConstants {
    public static final String PRODUCT_TYPE = "AVHRR_3_L1B";
    public static final String PRODUCT_DESCRIPTION = "AVHRR/3 Level-1b Data Product";
    public static final String RADIANCE_BAND_NAME_PREFIX = "radiance_";
    public static final String TEMPERATURE_BAND_NAME_PREFIX = "temp_";
    public static final String REFLECTANCE_BAND_NAME_PREFIX = "reflec_";
    public static final String COUNTS_BAND_NAME_PREFIX = "counts_";
    public static final String VIS_RADIANCE_UNIT = "mW / (m^2 sr nm)";
    public static final String IR_RADIANCE_UNIT = "mW / (m^2 sr cm^-1)";
    public static final String TEMPERATURE_UNIT = "K";
    public static final String REFLECTANCE_UNIT = "%";
    public static final String COUNTS_UNIT = "DL";
    public static final String REFLECTANCE_FACTOR_DESCRIPTION = "Reflectance factor for channel {0}";
    public static final String RADIANCE_DESCRIPTION_VIS = "Spectral radiance for channel {0}";
    public static final String RADIANCE_DESCRIPTION_IR = "Earth scene radiance for channel {0}";
    public static final String TEMPERATURE_DESCRIPTION = "Blackbody temperature for channel {0}";
    public static final String COUNTS_DESCRIPTION = "Raw counts for channel {0}";
    public static final String SZA_DS_NAME = "sun_zenith";
    public static final String VZA_DS_NAME = "view_zenith";
    public static final String SAA_DS_NAME = "sun_azimuth";
    public static final String VAA_DS_NAME = "view_azimuth";
    public static final String DAA_DS_NAME = "delta_azimuth";
    public static final String LAT_DS_NAME = "latitude";
    public static final String LON_DS_NAME = "longitude";
    public static final String FLAGS_DS_NAME = "flags";
    public static final String FLAG_QS = "QUALITY_ERROR";
    public static final String FLAG_SCANLINE = "SCANLINE_ERROR";
    public static final String FLAG_3B = "CALIB_CH_3B_ERROR";
    public static final String FLAG_4 = "CALIB_CH_4_ERROR";
    public static final String FLAG_5 = "CALIB_CH_5_ERROR";
    public static final String FLAG_SYNC = "FRAME_SYNC_ERROR";
    public static final String FLAG_QS_DESC = "Set if any of the bits from the quality indicator bit-field are set";
    public static final String FLAG_SCANLINE_DESC = "Set if any of the bits from the scanline quality flags are set";
    public static final String FLAG_CALIB_CH_DESC = "Set if any of the bits from the calibration quality flags are set";
    public static final String FLAG_SYNC_DESC = "Set if there are bit errors in the frame sync";
    public static final String UNIT_DEG = "deg";
    public static final String UNIT_M = "m";
    public static final String UNIT_MM = "mm";
    public static final String UNIT_KM = "km";
    public static final String UNIT_M_PER_S = "m/s";
    public static final String UNIT_KM_PER_S = "km/s";
    public static final String UNIT_PER_CM = "1/cm";
    public static final String UNIT_YEARS = "year";
    public static final String UNIT_DAYS = "day";
    public static final String UNIT_MINUTES = "min";
    public static final String UNIT_MS = "ms";
    public static final String UNIT_DATE = "date";
    public static final String UNIT_BYTES = "bytes";
    public static final String UNIT_BITS = "bits";
    public static final int CH_1 = 0;
    public static final int CH_2 = 1;
    public static final int CH_3A = 2;
    public static final int CH_3B = 3;
    public static final int CH_4 = 4;
    public static final int CH_5 = 5;
    public static final String[] CH_STRINGS = new String[]{"1", "2", "3a", "3b", "4", "5"};
    public static final int[] CH_DATASET_INDEXES;
    public static final float[] CH_WAVELENGTHS;
    public static final float[] CH_BANDWIDTHS;
    public static final String _BASELINE_VALID_MASK_EXPRESSION = "NOT flags.QUALITY_ERROR AND NOT flags.SCANLINE_ERROR AND NOT flags.FRAME_SYNC_ERROR";
    public static final String[] CH_VALID_MASK_EXPRESSIONS;
    public static final int RAW_SCENE_RASTER_WIDTH = 2048;
    public static final int SCENE_RASTER_WIDTH = 2001;
    public static final byte NO_DATA_VALUE = 0;
    public static final int[] HEADER_LENGTHS;
    public static final int ARS_LENGTH = 512;
    public static final int GI_OFFSET = 0;
    public static final int GI_LENGTH = 108;
    public static final int DSQI_OFFSET = 116;
    public static final int DSQI_LENGTH = 60;
    public static final int RC_OFFSET = 256;
    public static final int RC_LENGTH = 72;
    public static final int NAV_OFFSET = 328;
    public static final int NAV_LENGTH = 80;
    public static final int CALIB_COEFF_OFFSET = 48;
    public static final int CALIB_COEFF_LENGTH = 63;
    public static final float TP_OFFSET_X = 0.5f;
    public static final float TP_OFFSET_Y = 0.5f;
    public static final int TP_SUB_SAMPLING_X = 40;
    public static final int TP_SUB_SAMPLING_Y = 40;
    public static final int TP_GRID_WIDTH = 51;
    public static final int TP_TRIM_X = 25;

    static {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 2;
        nArray[4] = 3;
        nArray[5] = 4;
        CH_DATASET_INDEXES = nArray;
        CH_WAVELENGTHS = new float[]{630.0f, 862.5f, 1610.0f, 3740.0f, 10800.0f, 12000.0f};
        CH_BANDWIDTHS = new float[]{100.0f, 275.0f, 60.0f, 38.0f, 1000.0f, 1000.0f};
        CH_VALID_MASK_EXPRESSIONS = new String[]{_BASELINE_VALID_MASK_EXPRESSION, _BASELINE_VALID_MASK_EXPRESSION, _BASELINE_VALID_MASK_EXPRESSION, "NOT flags.QUALITY_ERROR AND NOT flags.SCANLINE_ERROR AND NOT flags.FRAME_SYNC_ERROR AND NOT flags.CALIB_CH_3B_ERROR", "NOT flags.QUALITY_ERROR AND NOT flags.SCANLINE_ERROR AND NOT flags.FRAME_SYNC_ERROR AND NOT flags.CALIB_CH_4_ERROR", "NOT flags.QUALITY_ERROR AND NOT flags.SCANLINE_ERROR AND NOT flags.FRAME_SYNC_ERROR AND NOT flags.CALIB_CH_5_ERROR"};
        HEADER_LENGTHS = new int[]{12288, 15872, 22528};
    }
}

