/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.calibration;

import org.esa.beam.dataio.avhrr.calibration.RadianceCalibrator;

public class Radiance2TemperatureCalibrator
implements RadianceCalibrator {
    private static final double C1 = 1.1910427E-5;
    private static final double C2 = 1.4387752;
    private double constant1;
    private double constant2;
    private double c2vc;
    private double c1vc3;

    public Radiance2TemperatureCalibrator(double constant1, double constant2, double vc) {
        this.constant1 = constant1;
        this.constant2 = constant2;
        this.c2vc = 1.4387752 * vc;
        this.c1vc3 = 1.1910427E-5 * vc * vc * vc;
    }

    @Override
    public float calibrate(float radiances) {
        double teStar = this.c2vc / Math.log(1.0 + this.c1vc3 / (double)radiances);
        double te = this.constant1 + this.constant2 * teStar;
        return (float)te;
    }
}

