/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.noaa;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.SequenceData;
import java.io.IOException;
import org.esa.beam.dataio.avhrr.AvhrrConstants;
import org.esa.beam.dataio.avhrr.calibration.Calibrator;
import org.esa.beam.dataio.avhrr.noaa.CountReader;
import org.esa.beam.dataio.avhrr.noaa.KlmAvhrrFile;

class CountReader10Bit
extends CountReader {
    private static final int TEN_BITS = 1023;
    private static final int[] FIRST;
    private static final int[][] INCREMENT;
    private static final int[][] SHIFT;
    private int[] scanLineBuffer;
    private final int elementCount;

    static {
        int[] nArray = new int[5];
        nArray[3] = 1;
        nArray[4] = 1;
        FIRST = nArray;
        INCREMENT = new int[][]{{1, 2, 2}, {2, 1, 2}, {2, 2, 1}, {1, 2, 2}, {2, 1, 2}};
        int[][] nArrayArray = new int[5][];
        int[] nArray2 = new int[3];
        nArray2[0] = 20;
        nArray2[2] = 10;
        nArrayArray[0] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 10;
        nArray3[1] = 20;
        nArrayArray[1] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[1] = 10;
        nArray4[2] = 20;
        nArrayArray[2] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 20;
        nArray5[2] = 10;
        nArrayArray[3] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 10;
        nArray6[1] = 20;
        nArrayArray[4] = nArray6;
        SHIFT = nArrayArray;
    }

    public CountReader10Bit(int channel, KlmAvhrrFile noaaFile, Calibrator calibrator, int elementCount, int dataWidth) {
        super(channel, noaaFile, calibrator, dataWidth);
        this.elementCount = elementCount;
        this.scanLineBuffer = new int[elementCount];
    }

    @Override
    protected void readData(int rawY) throws IOException {
        CompoundData dataRecord = this.noaaFile.getDataRecord(rawY);
        SequenceData avhrr_sensor_data = dataRecord.getSequence("AVHRR_SENSOR_DATA");
        int i = 0;
        while (i < this.scanLineBuffer.length) {
            this.scanLineBuffer[i] = avhrr_sensor_data.getInt(i);
            ++i;
        }
        this.extractCounts(this.scanLineBuffer);
    }

    private void extractCounts(int[] rawData) {
        int j = 0;
        int bandNo = AvhrrConstants.CH_DATASET_INDEXES[this.channel];
        int indexRaw = FIRST[bandNo];
        int i = 0;
        while (i < this.lineOfCounts.length) {
            this.lineOfCounts[i] = (rawData[indexRaw] & 1023 << SHIFT[bandNo][j]) >> SHIFT[bandNo][j];
            indexRaw += INCREMENT[bandNo][j];
            j = j == 2 ? 0 : j + 1;
            ++i;
        }
    }

    private void extractCountsSlowButSimple(int[] rawData) {
        int bandNo = AvhrrConstants.CH_DATASET_INDEXES[this.channel];
        int indexInBand = 0;
        int bandNum = 0;
        int[] c = new int[3];
        int i = 0;
        while (i < this.elementCount) {
            int rawValue = rawData[i];
            c[0] = (rawValue & 0x3FF00000) >> 20;
            c[1] = (rawValue & 0xFFC00) >> 10;
            c[2] = rawValue & 0x3FF;
            int ci = 0;
            while (ci < 3) {
                if (bandNum == bandNo) {
                    this.lineOfCounts[indexInBand] = c[ci];
                }
                if (++bandNum == 5) {
                    bandNum = 0;
                    ++indexInBand;
                }
                if (i == this.elementCount - 1) break;
                ++ci;
            }
            ++i;
        }
    }
}

