/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.noaa;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.SequenceData;
import java.io.IOException;
import java.util.Map;
import org.esa.beam.dataio.avhrr.HeaderUtil;
import org.esa.beam.dataio.avhrr.noaa.FormatMetadata;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.ProductData;

public class HeaderWrapper {
    private final CompoundData compoundData;

    public HeaderWrapper(CompoundData compoundData) {
        this.compoundData = compoundData;
    }

    public MetadataElement getAsMetadataElement() throws IOException {
        return HeaderWrapper.getAsMetadataElement(this.compoundData);
    }

    public static MetadataElement getAsMetadataElement(CompoundData compoundData) throws IOException {
        CompoundType type = compoundData.getType();
        int memberCount = type.getMemberCount();
        MetadataElement metadataElement = new MetadataElement(type.getName());
        int i = 0;
        while (i < memberCount) {
            String typeName = type.getMemberName(i);
            CompoundMember member = type.getMember(i);
            FormatMetadata formatMetadata = (FormatMetadata)member.getMetadata();
            if (!typeName.equals("fill")) {
                MetadataAttribute attribute;
                ProductData data;
                if (formatMetadata != null && formatMetadata.getType().equals("string")) {
                    String stringValue = HeaderWrapper.getAsString(compoundData.getSequence(i));
                    Map<Object, String> map = HeaderWrapper.getMetaData(member).getItemMap();
                    if (map != null) {
                        stringValue = map.get(stringValue);
                    }
                    data = ProductData.createInstance(stringValue);
                    attribute = new MetadataAttribute(typeName, data, true);
                    attribute.setDescription(HeaderWrapper.getDescription(member));
                    attribute.setUnit(HeaderWrapper.getUnits(member));
                    metadataElement.addAttribute(attribute);
                } else if (member.getType().getName().equals("DATE")) {
                    CompoundData dateCompound = compoundData.getCompound(i);
                    ProductData.UTC data2 = HeaderWrapper.createDate(dateCompound);
                    MetadataAttribute attribute2 = new MetadataAttribute(typeName, data2, true);
                    attribute2.setDescription(HeaderWrapper.getDescription(member));
                    attribute2.setUnit(HeaderWrapper.getUnits(member));
                    metadataElement.addAttribute(attribute2);
                } else if (member.getType().isSequenceType()) {
                    SequenceData sequence = compoundData.getSequence(i);
                    if (sequence.getType().getElementType().isCompoundType()) {
                        int j = 0;
                        while (j < sequence.getType().getElementCount()) {
                            CompoundData compound = sequence.getCompound(j);
                            metadataElement.addElement(HeaderWrapper.getAsMetadataElement(compound));
                            ++j;
                        }
                    }
                } else if (member.getType().isCompoundType()) {
                    metadataElement.addElement(HeaderWrapper.getAsMetadataElement(compoundData.getCompound(i)));
                } else if (member.getType().isSimpleType()) {
                    int intValue = compoundData.getInt(i);
                    Map<Object, String> map = HeaderWrapper.getMetaData(member).getItemMap();
                    if (map != null) {
                        String stringValue = map.get(intValue);
                        data = ProductData.createInstance(stringValue);
                    } else {
                        double scalingFactor = HeaderWrapper.getMetaData(member).getScalingFactor();
                        data = scalingFactor == 1.0 ? ProductData.createInstance(new int[]{intValue}) : ProductData.createInstance(new double[]{(double)intValue * scalingFactor});
                    }
                    attribute = new MetadataAttribute(typeName, data, true);
                    attribute.setDescription(HeaderWrapper.getDescription(member));
                    attribute.setUnit(HeaderWrapper.getUnits(member));
                    metadataElement.addAttribute(attribute);
                } else {
                    System.out.println("not handled: name=" + typeName);
                    System.out.println("member = " + member.getType());
                }
            }
            ++i;
        }
        return metadataElement;
    }

    static ProductData.UTC createDate(CompoundData dateCompound) throws IOException {
        int year = dateCompound.getInt("year");
        int dayOfYear = dateCompound.getInt("dayOfYear");
        int millisInDay = dateCompound.getInt("UTCmillis");
        return HeaderUtil.createUTCDate(year, dayOfYear, millisInDay);
    }

    static String getAsString(SequenceData valueSequence) throws IOException {
        byte[] data = new byte[valueSequence.getElementCount()];
        int i = 0;
        while (i < data.length) {
            data[i] = valueSequence.getByte(i);
            ++i;
        }
        return new String(data).trim();
    }

    static double getValue(CompoundData compoundData, String name) throws IOException {
        CompoundType type = compoundData.getType();
        int memberIndex = type.getMemberIndex(name);
        double v = compoundData.getDouble(memberIndex);
        double scalingFactor = HeaderWrapper.getScalingFactor(type.getMember(memberIndex));
        return v * scalingFactor;
    }

    private static double getScalingFactor(CompoundMember member) {
        FormatMetadata metaData = HeaderWrapper.getMetaData(member);
        return metaData.getScalingFactor();
    }

    private static String getDescription(CompoundMember member) {
        FormatMetadata metaData = HeaderWrapper.getMetaData(member);
        return metaData.getDescription();
    }

    private static String getUnits(CompoundMember member) {
        FormatMetadata metaData = HeaderWrapper.getMetaData(member);
        return metaData.getUnits();
    }

    private static FormatMetadata getMetaData(CompoundMember member) {
        Object object = member.getMetadata();
        if (object != null && object instanceof FormatMetadata) {
            return (FormatMetadata)object;
        }
        return new FormatMetadata();
    }
}

