/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.noaa.pod;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.DataFormat;
import com.bc.ceres.binio.IOHandler;
import com.bc.ceres.binio.SequenceData;
import java.awt.Dimension;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.esa.beam.dataio.avhrr.BandReader;
import org.esa.beam.dataio.avhrr.HeaderUtil;
import org.esa.beam.dataio.avhrr.noaa.HeaderWrapper;
import org.esa.beam.dataio.avhrr.noaa.pod.BandReaderFactory;
import org.esa.beam.dataio.avhrr.noaa.pod.CalibrationCoefficientsProvider;
import org.esa.beam.dataio.avhrr.noaa.pod.PodFormatDetector;
import org.esa.beam.dataio.avhrr.noaa.pod.PodGeoCoding;
import org.esa.beam.dataio.avhrr.noaa.pod.PodTypes;
import org.esa.beam.dataio.avhrr.noaa.pod.VideoDataProvider;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.TiePointGrid;

final class PodAvhrrFile
implements VideoDataProvider,
CalibrationCoefficientsProvider {
    static final int PRODUCT_WIDTH = 2048;
    static final int TIE_POINT_GRID_WIDTH = 51;
    static final int TIE_POINT_SAMPLING_X = 40;
    static final int TIE_POINT_OFFSET_X = 25;
    private static final int QUALITY_INDICATOR_BIT_MASK = -872415232;
    private static final double SLOPE_SCALE_FACTOR = PodTypes.getSlopeMetadata().getScalingFactor();
    private static final double INTERCEPT_SCALE_FACTOR = PodTypes.getInterceptMetadata().getScalingFactor();
    private final DataContext context;
    private final CompoundData data;
    private final int tbmHeaderRecordIndex;
    private final int datasetHeaderRecordIndex;
    private final int dataRecordsIndex;
    private final int videoDataIndex;
    private final int qualityDataIndex;
    private final int calibrationCofficientsIndex;
    private final Map<Band, BandReader> bandReaderMap;
    private final String productName;

    static boolean canDecode(IOHandler ioHandler) {
        return new PodFormatDetector().canDecode(ioHandler);
    }

    PodAvhrrFile(IOHandler ioHandler, String productName) {
        this.productName = productName;
        DataFormat dataFormat = new DataFormat(PodTypes.HRPT_TYPE, ByteOrder.BIG_ENDIAN);
        this.context = dataFormat.createContext(ioHandler);
        this.data = this.context.getData();
        this.tbmHeaderRecordIndex = PodTypes.HRPT_TYPE.getMemberIndex("TBM_HEADER_RECORD");
        this.datasetHeaderRecordIndex = PodTypes.HRPT_TYPE.getMemberIndex("DATASET_HEADER_RECORD");
        this.dataRecordsIndex = PodTypes.HRPT_TYPE.getMemberIndex("DATA_RECORDS");
        this.videoDataIndex = PodTypes.DATA_RECORD_TYPE.getMemberIndex("VIDEO_DATA");
        this.qualityDataIndex = PodTypes.DATA_RECORD_TYPE.getMemberIndex("QUALITY_INDICATORS");
        this.calibrationCofficientsIndex = PodTypes.DATA_RECORD_TYPE.getMemberIndex("CALIBRATION_COEFFICIENTS");
        this.bandReaderMap = new HashMap<Band, BandReader>(15);
    }

    @Override
    public SequenceData getVideoData(int recordIndex) throws IOException {
        return this.getDataRecord(recordIndex).getSequence(this.videoDataIndex);
    }

    @Override
    public boolean isValid(int recordIndex) throws IOException {
        return (this.getDataRecord(recordIndex).getInt(this.qualityDataIndex) & 0xCC000000) == 0;
    }

    @Override
    public SequenceData getCalibrationCoefficients(int recordIndex) throws IOException {
        return this.getDataRecord(recordIndex).getSequence(this.calibrationCofficientsIndex);
    }

    @Override
    public double getSlopeScaleFactor() {
        return SLOPE_SCALE_FACTOR;
    }

    @Override
    public double getInterceptScaleFactor() {
        return INTERCEPT_SCALE_FACTOR;
    }

    void dispose() throws IOException {
        this.context.dispose();
    }

    BandReader getBandReader(Band band) {
        return this.bandReaderMap.get(band);
    }

    Product createProduct() throws IOException {
        int dataRecordCount = this.data.getUShort("NUMBER_OF_SCANS");
        Product product = new Product(this.productName, "NOAA_POD_AVHRR_HRPT", 2048, dataRecordCount);
        product.setPreferredTileSize(new Dimension(1024, 1024));
        this.addCountsBand(product, 0);
        this.addCountsBand(product, 1);
        this.addCountsBand(product, 2);
        this.addCountsBand(product, 3);
        this.addCountsBand(product, 4);
        this.addAlbedoBand(product, 0);
        this.addAlbedoBand(product, 1);
        this.addRadianceBand(product, 2);
        this.addRadianceBand(product, 3);
        this.addRadianceBand(product, 4);
        this.addTiePointGridsAndGeoCoding(product);
        CompoundData startTimeCode = this.getDataRecord(0).getCompound("TIME_CODE");
        ProductData.UTC startTime = PodAvhrrFile.toUTC(startTimeCode);
        product.setStartTime(startTime);
        CompoundData endTimeCode = this.getDataRecord(dataRecordCount - 1).getCompound("TIME_CODE");
        ProductData.UTC endTime = PodAvhrrFile.toUTC(endTimeCode);
        product.setEndTime(endTime);
        this.addMetadata(product);
        return product;
    }

    private void addMetadata(Product product) throws IOException {
        MetadataElement tbmHeaderElement = HeaderWrapper.getAsMetadataElement(this.data.getCompound(this.tbmHeaderRecordIndex));
        product.getMetadataRoot().addElement(tbmHeaderElement);
        MetadataElement datasetHeaderElement = HeaderWrapper.getAsMetadataElement(this.data.getCompound(this.datasetHeaderRecordIndex));
        product.getMetadataRoot().addElement(datasetHeaderElement);
    }

    static ProductData.UTC toUTC(CompoundData timeCode) throws IOException {
        int yearDay = timeCode.getUShort(0);
        int year = 1900 + (yearDay >> 9);
        int dayOfYear = yearDay & 0x1FF;
        int millisInDay = timeCode.getInt(1);
        return HeaderUtil.createUTCDate(year, dayOfYear, millisInDay);
    }

    private Band addCountsBand(Product product, int channelIndex) {
        BandReader bandReader = BandReaderFactory.createCountBandReader(channelIndex, this);
        return this.addBand(product, bandReader, channelIndex);
    }

    private Band addAlbedoBand(Product product, int channelIndex) {
        BandReader bandReader = BandReaderFactory.createAlbedoBandReader(channelIndex, this, this);
        return this.addBand(product, bandReader, channelIndex);
    }

    private Band addRadianceBand(Product product, int channelIndex) {
        BandReader bandReader = BandReaderFactory.createRadianceBandReader(channelIndex, this, this);
        return this.addBand(product, bandReader, channelIndex);
    }

    private Band addBand(Product product, BandReader bandReader, int channelIndex) {
        Band band = product.addBand(bandReader.getBandName(), bandReader.getDataType());
        band.setScalingFactor(bandReader.getScalingFactor());
        band.setUnit(bandReader.getBandUnit());
        band.setDescription(bandReader.getBandDescription());
        band.setSpectralBandIndex(channelIndex + 1);
        band.setValidPixelExpression(String.valueOf(band.getName()) + " != NaN");
        this.bandReaderMap.put(band, bandReader);
        return band;
    }

    private void addTiePointGridsAndGeoCoding(Product product) throws IOException {
        int tiePointGridHeight = product.getSceneRasterHeight();
        int tiePointCount = 51 * tiePointGridHeight;
        float[][] gridData = new float[3][tiePointCount];
        int tiePointIndex = 0;
        int y = 0;
        while (y < tiePointGridHeight) {
            int[] rawAngles = new int[51];
            int[] rawLat = new int[51];
            int[] rawLon = new int[51];
            CompoundData dataRecord = this.getDataRecord(y);
            SequenceData solarZenithAngleSequence = dataRecord.getSequence("SOLAR_ZENITH_ANGLES");
            int i = 0;
            while (i < 51) {
                rawAngles[i] = solarZenithAngleSequence.getUByte(i);
                ++i;
            }
            SequenceData earthLocationSequence = dataRecord.getSequence("EARTH_LOCATION");
            int i2 = 0;
            while (i2 < 51) {
                CompoundData earthLocationSequenceCompound = earthLocationSequence.getCompound(i2);
                rawLat[i2] = earthLocationSequenceCompound.getInt(0);
                rawLon[i2] = earthLocationSequenceCompound.getInt(1);
                ++i2;
            }
            double solarZenithAnglesScaleFactor = PodTypes.getSolarZenithAnglesMetadata().getScalingFactor();
            double latScaleFactor = PodTypes.getLatMetadata().getScalingFactor();
            double lonScaleFactor = PodTypes.getLonMetadata().getScalingFactor();
            int pointIndex = 0;
            while (pointIndex < 51) {
                gridData[0][tiePointIndex] = (float)((double)rawAngles[pointIndex] * solarZenithAnglesScaleFactor);
                gridData[1][tiePointIndex] = (float)((double)rawLat[pointIndex] * latScaleFactor);
                gridData[2][tiePointIndex] = (float)((double)rawLon[pointIndex] * lonScaleFactor);
                ++tiePointIndex;
                ++pointIndex;
            }
            ++y;
        }
        this.addTiePointGrid(product, "sun_zenith", PodTypes.getSolarZenithAnglesMetadata().getUnits(), tiePointGridHeight, gridData[0], TiePointGrid.DISCONT_AT_180);
        TiePointGrid latGrid = this.addTiePointGrid(product, "latitude", PodTypes.getLatMetadata().getUnits(), tiePointGridHeight, gridData[1], TiePointGrid.DISCONT_NONE);
        TiePointGrid lonGrid = this.addTiePointGrid(product, "longitude", PodTypes.getLonMetadata().getUnits(), tiePointGridHeight, gridData[2], TiePointGrid.DISCONT_AT_180);
        product.setGeoCoding(new PodGeoCoding(latGrid, lonGrid));
    }

    private TiePointGrid addTiePointGrid(Product product, String name, String units, int height, float[] data, int discontinuity) {
        TiePointGrid grid = new TiePointGrid(name, 51, height, 25.5f, 0.5f, 40.0f, 1.0f, data, discontinuity);
        grid.setUnit(units);
        product.addTiePointGrid(grid);
        return grid;
    }

    private CompoundData getDataRecord(int i) throws IOException {
        return this.data.getSequence(this.dataRecordsIndex).getCompound(i);
    }
}

