/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.noaa.pod;

import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Rectangle;
import javax.media.jai.PlanarImage;
import org.esa.beam.dataio.avhrr.noaa.pod.PodPixelFinder;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.GeoApproximation;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.PixelPosEstimator;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.Scene;
import org.esa.beam.framework.datamodel.TiePointGeoCoding;
import org.esa.beam.framework.datamodel.TiePointGrid;

final class PodGeoCoding
extends TiePointGeoCoding {
    private transient PixelPosEstimator pixelPosEstimator;
    private transient PodPixelFinder pixelFinder;
    private transient GeoApproximation[] approximations;

    PodGeoCoding(TiePointGrid latGrid, TiePointGrid lonGrid) {
        this(latGrid, lonGrid, PodGeoCoding.createApproximations(lonGrid.getGeophysicalImage(), latGrid.getGeophysicalImage()));
    }

    private PodGeoCoding(TiePointGrid latGrid, TiePointGrid lonGrid, GeoApproximation[] approximations) {
        super(latGrid, lonGrid);
        this.approximations = approximations;
        MultiLevelImage lonImage = lonGrid.getGeophysicalImage();
        MultiLevelImage latImage = latGrid.getGeophysicalImage();
        Rectangle bounds = new Rectangle(0, 0, lonGrid.getSceneRasterWidth(), lonGrid.getSceneRasterHeight());
        this.pixelPosEstimator = new PixelPosEstimator(approximations, bounds);
        this.pixelFinder = new PodPixelFinder(lonImage, latImage, null, 0.01);
    }

    @Override
    public boolean canGetPixelPos() {
        return this.pixelPosEstimator.canGetPixelPos();
    }

    @Override
    public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        if (this.pixelPosEstimator.canGetPixelPos()) {
            if (pixelPos == null) {
                pixelPos = new PixelPos();
            }
            this.pixelPosEstimator.getPixelPos(geoPos, pixelPos);
            if (pixelPos.isValid()) {
                this.pixelFinder.findPixelPos(geoPos, pixelPos);
            }
        } else {
            super.getPixelPos(geoPos, pixelPos);
        }
        return pixelPos;
    }

    private static GeoApproximation[] createApproximations(PlanarImage lonImage, PlanarImage latImage) {
        return GeoApproximation.createApproximations(lonImage, latImage, null, 0.5);
    }

    @Override
    public boolean transferGeoCoding(Scene srcScene, Scene destScene, ProductSubsetDef subsetDef) {
        TiePointGrid lonGrid;
        String latGridName = this.getLatGrid().getName();
        String lonGridName = this.getLonGrid().getName();
        Product destProduct = destScene.getProduct();
        TiePointGrid latGrid = destProduct.getTiePointGrid(latGridName);
        if (latGrid == null) {
            latGrid = TiePointGrid.createSubset(this.getLatGrid(), subsetDef);
            destProduct.addTiePointGrid(latGrid);
        }
        if ((lonGrid = destProduct.getTiePointGrid(lonGridName)) == null) {
            lonGrid = TiePointGrid.createSubset(this.getLonGrid(), subsetDef);
            destProduct.addTiePointGrid(lonGrid);
        }
        if (latGrid != null && lonGrid != null) {
            if (subsetDef == null || subsetDef.getRegion() == null) {
                destScene.setGeoCoding(new PodGeoCoding(latGrid, lonGrid, this.approximations));
            } else {
                destScene.setGeoCoding(new PodGeoCoding(latGrid, lonGrid));
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.pixelFinder = null;
        this.pixelPosEstimator = null;
        this.approximations = null;
    }
}

