/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geotiff;

import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.geotiff.GeoTiffProductReader;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.util.io.BeamFileFilter;

public class GeoTiffProductReaderPlugIn
implements ProductReaderPlugIn {
    private static final String[] FORMAT_NAMES = new String[]{"GeoTIFF"};

    @Override
    public DecodeQualification getDecodeQualification(Object input) {
        DecodeQualification decodeQualification;
        Object imageIOInput;
        if (input instanceof String) {
            imageIOInput = new File((String)input);
        } else if (input instanceof File || input instanceof InputStream) {
            imageIOInput = input;
        } else {
            return DecodeQualification.UNABLE;
        }
        ImageInputStream stream = ImageIO.createImageInputStream(imageIOInput);
        try {
            decodeQualification = GeoTiffProductReaderPlugIn.getDecodeQualificationImpl(stream);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (Exception exception) {
                return DecodeQualification.UNABLE;
            }
        }
        stream.close();
        return decodeQualification;
    }

    static DecodeQualification getDecodeQualificationImpl(ImageInputStream stream) {
        try {
            Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(stream);
            TIFFImageReader imageReader = null;
            while (imageReaders.hasNext()) {
                ImageReader reader = imageReaders.next();
                if (!(reader instanceof TIFFImageReader)) continue;
                imageReader = (TIFFImageReader)reader;
                break;
            }
            if (imageReader == null) {
                return DecodeQualification.UNABLE;
            }
        }
        catch (Exception exception) {
            return DecodeQualification.UNABLE;
        }
        return DecodeQualification.SUITABLE;
    }

    @Override
    public Class[] getInputTypes() {
        return new Class[]{String.class, File.class, InputStream.class};
    }

    @Override
    public ProductReader createReaderInstance() {
        return new GeoTiffProductReader(this);
    }

    @Override
    public String[] getFormatNames() {
        return FORMAT_NAMES;
    }

    @Override
    public String[] getDefaultFileExtensions() {
        return new String[]{".tif", ".tiff"};
    }

    @Override
    public String getDescription(Locale locale) {
        return "GeoTIFF data product.";
    }

    @Override
    public BeamFileFilter getProductFileFilter() {
        return new BeamFileFilter(FORMAT_NAMES[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }
}

