/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataio;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.io.IOException;
import org.esa.beam.framework.dataio.AbstractProductBuilder;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.ImageInfo;
import org.esa.beam.framework.datamodel.IndexCoding;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.ProductUtils;

public class ProductFlipper
extends AbstractProductBuilder {
    public static final int FLIP_HORIZONTAL = 1;
    public static final int FLIP_VERTICAL = 2;
    public static final int FLIP_BOTH = 3;
    private int flipType;

    public ProductFlipper(int flipType) {
        this(flipType, false);
    }

    public ProductFlipper(int flipType, boolean sourceProductOwner) {
        super(sourceProductOwner);
        if (flipType != 1 && flipType != 2 && flipType != 3) {
            throw new IllegalArgumentException("invalid flip type");
        }
        this.flipType = flipType;
    }

    public static Product createFlippedProduct(Product sourceProduct, int flipType, String name, String desc) throws IOException {
        return ProductFlipper.createFlippedProduct(sourceProduct, false, flipType, name, desc);
    }

    public static Product createFlippedProduct(Product sourceProduct, boolean sourceProductOwner, int flipType, String name, String desc) throws IOException {
        ProductFlipper productFlipper = new ProductFlipper(flipType, sourceProductOwner);
        return productFlipper.readProductNodes(sourceProduct, null, name, desc);
    }

    public int getFlipType() {
        return this.flipType;
    }

    @Override
    protected Product readProductNodesImpl() throws IOException {
        if (!(this.getInput() instanceof Product)) {
            throw new IllegalArgumentException("unsupported input source: " + this.getInput());
        }
        this.sourceProduct = (Product)this.getInput();
        if (this.flipType == 0) {
            throw new IllegalStateException("no flip type set");
        }
        this.sceneRasterWidth = this.sourceProduct.getSceneRasterWidth();
        this.sceneRasterHeight = this.sourceProduct.getSceneRasterHeight();
        return this.createProduct();
    }

    @Override
    public void close() throws IOException {
        this.disposeBandMap();
        super.close();
    }

    @Override
    public void readBandRasterData(Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        block16: {
            Band sourceBand = (Band)this.bandMap.get(destBand);
            Debug.assertNotNull(sourceBand);
            Guardian.assertNotNull("destBand", destBand);
            Guardian.assertNotNull("destBuffer", destBuffer);
            if (destBuffer.getNumElems() < destWidth * destHeight) {
                throw new IllegalArgumentException("destination buffer too small");
            }
            if (destBuffer.getNumElems() > destWidth * destHeight) {
                throw new IllegalArgumentException("destination buffer too big");
            }
            int sourceW = this.sourceProduct.getSceneRasterWidth();
            int sourceH = this.sourceProduct.getSceneRasterHeight();
            float[] line = new float[sourceW];
            pm.beginTask("Flipping raster data...", destHeight);
            try {
                if (this.flipType == 1) {
                    int j = 0;
                    while (j < destHeight) {
                        if (pm.isCanceled()) {
                            break block16;
                        }
                        int sourceY = destOffsetY + j;
                        sourceBand.readPixels(0, sourceY, sourceW, 1, line, SubProgressMonitor.create(pm, 1));
                        int i = 0;
                        while (i < destWidth) {
                            int sourceX = sourceW - (destOffsetX + i + 1);
                            destBuffer.setElemFloatAt(j * destWidth + i, line[sourceX]);
                            ++i;
                        }
                        ++j;
                    }
                    break block16;
                }
                if (this.flipType == 2) {
                    int j = 0;
                    while (j < destHeight) {
                        if (pm.isCanceled()) {
                            break block16;
                        }
                        int sourceY = sourceH - (destOffsetY + j + 1);
                        sourceBand.readPixels(0, sourceY, sourceW, 1, line, SubProgressMonitor.create(pm, 1));
                        int i = 0;
                        while (i < destWidth) {
                            int sourceX = destOffsetX + i;
                            destBuffer.setElemFloatAt(j * destWidth + i, line[sourceX]);
                            ++i;
                        }
                        ++j;
                    }
                    break block16;
                }
                int j = 0;
                while (j < destHeight) {
                    if (pm.isCanceled()) {
                        break;
                    }
                    int sourceY = sourceH - (destOffsetY + j + 1);
                    sourceBand.readPixels(0, sourceY, sourceW, 1, line, SubProgressMonitor.create(pm, 1));
                    int i = 0;
                    while (i < destWidth) {
                        int sourceX = sourceW - (destOffsetX + i + 1);
                        destBuffer.setElemFloatAt(j * destWidth + i, line[sourceX]);
                        ++i;
                    }
                    ++j;
                }
            }
            finally {
                pm.done();
            }
        }
    }

    @Override
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        throw new IllegalStateException("invalid call");
    }

    private Product createProduct() {
        Debug.assertNotNull(this.getSourceProduct());
        Debug.assertTrue(this.getSceneRasterWidth() > 0);
        Debug.assertTrue(this.getSceneRasterHeight() > 0);
        String newProductName = this.newProductName == null || this.newProductName.length() == 0 ? this.getSourceProduct().getName() : this.newProductName;
        Product product = new Product(newProductName, this.getSourceProduct().getProductType(), this.getSceneRasterWidth(), this.getSceneRasterHeight(), this);
        product.setPointingFactory(this.getSourceProduct().getPointingFactory());
        if (this.newProductDesc == null || this.newProductDesc.length() == 0) {
            product.setDescription(this.getSourceProduct().getDescription());
        } else {
            product.setDescription(this.newProductDesc);
        }
        if (!this.isMetadataIgnored()) {
            this.addMetadataToProduct(product);
        }
        this.addTiePointGridsToProduct(product);
        this.addFlagCodingsToProduct(product);
        this.addIndexCodingsToProduct(product);
        this.addBandsToProduct(product);
        this.addGeoCodingToProduct(product);
        ProductUtils.copyMasks(this.getSourceProduct(), product);
        ProductUtils.copyVectorData(this.sourceProduct, product);
        ProductUtils.copyOverlayMasks(this.sourceProduct, product);
        ProductUtils.copyPreferredTileSize(this.sourceProduct, product);
        product.setStartTime(this.sourceProduct.getStartTime());
        product.setEndTime(this.sourceProduct.getEndTime());
        if (this.sourceProduct.getQuicklookBandName() != null && product.getQuicklookBandName() == null && product.containsBand(this.sourceProduct.getQuicklookBandName())) {
            product.setQuicklookBandName(this.sourceProduct.getQuicklookBandName());
        }
        product.setAutoGrouping(this.sourceProduct.getAutoGrouping());
        return product;
    }

    private void addBandsToProduct(Product product) {
        Debug.assertNotNull(this.getSourceProduct());
        Debug.assertNotNull(product);
        int i = 0;
        while (i < this.getSourceProduct().getNumBands()) {
            Band sourceBand = this.getSourceProduct().getBandAt(i);
            String bandName = sourceBand.getName();
            if (this.isNodeAccepted(bandName)) {
                Band destBand = sourceBand.isScalingApplied() ? new Band(bandName, 30, this.getSceneRasterWidth(), this.getSceneRasterHeight()) : new Band(bandName, sourceBand.getDataType(), this.getSceneRasterWidth(), this.getSceneRasterHeight());
                if (sourceBand.getUnit() != null) {
                    destBand.setUnit(sourceBand.getUnit());
                }
                if (sourceBand.getDescription() != null) {
                    destBand.setDescription(sourceBand.getDescription());
                }
                destBand.setSpectralBandIndex(sourceBand.getSpectralBandIndex());
                destBand.setSpectralWavelength(sourceBand.getSpectralWavelength());
                destBand.setSpectralBandwidth(sourceBand.getSpectralBandwidth());
                destBand.setSolarFlux(sourceBand.getSolarFlux());
                FlagCoding sourceFlagCoding = sourceBand.getFlagCoding();
                IndexCoding sourceIndexCoding = sourceBand.getIndexCoding();
                if (sourceFlagCoding != null) {
                    String flagCodingName = sourceFlagCoding.getName();
                    FlagCoding destFlagCoding = product.getFlagCodingGroup().get(flagCodingName);
                    Debug.assertNotNull(destFlagCoding);
                    destBand.setSampleCoding(destFlagCoding);
                } else if (sourceIndexCoding != null) {
                    String indexCodingName = sourceIndexCoding.getName();
                    IndexCoding destIndexCoding = product.getIndexCodingGroup().get(indexCodingName);
                    Debug.assertNotNull(destIndexCoding);
                    destBand.setSampleCoding(destIndexCoding);
                } else {
                    destBand.setSampleCoding(null);
                }
                ImageInfo sourceImageInfo = sourceBand.getImageInfo();
                if (sourceImageInfo != null) {
                    destBand.setImageInfo(sourceImageInfo.createDeepCopy());
                }
                product.addBand(destBand);
                this.bandMap.put(destBand, sourceBand);
            }
            ++i;
        }
    }

    private void addTiePointGridsToProduct(Product product) {
        int i = 0;
        while (i < this.getSourceProduct().getNumTiePointGrids()) {
            TiePointGrid sourceTiePointGrid = this.getSourceProduct().getTiePointGridAt(i);
            if (this.isNodeAccepted(sourceTiePointGrid.getName())) {
                int y;
                float sourceOffsetX = sourceTiePointGrid.getOffsetX();
                float sourceOffsetY = sourceTiePointGrid.getOffsetY();
                float sourceStepX = sourceTiePointGrid.getSubSamplingX();
                float sourceStepY = sourceTiePointGrid.getSubSamplingY();
                if (this.getSubsetDef() != null) {
                    sourceStepX /= (float)this.getSubsetDef().getSubSamplingX();
                    sourceStepY /= (float)this.getSubsetDef().getSubSamplingY();
                    if (this.getSubsetDef().getRegion() != null) {
                        sourceOffsetX -= (float)this.getSubsetDef().getRegion().x;
                        sourceOffsetY -= (float)this.getSubsetDef().getRegion().y;
                    }
                }
                float[] sourcePoints = sourceTiePointGrid.getTiePoints();
                float[] targetPoints = new float[sourcePoints.length];
                int width = sourceTiePointGrid.getRasterWidth();
                int height = sourceTiePointGrid.getRasterHeight();
                if (this.flipType == 1) {
                    sourceOffsetX = (float)sourceTiePointGrid.getSceneRasterWidth() - (float)(width - 1) * sourceStepX - sourceOffsetX;
                    y = 0;
                    while (y < height) {
                        int x = 0;
                        while (x < width) {
                            targetPoints[x + y * width] = sourcePoints[width - x - 1 + y * width];
                            ++x;
                        }
                        ++y;
                    }
                } else if (this.flipType == 2) {
                    sourceOffsetY = (float)sourceTiePointGrid.getSceneRasterHeight() - (float)(height - 1) * sourceStepY - sourceOffsetY;
                    y = 0;
                    while (y < height) {
                        System.arraycopy(sourcePoints, (height - y - 1) * width, targetPoints, y * width, width);
                        ++y;
                    }
                } else {
                    sourceOffsetX = (float)sourceTiePointGrid.getSceneRasterWidth() - (float)(width - 1) * sourceStepX - sourceOffsetX;
                    sourceOffsetY = (float)sourceTiePointGrid.getSceneRasterHeight() - (float)(height - 1) * sourceStepY - sourceOffsetY;
                    y = 0;
                    while (y < height) {
                        int lineIndex = height - y - 1;
                        int x = 0;
                        while (x < width) {
                            targetPoints[x + y * width] = sourcePoints[width - x - 1 + lineIndex * width];
                            ++x;
                        }
                        ++y;
                    }
                }
                TiePointGrid tiePointGrid = new TiePointGrid(sourceTiePointGrid.getName(), sourceTiePointGrid.getRasterWidth(), sourceTiePointGrid.getRasterHeight(), sourceOffsetX, sourceOffsetY, sourceStepX, sourceStepY, targetPoints, sourceTiePointGrid.getDiscontinuity());
                tiePointGrid.setUnit(sourceTiePointGrid.getUnit());
                tiePointGrid.setDescription(sourceTiePointGrid.getDescription());
                product.addTiePointGrid(tiePointGrid);
            }
            ++i;
        }
    }

    private void addGeoCodingToProduct(Product product) {
        this.getSourceProduct().transferGeoCodingTo(product, null);
    }
}

