/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import javax.media.jai.KernelJAI;
import javax.media.jai.operator.ConvolveDescriptor;
import org.esa.beam.framework.datamodel.FilterBand;
import org.esa.beam.framework.datamodel.Kernel;
import org.esa.beam.framework.datamodel.RasterDataNode;

public class ConvolutionFilterBand
extends FilterBand {
    private final Kernel kernel;
    private final int iterationCount;

    public ConvolutionFilterBand(String name, RasterDataNode source, Kernel kernel, int iterationCount) {
        super(name, source.getGeophysicalDataType() == 31 ? 31 : 30, source.getSceneRasterWidth(), source.getSceneRasterHeight(), source);
        this.kernel = kernel;
        this.iterationCount = iterationCount;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    @Override
    protected RenderedImage createSourceLevelImage(RenderedImage sourceImage, int level, RenderingHints rh) {
        KernelJAI jaiKernel = this.createJaiKernel();
        RenderedImage targetImage = sourceImage;
        int i = 0;
        while (i < this.iterationCount) {
            targetImage = ConvolveDescriptor.create(targetImage, jaiKernel, rh);
            ++i;
        }
        return targetImage;
    }

    private KernelJAI createJaiKernel() {
        double[] data = this.kernel.getKernelData(null);
        float[] scaledData = new float[data.length];
        double factor = this.kernel.getFactor();
        int i = 0;
        while (i < data.length) {
            scaledData[i] = (float)(data[i] * factor);
            ++i;
        }
        return new KernelJAI(this.kernel.getWidth(), this.kernel.getHeight(), this.kernel.getXOrigin(), this.kernel.getYOrigin(), scaledData);
    }
}

