/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import javax.media.jai.Histogram;
import javax.media.jai.UnpackedImageData;
import org.esa.beam.framework.datamodel.Scaling;
import org.esa.beam.framework.datamodel.Stx;
import org.esa.beam.framework.datamodel.StxFactory;
import org.esa.beam.framework.datamodel.StxOp;
import org.esa.beam.util.math.DoubleList;

public final class HistogramStxOp
extends StxOp {
    private final Histogram histogram;
    private final Scaling scaling;

    public HistogramStxOp(int binCount, double minimum, double maximum, boolean intHistogram, boolean logHistogram) {
        super("Histogram");
        if (Double.isNaN(minimum) || Double.isInfinite(minimum)) {
            minimum = 0.0;
        }
        if (Double.isNaN(maximum) || Double.isInfinite(maximum)) {
            maximum = minimum;
        }
        this.scaling = Stx.getHistogramScaling(logHistogram);
        this.histogram = StxFactory.createHistogram(binCount, minimum, maximum, logHistogram, intHistogram);
    }

    public Histogram getHistogram() {
        return this.histogram;
    }

    @Override
    public void accumulateData(UnpackedImageData dataPixels, UnpackedImageData maskPixels) {
        DoubleList values = StxOp.asDoubleList(dataPixels);
        int dataPixelStride = dataPixels.pixelStride;
        int dataLineStride = dataPixels.lineStride;
        int dataBandOffset = dataPixels.bandOffsets[0];
        byte[] mask = null;
        int maskPixelStride = 0;
        int maskLineStride = 0;
        int maskBandOffset = 0;
        if (maskPixels != null) {
            mask = maskPixels.getByteData(0);
            maskPixelStride = maskPixels.pixelStride;
            maskLineStride = maskPixels.lineStride;
            maskBandOffset = maskPixels.bandOffsets[0];
        }
        int width = dataPixels.rect.width;
        int height = dataPixels.rect.height;
        int dataLineOffset = dataBandOffset;
        int maskLineOffset = maskBandOffset;
        int[] bins = this.histogram.getBins(0);
        double lowValue = this.histogram.getLowValue(0);
        double highValue = this.histogram.getHighValue(0);
        double binWidth = (highValue - lowValue) / (double)bins.length;
        int y = 0;
        while (y < height) {
            int dataPixelOffset = dataLineOffset;
            int maskPixelOffset = maskLineOffset;
            int x = 0;
            while (x < width) {
                double value;
                if ((mask == null || mask[maskPixelOffset] != 0) && (value = this.scaling.scale(values.getDouble(dataPixelOffset))) >= lowValue && value <= highValue) {
                    int i = (int)((value - lowValue) / binWidth);
                    if (i == bins.length) {
                        // empty if block
                    }
                    int n = --i;
                    bins[n] = bins[n] + 1;
                }
                dataPixelOffset += dataPixelStride;
                maskPixelOffset += maskPixelStride;
                ++x;
            }
            dataLineOffset += dataLineStride;
            maskLineOffset += maskLineStride;
            ++y;
        }
    }
}

