/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import Jama.LUDecomposition;
import Jama.Matrix;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.jexp.ParseException;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ScaleDescriptor;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.AbstractGeoCoding;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.BasicPixelGeoCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoCodingFactory;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.Scene;
import org.esa.beam.framework.datamodel.TiePointGeoCoding;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.util.BitRaster;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.math.IndexValidator;
import org.esa.beam.util.math.MathUtils;

public class PixelGeoCoding
extends AbstractGeoCoding
implements BasicPixelGeoCoding {
    private static final String SYSPROP_PIXEL_GEO_CODING_USE_TILING = "beam.pixelGeoCoding.useTiling";
    private static final String SYSPROP_PIXEL_GEO_CODING_FRACTION_ACCURACY = "beam.pixelGeoCoding.fractionAccuracy";
    private static final int MAX_SEARCH_CYCLES = 10;
    private static final float EPS = 0.04f;
    private static final boolean TRACE = false;
    private static final float D2R = (float)Math.PI / 180;
    private Boolean crossingMeridianAt180;
    private final Band latBand;
    private final Band lonBand;
    private final String validMaskExpression;
    private final int searchRadius;
    private final int rasterWidth;
    private final int rasterHeight;
    private final boolean useTiling;
    private final boolean fractionAccuracy;
    private GeoCoding pixelPosEstimator;
    private final boolean estimatorCreatedInternally;
    private PixelGrid latGrid;
    private PixelGrid lonGrid;
    private boolean initialized;
    private LatLonImage latLonImage;
    private double deltaThreshold;

    public PixelGeoCoding(Band latBand, Band lonBand, String validMask, int searchRadius) {
        Guardian.assertNotNull("latBand", latBand);
        Guardian.assertNotNull("lonBand", lonBand);
        if (latBand.getProduct() == null) {
            throw new IllegalArgumentException("latBand.getProduct() == null");
        }
        if (lonBand.getProduct() == null) {
            throw new IllegalArgumentException("lonBand.getProduct() == null");
        }
        if (latBand.getProduct() != lonBand.getProduct()) {
            throw new IllegalArgumentException("latBand.getProduct() != lonBand.getProduct()");
        }
        if (latBand.getProduct().getSceneRasterWidth() < 2 || latBand.getProduct().getSceneRasterHeight() < 2) {
            throw new IllegalArgumentException("latBand.getProduct().getSceneRasterWidth() < 2 || latBand.getProduct().getSceneRasterHeight() < 2");
        }
        this.latBand = latBand;
        this.lonBand = lonBand;
        this.validMaskExpression = validMask;
        this.searchRadius = searchRadius;
        this.rasterWidth = latBand.getSceneRasterWidth();
        this.rasterHeight = latBand.getSceneRasterHeight();
        boolean disableTiling = "false".equalsIgnoreCase(System.getProperty(SYSPROP_PIXEL_GEO_CODING_USE_TILING));
        this.useTiling = !disableTiling;
        this.fractionAccuracy = this.useTiling && Boolean.getBoolean(SYSPROP_PIXEL_GEO_CODING_FRACTION_ACCURACY);
        this.pixelPosEstimator = latBand.getProduct().getGeoCoding();
        if (this.pixelPosEstimator == null && this.useTiling && this.rasterWidth / 30 > 1 && this.rasterHeight / 30 > 1) {
            int tpGridWidth = this.rasterWidth / 30;
            int tpGridHeight = this.rasterHeight / 30;
            float tpOffsetX = (float)(this.rasterWidth % 30 / 2) + 0.5f;
            float tpOffsetY = (float)(this.rasterHeight % 30 / 2) + 0.5f;
            float unscaledImageOffsetX = -tpOffsetX + 15.0f;
            float unscaledImageOffsetY = -tpOffsetY + 15.0f;
            MultiLevelImage latImage = latBand.getGeophysicalImage();
            MultiLevelImage lonImage = lonBand.getGeophysicalImage();
            float scale = 0.033333335f;
            Interpolation nearestInterpolation = Interpolation.getInstance(0);
            RenderedOp tempLatOffsetImg = ScaleDescriptor.create(latImage, Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(unscaledImageOffsetX), Float.valueOf(unscaledImageOffsetY), nearestInterpolation, null);
            RenderedOp tempLatImg = ScaleDescriptor.create(tempLatOffsetImg, Float.valueOf(scale), Float.valueOf(scale), Float.valueOf(0.0f), Float.valueOf(0.0f), nearestInterpolation, null);
            RenderedOp tempLonOffsetImg = ScaleDescriptor.create(lonImage, Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(unscaledImageOffsetX), Float.valueOf(unscaledImageOffsetY), nearestInterpolation, null);
            RenderedOp tempLonImg = ScaleDescriptor.create(tempLonOffsetImg, Float.valueOf(scale), Float.valueOf(scale), Float.valueOf(0.0f), Float.valueOf(0.0f), nearestInterpolation, null);
            int minX = tempLatImg.getMinX();
            int minY = tempLatImg.getMinY();
            int numTiePoints = tpGridWidth * tpGridHeight;
            float[] latTiePoints = tempLatImg.getAsBufferedImage().getRaster().getPixels(minX, minY, tpGridWidth, tpGridHeight, new float[numTiePoints]);
            float[] lonTiePoints = tempLonImg.getAsBufferedImage().getRaster().getPixels(minX, minY, tpGridWidth, tpGridHeight, new float[numTiePoints]);
            TiePointGrid tpLatGrid = new TiePointGrid("lat", tpGridWidth, tpGridHeight, tpOffsetX, tpOffsetY, 30.0f, 30.0f, latTiePoints, true);
            TiePointGrid tpLonGrid = new TiePointGrid("lon", tpGridWidth, tpGridHeight, tpOffsetX, tpOffsetY, 30.0f, 30.0f, lonTiePoints, true);
            this.pixelPosEstimator = new TiePointGeoCoding(tpLatGrid, tpLonGrid);
            this.estimatorCreatedInternally = true;
        } else {
            this.estimatorCreatedInternally = false;
        }
        if (this.pixelPosEstimator != null) {
            if (searchRadius < 2) {
                throw new IllegalArgumentException("searchRadius < 2");
            }
            this.crossingMeridianAt180 = this.pixelPosEstimator.isCrossingMeridianAt180();
            GeoPos p0 = this.pixelPosEstimator.getGeoPos(new PixelPos(0.5f, 0.5f), null);
            GeoPos p1 = this.pixelPosEstimator.getGeoPos(new PixelPos(1.5f, 0.5f), null);
            float r = (float)Math.cos(Math.toRadians(p1.lat));
            float dlat = Math.abs(p0.lat - p1.lat);
            float dlon = r * PixelGeoCoding.lonDiff(p0.lon, p1.lon);
            float delta = dlat * dlat + dlon * dlon;
            this.deltaThreshold = Math.sqrt(delta) * 2.0;
        }
        this.initialized = false;
    }

    public PixelGeoCoding(Band latBand, Band lonBand, String validMask, int searchRadius, ProgressMonitor pm) throws IOException {
        this(latBand, lonBand, validMask, searchRadius);
        this.initData(latBand, lonBand, validMask, pm);
        this.initialized = true;
    }

    private void initData(Band latBand, Band lonBand, String validMaskExpr, ProgressMonitor pm) throws IOException {
        if (this.useTiling) {
            MultiLevelImage validMask = null;
            if (validMaskExpr != null && validMaskExpr.trim().length() > 0 && this.pixelPosEstimator != null) {
                validMask = ImageManager.getInstance().getMaskImage(validMaskExpr, latBand.getProduct());
            }
            this.latLonImage = new LatLonImage((RenderedImage)this.latBand.getGeophysicalImage(), (RenderedImage)this.lonBand.getGeophysicalImage(), (RenderedImage)validMask, this.pixelPosEstimator);
        } else {
            try {
                pm.beginTask("Preparing data for pixel based geo-coding...", 4);
                this.latGrid = PixelGrid.create(latBand, SubProgressMonitor.create(pm, 1));
                this.lonGrid = PixelGrid.create(lonBand, SubProgressMonitor.create(pm, 1));
                if (validMaskExpr != null && validMaskExpr.trim().length() > 0) {
                    BitRaster validMask = latBand.getProduct().createValidMask(validMaskExpr, SubProgressMonitor.create(pm, 1));
                    this.fillInvalidGaps(new RasterDataNode.ValidMaskValidator(this.rasterHeight, 0, validMask), (float[])this.latGrid.getDataElems(), (float[])this.lonGrid.getDataElems(), SubProgressMonitor.create(pm, 1));
                }
            }
            finally {
                pm.done();
            }
        }
    }

    protected void fillInvalidGaps(IndexValidator validator, float[] latElems, float[] lonElems, ProgressMonitor pm) {
        if (this.pixelPosEstimator != null) {
            try {
                pm.beginTask("Filling invalid pixel gaps", this.rasterHeight);
                PixelPos pixelPos = new PixelPos();
                GeoPos geoPos = new GeoPos();
                int y = 0;
                while (y < this.rasterHeight) {
                    int x = 0;
                    while (x < this.rasterWidth) {
                        int i = y * this.rasterWidth + x;
                        if (!validator.validateIndex(i)) {
                            pixelPos.x = x;
                            pixelPos.y = y;
                            geoPos = this.pixelPosEstimator.getGeoPos(pixelPos, geoPos);
                            latElems[i] = geoPos.lat;
                            lonElems[i] = geoPos.lon;
                        }
                        ++x;
                    }
                    pm.worked(1);
                    ++y;
                }
            }
            finally {
                pm.done();
            }
        }
    }

    public static long getRequiredMemory(Product product, boolean usesValidMask) {
        GeoCoding geoCoding = product.getGeoCoding();
        if (geoCoding == null) {
            return 0L;
        }
        long pixelCount = product.getSceneRasterWidth() * product.getSceneRasterHeight();
        long size = 8L * pixelCount;
        if (geoCoding.isCrossingMeridianAt180()) {
            size += 8L * pixelCount;
        }
        if (usesValidMask) {
            size += pixelCount / 8L;
        }
        return size;
    }

    @Override
    public Band getLatBand() {
        return this.latBand;
    }

    @Override
    public Band getLonBand() {
        return this.lonBand;
    }

    @Override
    public String getValidMask() {
        return this.validMaskExpression;
    }

    @Override
    public GeoCoding getPixelPosEstimator() {
        if (this.estimatorCreatedInternally) {
            return null;
        }
        return this.pixelPosEstimator;
    }

    @Override
    public int getSearchRadius() {
        return this.searchRadius;
    }

    @Override
    public boolean isCrossingMeridianAt180() {
        if (this.crossingMeridianAt180 == null) {
            this.crossingMeridianAt180 = false;
            PixelPos[] pixelPoses = ProductUtils.createPixelBoundary(this.lonBand, null, 1);
            try {
                float[] firstLonValue = new float[1];
                this.lonBand.readPixels(0, 0, 1, 1, firstLonValue);
                float[] secondLonValue = new float[1];
                int i = 1;
                while (i < pixelPoses.length) {
                    PixelPos pixelPos = pixelPoses[i];
                    this.lonBand.readPixels((int)pixelPos.x, (int)pixelPos.y, 1, 1, secondLonValue);
                    if (Math.abs(firstLonValue[0] - secondLonValue[0]) > 180.0f) {
                        this.crossingMeridianAt180 = true;
                        break;
                    }
                    firstLonValue[0] = secondLonValue[0];
                    ++i;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("raster data is not readable", e);
            }
        }
        return this.crossingMeridianAt180;
    }

    @Override
    public boolean canGetPixelPos() {
        return true;
    }

    @Override
    public boolean canGetGeoPos() {
        return true;
    }

    @Override
    public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        this.initialize();
        if (pixelPos == null) {
            pixelPos = new PixelPos();
        }
        if (geoPos.isValid()) {
            if (this.pixelPosEstimator != null) {
                this.getPixelPosUsingEstimator(geoPos, pixelPos);
            } else {
                this.getPixelPosUsingQuadTreeSearch(geoPos, pixelPos);
            }
        } else {
            pixelPos.setInvalid();
        }
        return pixelPos;
    }

    public void getPixelPosUsingEstimator(GeoPos geoPos, PixelPos pixelPos) {
        this.initialize();
        pixelPos = this.pixelPosEstimator.getPixelPos(geoPos, pixelPos);
        if (!pixelPos.isValid()) {
            this.getPixelPosUsingQuadTreeSearch(geoPos, pixelPos);
            return;
        }
        int x0 = (int)Math.floor(pixelPos.x);
        int y0 = (int)Math.floor(pixelPos.y);
        if (x0 >= 0 && x0 < this.rasterWidth && y0 >= 0 && y0 < this.rasterHeight) {
            float minDelta;
            int y1;
            int x1;
            float lat0 = geoPos.lat;
            float lon0 = geoPos.lon;
            pixelPos.setLocation(x0, y0);
            int cycles = 0;
            do {
                x1 = (int)Math.floor(pixelPos.x);
                y1 = (int)Math.floor(pixelPos.y);
                minDelta = this.findBestPixel(x1, y1, lat0, lon0, pixelPos);
            } while (++cycles < 10 && (x1 != (int)pixelPos.x || y1 != (int)pixelPos.y) && this.bestPixelIsOnSearchBorder(x1, y1, pixelPos));
            if (Math.sqrt(minDelta) < this.deltaThreshold) {
                pixelPos.setLocation(pixelPos.x + 0.5f, pixelPos.y + 0.5f);
            } else {
                pixelPos.setInvalid();
            }
        }
    }

    private boolean bestPixelIsOnSearchBorder(int x0, int y0, PixelPos bestPixel) {
        int diffX = Math.abs((int)bestPixel.x - x0);
        int diffY = Math.abs((int)bestPixel.y - y0);
        return diffX > this.searchRadius - 2 || diffY > this.searchRadius - 2;
    }

    private float findBestPixel(int x0, int y0, float lat0, float lon0, PixelPos bestPixel) {
        int x1 = x0 - this.searchRadius;
        int y1 = y0 - this.searchRadius;
        int x2 = x0 + this.searchRadius;
        int y2 = y0 + this.searchRadius;
        x1 = Math.max(x1, 0);
        y1 = Math.max(y1, 0);
        x2 = Math.min(x2, this.rasterWidth - 1);
        y2 = Math.min(y2, this.rasterHeight - 1);
        float r = (float)Math.cos(lat0 * ((float)Math.PI / 180));
        if (this.useTiling) {
            Rectangle rect = new Rectangle(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
            Raster latLonData = this.latLonImage.getData(rect);
            ComponentSampleModel sampleModel = (ComponentSampleModel)latLonData.getSampleModel();
            DataBufferFloat dataBuffer = (DataBufferFloat)latLonData.getDataBuffer();
            float[][] bankData = dataBuffer.getBankData();
            int sampleModelTranslateX = latLonData.getSampleModelTranslateX();
            int sampleModelTranslateY = latLonData.getSampleModelTranslateY();
            int scanlineStride = sampleModel.getScanlineStride();
            int pixelStride = sampleModel.getPixelStride();
            int bankDataIndex = (y0 - sampleModelTranslateY) * scanlineStride + (x0 - sampleModelTranslateX) * pixelStride;
            float lat = bankData[0][bankDataIndex];
            float lon = bankData[1][bankDataIndex];
            float dlat = Math.abs(lat - lat0);
            float dlon = r * PixelGeoCoding.lonDiff(lon, lon0);
            float minDelta = dlat * dlat + dlon * dlon;
            int y = y1;
            while (y <= y2) {
                int x = x1;
                while (x <= x2) {
                    if (x != x0 || y != y0) {
                        bankDataIndex = (y - sampleModelTranslateY) * scanlineStride + (x - sampleModelTranslateX) * pixelStride;
                        lat = bankData[0][bankDataIndex];
                        lon = bankData[1][bankDataIndex];
                        dlat = Math.abs(lat - lat0);
                        float delta = dlat * dlat + (dlon = r * PixelGeoCoding.lonDiff(lon, lon0)) * dlon;
                        if (delta < minDelta) {
                            minDelta = delta;
                            bestPixel.setLocation(x, y);
                        } else if (delta == minDelta && (float)(Math.abs(x - x0) + Math.abs(y - y0)) > Math.abs(bestPixel.x - (float)x0) + Math.abs(bestPixel.y - (float)y0)) {
                            bestPixel.setLocation(x, y);
                        }
                    }
                    ++x;
                }
                ++y;
            }
            return minDelta;
        }
        float[] latArray = (float[])this.latGrid.getRasterData().getElems();
        float[] lonArray = (float[])this.lonGrid.getRasterData().getElems();
        int i = this.rasterWidth * y0 + x0;
        float lat = latArray[i];
        float lon = lonArray[i];
        float dlat = Math.abs(lat - lat0);
        float dlon = r * PixelGeoCoding.lonDiff(lon, lon0);
        float minDelta = dlat * dlat + dlon * dlon;
        int y = y1;
        while (y <= y2) {
            int x = x1;
            while (x <= x2) {
                if (x != x0 || y != y0) {
                    i = this.rasterWidth * y + x;
                    lat = latArray[i];
                    lon = lonArray[i];
                    dlat = Math.abs(lat - lat0);
                    float delta = dlat * dlat + (dlon = r * PixelGeoCoding.lonDiff(lon, lon0)) * dlon;
                    if (delta < minDelta) {
                        minDelta = delta;
                        bestPixel.setLocation(x, y);
                    }
                }
                ++x;
            }
            ++y;
        }
        return minDelta;
    }

    public void getPixelPosUsingQuadTreeSearch(GeoPos geoPos, PixelPos pixelPos) {
        this.initialize();
        Result result = new Result();
        boolean pixelFound = this.quadTreeSearch(0, geoPos.lat, geoPos.lon, 0, 0, this.rasterWidth, this.rasterHeight, result);
        if (pixelFound) {
            pixelPos.setLocation((float)result.x + 0.5f, (float)result.y + 0.5f);
        } else {
            pixelPos.setInvalid();
        }
    }

    private synchronized void initialize() {
        if (!this.initialized) {
            try {
                this.initData(this.latBand, this.lonBand, this.validMaskExpression, ProgressMonitor.NULL);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to initialse data for pixel geo-coding", e);
            }
            this.initialized = true;
        }
    }

    @Override
    public GeoPos getGeoPos(PixelPos pixelPos, GeoPos geoPos) {
        this.initialize();
        if (geoPos == null) {
            geoPos = new GeoPos();
        }
        geoPos.setInvalid();
        if (pixelPos.isValid()) {
            int x0 = (int)Math.floor(pixelPos.getX());
            int y0 = (int)Math.floor(pixelPos.getY());
            if (x0 >= 0 && x0 < this.rasterWidth && y0 >= 0 && y0 < this.rasterHeight) {
                if (this.fractionAccuracy) {
                    if (x0 > 0 && pixelPos.x - (float)x0 < 0.5f || x0 == this.rasterWidth - 1) {
                        --x0;
                    }
                    if (y0 > 0 && pixelPos.y - (float)y0 < 0.5f || y0 == this.rasterHeight - 1) {
                        --y0;
                    }
                    float wx = pixelPos.x - ((float)x0 + 0.5f);
                    float wy = pixelPos.y - ((float)y0 + 0.5f);
                    Raster latLonData = this.latLonImage.getData(new Rectangle(x0, y0, 2, 2));
                    float lat = this.interpolate(wx, wy, latLonData, 0);
                    float lon = this.interpolate(wx, wy, latLonData, 1);
                    geoPos.setLocation(lat, lon);
                } else {
                    this.getGeoPosInternal(x0, y0, geoPos);
                }
            } else if (this.pixelPosEstimator != null) {
                return this.pixelPosEstimator.getGeoPos(pixelPos, geoPos);
            }
        }
        return geoPos;
    }

    private float interpolate(float wx, float wy, Raster raster, int band) {
        int x0 = raster.getMinX();
        int x1 = x0 + 1;
        int y0 = raster.getMinY();
        int y1 = y0 + 1;
        float d00 = raster.getSampleFloat(x0, y0, band);
        float d10 = raster.getSampleFloat(x1, y0, band);
        float d01 = raster.getSampleFloat(x0, y1, band);
        float d11 = raster.getSampleFloat(x1, y1, band);
        if (band == 0) {
            return MathUtils.interpolate2D(wx, wy, d00, d10, d01, d11);
        }
        return GeoCodingFactory.interpolateLon(wx, wy, d00, d10, d01, d11);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PixelGeoCoding that = (PixelGeoCoding)o;
        if (this.searchRadius != that.searchRadius) {
            return false;
        }
        if (!this.latBand.equals(that.latBand)) {
            return false;
        }
        if (!this.lonBand.equals(that.lonBand)) {
            return false;
        }
        return !(this.validMaskExpression != null ? !this.validMaskExpression.equals(that.validMaskExpression) : that.validMaskExpression != null);
    }

    public int hashCode() {
        int result = this.latBand.hashCode();
        result = 31 * result + this.lonBand.hashCode();
        result = 31 * result + (this.validMaskExpression != null ? this.validMaskExpression.hashCode() : 0);
        result = 31 * result + this.searchRadius;
        return result;
    }

    @Override
    public synchronized void dispose() {
        if (this.latGrid != null) {
            this.latGrid.dispose();
            this.latGrid = null;
        }
        if (this.lonGrid != null) {
            this.lonGrid.dispose();
            this.lonGrid = null;
        }
        if (this.latLonImage != null) {
            this.latLonImage.dispose();
            this.latLonImage = null;
        }
        if (this.estimatorCreatedInternally) {
            this.pixelPosEstimator.dispose();
        }
        this.pixelPosEstimator = null;
    }

    private boolean quadTreeSearch(int depth, float lat, float lon, int x, int y, int w, int h, Result result) {
        boolean definitelyOutside;
        float lonMin;
        float lonMax;
        if (w < 2 || h < 2) {
            return false;
        }
        int x1 = x;
        int x2 = x1 + w - 1;
        int y1 = y;
        int y2 = y1 + h - 1;
        GeoPos geoPos = new GeoPos();
        this.getGeoPosInternal(x1, y1, geoPos);
        float lat0 = geoPos.lat;
        float lon0 = geoPos.lon;
        this.getGeoPosInternal(x1, y2, geoPos);
        float lat1 = geoPos.lat;
        float lon1 = geoPos.lon;
        this.getGeoPosInternal(x2, y1, geoPos);
        float lat2 = geoPos.lat;
        float lon2 = geoPos.lon;
        this.getGeoPosInternal(x2, y2, geoPos);
        float lat3 = geoPos.lat;
        float lon3 = geoPos.lon;
        float latMin = PixelGeoCoding.min(lat0, PixelGeoCoding.min(lat1, PixelGeoCoding.min(lat2, lat3))) - 0.04f;
        float latMax = PixelGeoCoding.max(lat0, PixelGeoCoding.max(lat1, PixelGeoCoding.max(lat2, lat3))) + 0.04f;
        if (PixelGeoCoding.isCrossingMeridianInsideQuad(this.isCrossingMeridianAt180(), lon0, lon1, lon2, lon3)) {
            float signumLon = Math.signum(lon);
            if (signumLon > 0.0f) {
                lonMax = 180.0f;
                lonMin = PixelGeoCoding.getPositiveLonMin(lon0, lon1, lon2, lon3);
            } else {
                lonMin = -180.0f;
                lonMax = PixelGeoCoding.getNegativeLonMax(lon0, lon1, lon2, lon3);
            }
        } else {
            lonMin = PixelGeoCoding.min(lon0, PixelGeoCoding.min(lon1, PixelGeoCoding.min(lon2, lon3))) - 0.04f;
            lonMax = PixelGeoCoding.max(lon0, PixelGeoCoding.max(lon1, PixelGeoCoding.max(lon2, lon3))) + 0.04f;
        }
        boolean pixelFound = false;
        boolean bl = definitelyOutside = lat < latMin || lat > latMax || lon < lonMin || lon > lonMax;
        if (!definitelyOutside) {
            if (w == 2 && h == 2) {
                float f = (float)Math.cos(lat * ((float)Math.PI / 180));
                if (result.update(x1, y1, PixelGeoCoding.sqr(lat - lat0, f * (lon - lon0)))) {
                    pixelFound = true;
                }
                if (result.update(x1, y2, PixelGeoCoding.sqr(lat - lat1, f * (lon - lon1)))) {
                    pixelFound = true;
                }
                if (result.update(x2, y1, PixelGeoCoding.sqr(lat - lat2, f * (lon - lon2)))) {
                    pixelFound = true;
                }
                if (result.update(x2, y2, PixelGeoCoding.sqr(lat - lat3, f * (lon - lon3)))) {
                    pixelFound = true;
                }
            } else if (w >= 2 && h >= 2) {
                pixelFound = this.quadTreeRecursion(depth, lat, lon, x1, y1, w, h, result);
            }
        }
        return pixelFound;
    }

    static float getNegativeLonMax(float lon0, float lon1, float lon2, float lon3) {
        float lonMax = -180.0f;
        if (lon0 < 0.0f) {
            lonMax = lon0;
        }
        if (lon1 < 0.0f) {
            lonMax = PixelGeoCoding.max(lon1, lonMax);
        }
        if (lon2 < 0.0f) {
            lonMax = PixelGeoCoding.max(lon2, lonMax);
        }
        if (lon3 < 0.0f) {
            lonMax = PixelGeoCoding.max(lon3, lonMax);
        }
        return lonMax;
    }

    static float getPositiveLonMin(float lon0, float lon1, float lon2, float lon3) {
        float lonMin = 180.0f;
        if (lon0 >= 0.0f) {
            lonMin = lon0;
        }
        if (lon1 >= 0.0f) {
            lonMin = PixelGeoCoding.min(lon1, lonMin);
        }
        if (lon2 >= 0.0f) {
            lonMin = PixelGeoCoding.min(lon2, lonMin);
        }
        if (lon3 >= 0.0f) {
            lonMin = PixelGeoCoding.min(lon3, lonMin);
        }
        return lonMin;
    }

    static boolean isCrossingMeridianInsideQuad(boolean crossingMeridianInsideProduct, float lon0, float lon1, float lon2, float lon3) {
        if (!crossingMeridianInsideProduct) {
            return false;
        }
        float lonMin = PixelGeoCoding.min(lon0, PixelGeoCoding.min(lon1, PixelGeoCoding.min(lon2, lon3)));
        float lonMax = PixelGeoCoding.max(lon0, PixelGeoCoding.max(lon1, PixelGeoCoding.max(lon2, lon3)));
        return (double)Math.abs(lonMax - lonMin) > 180.0;
    }

    private void getGeoPosInternal(int pixelX, int pixelY, GeoPos geoPos) {
        if (this.useTiling) {
            int x = this.latLonImage.getMinX() + pixelX;
            int y = this.latLonImage.getMinY() + pixelY;
            Raster data = this.latLonImage.getData(new Rectangle(x, y, 1, 1));
            float lat = data.getSampleFloat(x, y, 0);
            float lon = data.getSampleFloat(x, y, 1);
            geoPos.setLocation(lat, lon);
        } else {
            int i = this.rasterWidth * pixelY + pixelX;
            float lat = this.latGrid.getRasterData().getElemFloatAt(i);
            float lon = this.lonGrid.getRasterData().getElemFloatAt(i);
            geoPos.setLocation(lat, lon);
        }
    }

    private boolean quadTreeRecursion(int depth, float lat, float lon, int i, int j, int w, int h, Result result) {
        int w2 = w >> 1;
        int h2 = h >> 1;
        int i2 = i + w2;
        int j2 = j + h2;
        int w2r = w - w2;
        int h2r = h - h2;
        if (w2 < 2) {
            w2 = 2;
        }
        if (h2 < 2) {
            h2 = 2;
        }
        boolean b1 = this.quadTreeSearch(depth + 1, lat, lon, i, j, w2, h2, result);
        boolean b2 = this.quadTreeSearch(depth + 1, lat, lon, i, j2, w2, h2r, result);
        boolean b3 = this.quadTreeSearch(depth + 1, lat, lon, i2, j, w2r, h2, result);
        boolean b4 = this.quadTreeSearch(depth + 1, lat, lon, i2, j2, w2r, h2r, result);
        return b1 || b2 || b3 || b4;
    }

    private static float min(float a, float b) {
        return a <= b ? a : b;
    }

    private static float max(float a, float b) {
        return a >= b ? a : b;
    }

    private static float sqr(float dx, float dy) {
        return dx * dx + dy * dy;
    }

    private static float lonDiff(float a1, float a2) {
        float d = a1 - a2;
        if (d < 0.0f) {
            d = -d;
        }
        if (d > 180.0f) {
            d = 360.0f - d;
        }
        return d;
    }

    private static boolean getPixelPos(float lat, float lon, float[] lata, float[] lona, int[] xa, int[] ya, PixelPos pixelPos) {
        Matrix mA = new Matrix(3, 3);
        mA.set(0, 0, 1.0);
        mA.set(1, 0, 1.0);
        mA.set(2, 0, 1.0);
        mA.set(0, 1, lata[0]);
        mA.set(1, 1, lata[1]);
        mA.set(2, 1, lata[2]);
        mA.set(0, 2, lona[0]);
        mA.set(1, 2, lona[1]);
        mA.set(2, 2, lona[2]);
        LUDecomposition decomp = new LUDecomposition(mA);
        Matrix mB = new Matrix(3, 1);
        mB.set(0, 0, (double)ya[0] + 0.5);
        mB.set(1, 0, (double)ya[1] + 0.5);
        mB.set(2, 0, (double)ya[2] + 0.5);
        Exception err = null;
        Matrix mY = null;
        try {
            mY = decomp.solve(mB);
        }
        catch (Exception e) {
            System.out.printf("y1 = %d, y2 = %d, y3 = %d%n", ya[0], ya[1], ya[2]);
            err = e;
        }
        mB.set(0, 0, (double)xa[0] + 0.5);
        mB.set(1, 0, (double)xa[1] + 0.5);
        mB.set(2, 0, (double)xa[2] + 0.5);
        Matrix mX = null;
        try {
            mX = decomp.solve(mB);
        }
        catch (Exception e) {
            System.out.printf("x1 = %d, x2 = %d, x3 = %d%n", xa[0], xa[1], xa[2]);
            err = e;
        }
        if (err != null) {
            return false;
        }
        float fx = (float)(mX.get(0, 0) + mX.get(1, 0) * (double)lat + mX.get(2, 0) * (double)lon);
        float fy = (float)(mY.get(0, 0) + mY.get(1, 0) * (double)lat + mY.get(2, 0) * (double)lon);
        pixelPos.setLocation(fx, fy);
        return true;
    }

    private void trace(int x0, int y0, int bestX, int bestY, int bestCount) {
        if (bestCount > 0) {
            int dx = bestX - x0;
            int dy = bestY - y0;
            if (Math.abs(dx) >= this.searchRadius || Math.abs(dy) >= this.searchRadius) {
                Debug.trace("WARNING: search radius reached at (x0 = " + x0 + ", y0 = " + y0 + "), " + "(dx = " + dx + ", dy = " + dy + "), " + "#best = " + bestCount);
            }
        } else {
            Debug.trace("WARNING: no better pixel found at (x0 = " + x0 + ", y0 = " + y0 + ")");
        }
    }

    @Override
    public boolean transferGeoCoding(Scene srcScene, Scene destScene, ProductSubsetDef subsetDef) {
        Band srcLonBand;
        Band lonBand;
        Band srcLatBand = this.getLatBand();
        Product destProduct = destScene.getProduct();
        Band latBand = destProduct.getBand(srcLatBand.getName());
        if (latBand == null) {
            latBand = GeoCodingFactory.createSubset(srcLatBand, destScene, subsetDef);
            destProduct.addBand(latBand);
        }
        if ((lonBand = destProduct.getBand((srcLonBand = this.getLonBand()).getName())) == null) {
            lonBand = GeoCodingFactory.createSubset(srcLonBand, destScene, subsetDef);
            destProduct.addBand(lonBand);
        }
        if (this.pixelPosEstimator instanceof AbstractGeoCoding && !this.estimatorCreatedInternally) {
            AbstractGeoCoding origGeoCoding = (AbstractGeoCoding)this.pixelPosEstimator;
            origGeoCoding.transferGeoCoding(srcScene, destScene, subsetDef);
        }
        String validMaskExpression = this.getValidMask();
        try {
            if (validMaskExpression != null) {
                GeoCodingFactory.copyReferencedRasters(validMaskExpression, srcScene, destScene, subsetDef);
            }
        }
        catch (ParseException parseException) {
            validMaskExpression = null;
        }
        destScene.setGeoCoding(new PixelGeoCoding(latBand, lonBand, validMaskExpression, this.getSearchRadius()));
        return true;
    }

    @Override
    public Datum getDatum() {
        if (this.pixelPosEstimator != null) {
            return this.pixelPosEstimator.getDatum();
        }
        return Datum.WGS_84;
    }

    private static class LatLonImage
    extends PointOpImage {
        private final GeoCoding estimator;
        private final RasterFormatTag latRasterFormatTag;
        private final RasterFormatTag lonRasterFormatTag;
        private final RasterFormatTag maskRasterFormatTag;
        private final RasterFormatTag targetRasterFormatTag;

        private static ImageLayout layout(RenderedImage source) {
            SampleModel sampleModel = RasterFactory.createBandedSampleModel(4, source.getTileWidth(), source.getTileHeight(), 2);
            ImageLayout imageLayout = new ImageLayout();
            imageLayout.setSampleModel(sampleModel);
            return imageLayout;
        }

        private static RenderingHints renderingHints(ImageLayout imageLayout) {
            RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout);
            hints.add(new RenderingHints(JAI.KEY_TILE_CACHE, JAI.getDefaultInstance().getTileCache()));
            return hints;
        }

        private static Vector<RenderedImage> vector(RenderedImage image1, RenderedImage image2, RenderedImage image3) {
            Vector<RenderedImage> v = new Vector<RenderedImage>(3);
            v.addElement(image1);
            v.addElement(image2);
            if (image3 != null) {
                v.addElement(image3);
            }
            return v;
        }

        private LatLonImage(RenderedImage latSrc, RenderedImage lonSrc, RenderedImage validSrc, GeoCoding estimator) {
            this(latSrc, lonSrc, validSrc, LatLonImage.layout(latSrc), estimator);
        }

        private LatLonImage(RenderedImage latSrc, RenderedImage lonSrc, RenderedImage maskSrc, ImageLayout imageLayout, GeoCoding estimator) {
            super(LatLonImage.vector(latSrc, lonSrc, maskSrc), imageLayout, (Map)LatLonImage.renderingHints(imageLayout), true);
            this.estimator = estimator;
            this.latRasterFormatTag = LatLonImage.getRasterFormatTag(latSrc.getSampleModel());
            this.lonRasterFormatTag = LatLonImage.getRasterFormatTag(lonSrc.getSampleModel());
            this.maskRasterFormatTag = maskSrc != null ? LatLonImage.getRasterFormatTag(maskSrc.getSampleModel()) : null;
            this.targetRasterFormatTag = LatLonImage.getRasterFormatTag(this.getSampleModel());
        }

        private static RasterFormatTag getRasterFormatTag(SampleModel sampleModel1) {
            int compatibleTag = RasterAccessor.findCompatibleTag(null, sampleModel1);
            return new RasterFormatTag(sampleModel1, compatibleTag);
        }

        @Override
        protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
            RasterAccessor latAcc = new RasterAccessor(sources[0], destRect, this.latRasterFormatTag, this.getSourceImage(0).getColorModel());
            RasterAccessor lonAcc = new RasterAccessor(sources[1], destRect, this.lonRasterFormatTag, this.getSourceImage(1).getColorModel());
            RasterAccessor maskAcc = null;
            if (this.maskRasterFormatTag != null) {
                maskAcc = new RasterAccessor(sources[2], destRect, this.maskRasterFormatTag, this.getSourceImage(2).getColorModel());
            }
            RasterAccessor destAcc = new RasterAccessor(dest, destRect, this.targetRasterFormatTag, this.getColorModel());
            if (latAcc.getDataType() == 5) {
                this.processDoubleLoop(latAcc, lonAcc, maskAcc, destAcc, destRect);
            } else if (latAcc.getDataType() == 4) {
                this.processFloatLoop(latAcc, lonAcc, maskAcc, destAcc, destRect);
            } else {
                throw new IllegalStateException("unsupported data type: " + latAcc.getDataType());
            }
            destAcc.copyDataToRaster();
        }

        private void processDoubleLoop(RasterAccessor latAcc, RasterAccessor lonAcc, RasterAccessor maskAcc, RasterAccessor destAcc, Rectangle destRect) {
            int latLineStride = latAcc.getScanlineStride();
            int latPixelStride = latAcc.getPixelStride();
            int[] sLatBandOffsets = latAcc.getBandOffsets();
            double[][] latData = latAcc.getDoubleDataArrays();
            int lonLineStride = lonAcc.getScanlineStride();
            int lonPixelStride = lonAcc.getPixelStride();
            int[] sLonBandOffsets = lonAcc.getBandOffsets();
            double[][] lonData = lonAcc.getDoubleDataArrays();
            int mLineOffset = 0;
            int mLineStride = 0;
            int mPixelStride = 0;
            byte[] m = null;
            if (maskAcc != null) {
                mLineStride = maskAcc.getScanlineStride();
                mPixelStride = maskAcc.getPixelStride();
                int[] mBandOffsets = maskAcc.getBandOffsets();
                byte[][] mData = maskAcc.getByteDataArrays();
                m = mData[0];
                mLineOffset = mBandOffsets[0];
            }
            int dwidth = destAcc.getWidth();
            int dheight = destAcc.getHeight();
            int dLineStride = destAcc.getScanlineStride();
            int dPixelStride = destAcc.getPixelStride();
            int[] dBandOffsets = destAcc.getBandOffsets();
            float[][] dData = destAcc.getFloatDataArrays();
            double[] lat = latData[0];
            double[] lon = lonData[0];
            float[] dLat = dData[0];
            float[] dLon = dData[1];
            int sLatLineOffset = sLatBandOffsets[0];
            int sLonLineOffset = sLonBandOffsets[0];
            int dLatLineOffset = dBandOffsets[0];
            int dLonLineOffset = dBandOffsets[1];
            PixelPos pixelPos = new PixelPos();
            GeoPos geoPos = new GeoPos();
            int y = 0;
            while (y < dheight) {
                int sLatPixelOffset = sLatLineOffset;
                int sLonPixelOffset = sLonLineOffset;
                int mPixelOffset = mLineOffset;
                int dLatPixelOffset = dLatLineOffset;
                int dLonPixelOffset = dLonLineOffset;
                sLatLineOffset += latLineStride;
                sLonLineOffset += lonLineStride;
                mLineOffset += mLineStride;
                dLatLineOffset += dLineStride;
                dLonLineOffset += dLineStride;
                int x = 0;
                while (x < dwidth) {
                    if (m != null && m[mPixelOffset] == 0) {
                        int x0 = x + destRect.x;
                        int y0 = y + destRect.y;
                        pixelPos.setLocation(x0, y0);
                        this.estimator.getGeoPos(pixelPos, geoPos);
                        dLat[dLatPixelOffset] = geoPos.lat;
                        dLon[dLonPixelOffset] = geoPos.lon;
                    } else {
                        dLat[dLatPixelOffset] = (float)lat[sLatPixelOffset];
                        dLon[dLonPixelOffset] = (float)lon[sLonPixelOffset];
                    }
                    sLatPixelOffset += latPixelStride;
                    sLonPixelOffset += lonPixelStride;
                    mPixelOffset += mPixelStride;
                    dLatPixelOffset += dPixelStride;
                    dLonPixelOffset += dPixelStride;
                    ++x;
                }
                ++y;
            }
        }

        private void processFloatLoop(RasterAccessor latAcc, RasterAccessor lonAcc, RasterAccessor maskAcc, RasterAccessor destAcc, Rectangle destRect) {
            int latLineStride = latAcc.getScanlineStride();
            int latPixelStride = latAcc.getPixelStride();
            int[] sLatBandOffsets = latAcc.getBandOffsets();
            float[][] latData = latAcc.getFloatDataArrays();
            int lonLineStride = lonAcc.getScanlineStride();
            int lonPixelStride = lonAcc.getPixelStride();
            int[] sLonBandOffsets = lonAcc.getBandOffsets();
            float[][] lonData = lonAcc.getFloatDataArrays();
            int mLineOffset = 0;
            int mLineStride = 0;
            int mPixelStride = 0;
            byte[] m = null;
            if (maskAcc != null) {
                mLineStride = maskAcc.getScanlineStride();
                mPixelStride = maskAcc.getPixelStride();
                int[] mBandOffsets = maskAcc.getBandOffsets();
                byte[][] mData = maskAcc.getByteDataArrays();
                m = mData[0];
                mLineOffset = mBandOffsets[0];
            }
            int dwidth = destAcc.getWidth();
            int dheight = destAcc.getHeight();
            int dLineStride = destAcc.getScanlineStride();
            int dPixelStride = destAcc.getPixelStride();
            int[] dBandOffsets = destAcc.getBandOffsets();
            float[][] dData = destAcc.getFloatDataArrays();
            float[] lat = latData[0];
            float[] lon = lonData[0];
            float[] dLat = dData[0];
            float[] dLon = dData[1];
            int sLatLineOffset = sLatBandOffsets[0];
            int sLonLineOffset = sLonBandOffsets[0];
            int dLatLineOffset = dBandOffsets[0];
            int dLonLineOffset = dBandOffsets[1];
            PixelPos pixelPos = new PixelPos();
            GeoPos geoPos = new GeoPos();
            int y = 0;
            while (y < dheight) {
                int sLatPixelOffset = sLatLineOffset;
                int sLonPixelOffset = sLonLineOffset;
                int mPixelOffset = mLineOffset;
                int dLatPixelOffset = dLatLineOffset;
                int dLonPixelOffset = dLonLineOffset;
                sLatLineOffset += latLineStride;
                sLonLineOffset += lonLineStride;
                mLineOffset += mLineStride;
                dLatLineOffset += dLineStride;
                dLonLineOffset += dLineStride;
                int x = 0;
                while (x < dwidth) {
                    if (m != null && m[mPixelOffset] == 0) {
                        int x0 = x + destRect.x;
                        int y0 = y + destRect.y;
                        pixelPos.setLocation(x0, y0);
                        this.estimator.getGeoPos(pixelPos, geoPos);
                        dLat[dLatPixelOffset] = geoPos.lat;
                        dLon[dLonPixelOffset] = geoPos.lon;
                    } else {
                        dLat[dLatPixelOffset] = lat[sLatPixelOffset];
                        dLon[dLonPixelOffset] = lon[sLonPixelOffset];
                    }
                    sLatPixelOffset += latPixelStride;
                    sLonPixelOffset += lonPixelStride;
                    mPixelOffset += mPixelStride;
                    dLatPixelOffset += dPixelStride;
                    dLonPixelOffset += dPixelStride;
                    ++x;
                }
                ++y;
            }
        }
    }

    private static class PixelGrid
    extends TiePointGrid {
        private PixelGrid(Product p, String name, int gridWidth, int gridHeight, float offsetX, float offsetY, float subSamplingX, float subSamplingY, float[] tiePoints) {
            super(name, gridWidth, gridHeight, offsetX, offsetY, subSamplingX, subSamplingY, tiePoints, false);
            this.setOwner(p);
        }

        private static PixelGrid create(Band b, ProgressMonitor pm) throws IOException {
            int w = b.getRasterWidth();
            int h = b.getRasterHeight();
            float[] pixels = new float[w * h];
            b.readPixels(0, 0, w, h, pixels, pm);
            return new PixelGrid(b.getProduct(), b.getName(), w, h, 0.5f, 0.5f, 1.0f, 1.0f, pixels);
        }
    }

    private static class Result {
        public static final float INVALID = Float.MAX_VALUE;
        private int x;
        private int y;
        private float delta = Float.MAX_VALUE;

        private Result() {
        }

        public final boolean update(int x, int y, float delta) {
            boolean b;
            boolean bl = b = delta < this.delta;
            if (b) {
                this.x = x;
                this.y = y;
                this.delta = delta;
            }
            return b;
        }

        public String toString() {
            return "Result[" + this.x + ", " + this.y + ", " + this.delta + "]";
        }
    }
}

