/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductVisitor;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.jai.ResolutionLevel;
import org.esa.beam.jai.TiePointGridOpImage;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.math.IndexValidator;
import org.esa.beam.util.math.MathUtils;
import org.esa.beam.util.math.Range;

public class TiePointGrid
extends RasterDataNode {
    public static int DISCONT_NONE = 0;
    public static int DISCONT_AT_180 = 180;
    public static int DISCONT_AT_360 = 360;
    private final float offsetX;
    private final float offsetY;
    private final float subSamplingX;
    private final float subSamplingY;
    private int discontinuity;
    private volatile TiePointGrid sinGrid;
    private volatile TiePointGrid cosGrid;

    public TiePointGrid(String name, int gridWidth, int gridHeight, float offsetX, float offsetY, float subSamplingX, float subSamplingY, float[] tiePoints) {
        this(name, gridWidth, gridHeight, offsetX, offsetY, subSamplingX, subSamplingY, tiePoints, DISCONT_NONE);
    }

    public TiePointGrid(String name, int gridWidth, int gridHeight, float offsetX, float offsetY, float subSamplingX, float subSamplingY, float[] tiePoints, int discontinuity) {
        super(name, 30, gridWidth, gridHeight);
        Guardian.assertNotNull("tiePoints", tiePoints);
        if (discontinuity != DISCONT_NONE && discontinuity != DISCONT_AT_180 && discontinuity != DISCONT_AT_360) {
            throw new IllegalArgumentException("unsupported discontinuity mode");
        }
        this.discontinuity = discontinuity;
        if (tiePoints.length != gridWidth * gridHeight) {
            throw new IllegalArgumentException("data array size does not match 'gridWidth' x 'gridHeight'");
        }
        if (subSamplingX <= 0.0f) {
            throw new IllegalArgumentException("'subSamplingX' is less or equal zero");
        }
        if (subSamplingY <= 0.0f) {
            throw new IllegalArgumentException("'subSamplingY' is less or equal zero");
        }
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.subSamplingX = subSamplingX;
        this.subSamplingY = subSamplingY;
        this.setData(ProductData.createInstance(tiePoints));
    }

    public TiePointGrid(String name, int gridWidth, int gridHeight, float offsetX, float offsetY, float subSamplingX, float subSamplingY, float[] tiePoints, boolean containsAngles) {
        this(name, gridWidth, gridHeight, offsetX, offsetY, subSamplingX, subSamplingY, tiePoints, containsAngles ? TiePointGrid.getDiscontinuity(tiePoints) : DISCONT_NONE);
    }

    public static int getDiscontinuity(float[] tiePoints) {
        Range range = Range.computeRangeFloat(tiePoints, IndexValidator.TRUE, null, ProgressMonitor.NULL);
        if (range.getMax() > 180.0) {
            return DISCONT_AT_360;
        }
        return DISCONT_AT_180;
    }

    public int getDiscontinuity() {
        return this.discontinuity;
    }

    public void setDiscontinuity(int discontinuity) {
        if (discontinuity != DISCONT_NONE && discontinuity != DISCONT_AT_180 && discontinuity != DISCONT_AT_360) {
            throw new IllegalArgumentException("unsupported discontinuity mode");
        }
        this.discontinuity = discontinuity;
    }

    @Override
    public boolean isFloatingPointType() {
        return true;
    }

    @Override
    public int getGeophysicalDataType() {
        return 30;
    }

    @Override
    public ProductData getSceneRasterData() {
        int width = this.getSceneRasterWidth();
        int height = this.getSceneRasterHeight();
        ProductData data = this.createCompatibleRasterData(width, height);
        float[] elems = (float[])data.getElems();
        this.getPixels(0, 0, width, height, elems, ProgressMonitor.NULL);
        return data;
    }

    @Override
    public int getSceneRasterWidth() {
        if (this.getProduct() != null) {
            return this.getProduct().getSceneRasterWidth();
        }
        return Math.round((float)(this.getRasterWidth() - 1) * this.getSubSamplingX() + 1.0f);
    }

    @Override
    public int getSceneRasterHeight() {
        if (this.getProduct() != null) {
            return this.getProduct().getSceneRasterHeight();
        }
        return Math.round((float)(this.getRasterHeight() - 1) * this.getSubSamplingY() + 1.0f);
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public float getSubSamplingX() {
        return this.subSamplingX;
    }

    public float getSubSamplingY() {
        return this.subSamplingY;
    }

    public float[] getTiePoints() {
        return (float[])this.getRasterData().getElems();
    }

    @Override
    public int getPixelInt(int x, int y) {
        return Math.round(this.getPixelFloat(x, y));
    }

    @Override
    public void dispose() {
        if (this.cosGrid != null) {
            this.cosGrid.dispose();
            this.cosGrid = null;
        }
        if (this.sinGrid != null) {
            this.sinGrid.dispose();
            this.sinGrid = null;
        }
        super.dispose();
    }

    @Override
    public float getPixelFloat(int x, int y) {
        return this.getPixelFloat((float)x + 0.5f, (float)y + 0.5f);
    }

    public float getPixelFloat(float x, float y) {
        if (this.discontinuity != DISCONT_NONE) {
            if (this.isDiscontNotInit()) {
                this.initDiscont();
            }
            float sinAngle = this.sinGrid.getPixelFloat(x, y);
            float cosAngle = this.cosGrid.getPixelFloat(x, y);
            float v = (float)(57.29577951308232 * Math.atan2(sinAngle, cosAngle));
            if (this.discontinuity == DISCONT_AT_360 && (double)v < 0.0) {
                return 360.0f + v;
            }
            return v;
        }
        float fi = (x - this.offsetX) / this.subSamplingX;
        float fj = (y - this.offsetY) / this.subSamplingY;
        int i = MathUtils.floorAndCrop(fi, 0, this.getRasterWidth() - 2);
        int j = MathUtils.floorAndCrop(fj, 0, this.getRasterHeight() - 2);
        return this.interpolate(fi - (float)i, fj - (float)j, i, j);
    }

    @Override
    public double getPixelDouble(int x, int y) {
        return this.getPixelFloat(x, y);
    }

    @Override
    public void setPixelInt(int x, int y, int pixelValue) {
        TiePointGrid.raisePixelsAreReadOnlyError();
    }

    @Override
    public void setPixelFloat(int x, int y, float pixelValue) {
        TiePointGrid.raisePixelsAreReadOnlyError();
    }

    @Override
    public void setPixelDouble(int x, int y, double pixelValue) {
        TiePointGrid.raisePixelsAreReadOnlyError();
    }

    @Override
    public int[] getPixels(int x, int y, int w, int h, int[] pixels, ProgressMonitor pm) {
        pixels = TiePointGrid.ensureMinLengthArray(pixels, w * h);
        float[] fpixels = this.getPixels(x, y, w, h, (float[])null, pm);
        int i = 0;
        while (i < fpixels.length) {
            pixels[i] = Math.round(fpixels[i]);
            ++i;
        }
        return pixels;
    }

    @Override
    public float[] getPixels(int x, int y, int w, int h, float[] pixels, ProgressMonitor pm) {
        pixels = TiePointGrid.ensureMinLengthArray(pixels, w * h);
        if (this.discontinuity != DISCONT_NONE) {
            if (this.isDiscontNotInit()) {
                this.initDiscont();
            }
            int i = 0;
            int yCoordinate = y;
            while (yCoordinate < y + h) {
                int xCoordinate = x;
                while (xCoordinate < x + w) {
                    pixels[i] = this.getPixelFloat(xCoordinate, yCoordinate);
                    ++i;
                    ++xCoordinate;
                }
                ++yCoordinate;
            }
        } else {
            float x0 = 0.5f - this.offsetX;
            float y0 = 0.5f - this.offsetY;
            int x1 = x;
            int y1 = y;
            int x2 = x + w - 1;
            int y2 = y + h - 1;
            int ni = this.getRasterWidth();
            int nj = this.getRasterHeight();
            int pos = 0;
            y = y1;
            while (y <= y2) {
                float fj = ((float)y + y0) / this.subSamplingY;
                int j = MathUtils.floorAndCrop(fj, 0, nj - 2);
                float wj = fj - (float)j;
                x = x1;
                while (x <= x2) {
                    float fi = ((float)x + x0) / this.subSamplingX;
                    int i = MathUtils.floorAndCrop(fi, 0, ni - 2);
                    float wi = fi - (float)i;
                    pixels[pos++] = this.interpolate(wi, wj, i, j);
                    ++x;
                }
                ++y;
            }
        }
        return pixels;
    }

    @Override
    public double[] getPixels(int x, int y, int w, int h, double[] pixels, ProgressMonitor pm) {
        pixels = TiePointGrid.ensureMinLengthArray(pixels, w * h);
        float[] fpixels = this.getPixels(x, y, w, h, (float[])null, pm);
        int i = 0;
        while (i < fpixels.length) {
            pixels[i] = fpixels[i];
            ++i;
        }
        return pixels;
    }

    @Override
    public void setPixels(int x, int y, int w, int h, int[] pixels) {
        TiePointGrid.raisePixelsAreReadOnlyError();
    }

    @Override
    public void setPixels(int x, int y, int w, int h, float[] pixels) {
        TiePointGrid.raisePixelsAreReadOnlyError();
    }

    @Override
    public void setPixels(int x, int y, int w, int h, double[] pixels) {
        TiePointGrid.raisePixelsAreReadOnlyError();
    }

    @Override
    public int[] readPixels(int x, int y, int w, int h, int[] pixels, ProgressMonitor pm) throws IOException {
        return this.getPixels(x, y, w, h, pixels, pm);
    }

    @Override
    public float[] readPixels(int x, int y, int w, int h, float[] pixels, ProgressMonitor pm) throws IOException {
        return this.getPixels(x, y, w, h, pixels, pm);
    }

    @Override
    public double[] readPixels(int x, int y, int w, int h, double[] pixels, ProgressMonitor pm) throws IOException {
        return this.getPixels(x, y, w, h, pixels, pm);
    }

    @Override
    public void writePixels(int x, int y, int w, int h, int[] pixels, ProgressMonitor pm) throws IOException {
        TiePointGrid.raisePixelsAreReadOnlyError();
    }

    @Override
    public void writePixels(int x, int y, int w, int h, float[] pixels, ProgressMonitor pm) throws IOException {
        TiePointGrid.raisePixelsAreReadOnlyError();
    }

    @Override
    public void writePixels(int x, int y, int w, int h, double[] pixels, ProgressMonitor pm) throws IOException {
        TiePointGrid.raisePixelsAreReadOnlyError();
    }

    @Override
    public void readRasterData(int offsetX, int offsetY, int width, int height, ProductData rasterData, ProgressMonitor pm) throws IOException {
        ProductData src = this.getRasterData();
        int iDest = 0;
        pm.beginTask("Reading raster data...", height);
        try {
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    int iSrc = (offsetY + y) * width + (offsetX + x);
                    rasterData.setElemDoubleAt(iDest, src.getElemDoubleAt(iSrc));
                    ++iDest;
                    ++x;
                }
                pm.worked(1);
                ++y;
            }
        }
        finally {
            pm.done();
        }
    }

    @Override
    public void readRasterDataFully(ProgressMonitor pm) throws IOException {
    }

    @Override
    public void writeRasterData(int offsetX, int offsetY, int width, int height, ProductData rasterData, ProgressMonitor pm) throws IOException {
        TiePointGrid.raisePixelsAreReadOnlyError();
    }

    @Override
    public void writeRasterDataFully(ProgressMonitor pm) throws IOException {
        TiePointGrid.raisePixelsAreReadOnlyError();
    }

    @Override
    protected RenderedImage createSourceImage() {
        MultiLevelModel model = ImageManager.getMultiLevelModel(this);
        return new DefaultMultiLevelImage(new AbstractMultiLevelSource(model){

            @Override
            public RenderedImage createImage(int level) {
                return new TiePointGridOpImage(TiePointGrid.this, ResolutionLevel.create(this.getModel(), level));
            }
        });
    }

    @Override
    public void acceptVisitor(ProductVisitor visitor) {
        Guardian.assertNotNull("visitor", visitor);
        visitor.visit(this);
    }

    public TiePointGrid cloneTiePointGrid() {
        float[] srcTiePoints = this.getTiePoints();
        float[] destTiePoints = new float[srcTiePoints.length];
        System.arraycopy(srcTiePoints, 0, destTiePoints, 0, srcTiePoints.length);
        TiePointGrid clone = new TiePointGrid(this.getName(), this.getRasterWidth(), this.getRasterHeight(), this.getOffsetX(), this.getOffsetY(), this.getSubSamplingX(), this.getSubSamplingY(), destTiePoints, this.getDiscontinuity());
        clone.setUnit(this.getUnit());
        clone.setDescription(this.getDescription());
        return clone;
    }

    public static TiePointGrid createZenithFromElevationAngleTiePointGrid(TiePointGrid elevationAngleGrid) {
        float[] elevationAngles = elevationAngleGrid.getTiePoints();
        float[] zenithAngles = new float[elevationAngles.length];
        int i = 0;
        while (i < zenithAngles.length) {
            zenithAngles[i] = 90.0f - elevationAngles[i];
            ++i;
        }
        return new TiePointGrid(elevationAngleGrid.getName(), elevationAngleGrid.getRasterWidth(), elevationAngleGrid.getRasterHeight(), elevationAngleGrid.getOffsetX(), elevationAngleGrid.getOffsetY(), elevationAngleGrid.getSubSamplingX(), elevationAngleGrid.getSubSamplingY(), zenithAngles);
    }

    private static void raisePixelsAreReadOnlyError() {
        throw new IllegalStateException("pixels are read-only in tie-point grids");
    }

    private float interpolate(float wi, float wj, int i0, int j0) {
        float[] tiePoints = this.getTiePoints();
        int w = this.getRasterWidth();
        int i1 = i0 + 1;
        int j1 = j0 + 1;
        return MathUtils.interpolate2D(wi, wj, tiePoints[i0 + j0 * w], tiePoints[i1 + j0 * w], tiePoints[i0 + j1 * w], tiePoints[i1 + j1 * w]);
    }

    private boolean isDiscontNotInit() {
        return this.sinGrid == null || this.cosGrid == null;
    }

    private void initDiscont() {
        TiePointGrid base = this;
        float[] tiePoints = base.getTiePoints();
        float[] sinTiePoints = new float[tiePoints.length];
        float[] cosTiePoints = new float[tiePoints.length];
        int i = 0;
        while (i < tiePoints.length) {
            float tiePoint = tiePoints[i];
            sinTiePoints[i] = (float)Math.sin(Math.PI / 180 * (double)tiePoint);
            cosTiePoints[i] = (float)Math.cos(Math.PI / 180 * (double)tiePoint);
            ++i;
        }
        this.sinGrid = new TiePointGrid(base.getName(), base.getRasterWidth(), base.getRasterHeight(), base.getOffsetX(), base.getOffsetY(), base.getSubSamplingX(), base.getSubSamplingY(), sinTiePoints);
        this.cosGrid = new TiePointGrid(base.getName(), base.getRasterWidth(), base.getRasterHeight(), base.getOffsetX(), base.getOffsetY(), base.getSubSamplingX(), base.getSubSamplingY(), cosTiePoints);
    }

    protected static int[] ensureMinLengthArray(int[] array, int length) {
        if (array == null) {
            return new int[length];
        }
        if (array.length < length) {
            throw new IllegalArgumentException("The length of the given array is less than " + length);
        }
        return array;
    }

    protected static float[] ensureMinLengthArray(float[] array, int length) {
        if (array == null) {
            return new float[length];
        }
        if (array.length < length) {
            throw new IllegalArgumentException("The length of the given array is less than " + length);
        }
        return array;
    }

    protected static double[] ensureMinLengthArray(double[] array, int length) {
        if (array == null) {
            return new double[length];
        }
        if (array.length < length) {
            throw new IllegalArgumentException("The length of the given array is less than " + length);
        }
        return array;
    }

    public static TiePointGrid createSubset(TiePointGrid sourceTiePointGrid, ProductSubsetDef subsetDef) {
        int newTPGHeight;
        int srcTPGRasterWidth = sourceTiePointGrid.getRasterWidth();
        int srcTPGRasterHeight = sourceTiePointGrid.getRasterHeight();
        float srcTPGSubSamplingX = sourceTiePointGrid.getSubSamplingX();
        float srcTPGSubSamplingY = sourceTiePointGrid.getSubSamplingY();
        int subsetOffsetX = 0;
        int subsetOffsetY = 0;
        int subsetStepX = 1;
        int subsetStepY = 1;
        int srcSceneRasterWidth = sourceTiePointGrid.getSceneRasterWidth();
        int srcSceneRasterHeight = sourceTiePointGrid.getSceneRasterHeight();
        int subsetWidth = srcSceneRasterWidth;
        int subsetHeight = srcSceneRasterHeight;
        if (subsetDef != null) {
            subsetStepX = subsetDef.getSubSamplingX();
            subsetStepY = subsetDef.getSubSamplingY();
            if (subsetDef.getRegion() != null) {
                subsetOffsetX = subsetDef.getRegion().x;
                subsetOffsetY = subsetDef.getRegion().y;
                subsetWidth = subsetDef.getRegion().width;
                subsetHeight = subsetDef.getRegion().height;
            }
        }
        float newTPGSubSamplingX = srcTPGSubSamplingX / (float)subsetStepX;
        float newTPGSubSamplingY = srcTPGSubSamplingY / (float)subsetStepY;
        float newTPGOffsetX = (sourceTiePointGrid.getOffsetX() - 0.5f - (float)subsetOffsetX) / (float)subsetStepX + 0.5f;
        float newTPGOffsetY = (sourceTiePointGrid.getOffsetY() - 0.5f - (float)subsetOffsetY) / (float)subsetStepY + 0.5f;
        float newOffsetX = newTPGOffsetX % newTPGSubSamplingX;
        float newOffsetY = newTPGOffsetY % newTPGSubSamplingY;
        float diffX = newOffsetX - newTPGOffsetX;
        float diffY = newOffsetY - newTPGOffsetY;
        int dataOffsetX = diffX < 0.0f ? 0 : Math.round(diffX / newTPGSubSamplingX);
        int dataOffsetY = diffY < 0.0f ? 0 : Math.round(diffY / newTPGSubSamplingY);
        int newTPGWidth = (int)Math.ceil((float)subsetWidth / srcTPGSubSamplingX) + 2;
        if (dataOffsetX + newTPGWidth > srcTPGRasterWidth) {
            newTPGWidth = srcTPGRasterWidth - dataOffsetX;
        }
        if (dataOffsetY + (newTPGHeight = (int)Math.ceil((float)subsetHeight / srcTPGSubSamplingY) + 2) > srcTPGRasterHeight) {
            newTPGHeight = srcTPGRasterHeight - dataOffsetY;
        }
        float[] oldTiePoints = sourceTiePointGrid.getTiePoints();
        float[] tiePoints = new float[newTPGWidth * newTPGHeight];
        int y = 0;
        while (y < newTPGHeight) {
            int srcPos = srcTPGRasterWidth * (dataOffsetY + y) + dataOffsetX;
            System.arraycopy(oldTiePoints, srcPos, tiePoints, y * newTPGWidth, newTPGWidth);
            ++y;
        }
        TiePointGrid tiePointGrid = new TiePointGrid(sourceTiePointGrid.getName(), newTPGWidth, newTPGHeight, newOffsetX, newOffsetY, newTPGSubSamplingX, newTPGSubSamplingY, tiePoints, sourceTiePointGrid.getDiscontinuity());
        tiePointGrid.setUnit(sourceTiePointGrid.getUnit());
        tiePointGrid.setDescription(sourceTiePointGrid.getDescription());
        return tiePointGrid;
    }
}

