/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import com.vividsolutions.jts.geom.Point;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.datamodel.PlacemarkDescriptorRegistry;
import org.esa.beam.framework.datamodel.PointPlacemarkDescriptor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;

public class TrackPointDescriptor
extends PointPlacemarkDescriptor {
    public static TrackPointDescriptor getInstance() {
        return (TrackPointDescriptor)PlacemarkDescriptorRegistry.getInstance().getPlacemarkDescriptor(TrackPointDescriptor.class.getName());
    }

    public TrackPointDescriptor() {
        super("org.esa.beam.TrackPoint");
    }

    @Override
    public DecodeQualification getCompatibilityFor(SimpleFeatureType featureType) {
        GeometryDescriptor geometryDescriptor = featureType.getGeometryDescriptor();
        if (geometryDescriptor != null && geometryDescriptor.getType().getBinding().equals(Point.class)) {
            Object trackPoints = featureType.getUserData().get("trackPoints");
            if (trackPoints != null && Boolean.parseBoolean(trackPoints.toString())) {
                return DecodeQualification.INTENDED;
            }
            return DecodeQualification.SUITABLE;
        }
        return DecodeQualification.UNABLE;
    }

    @Override
    public void setUserDataOf(SimpleFeatureType compatibleFeatureType) {
        super.setUserDataOf(compatibleFeatureType);
        compatibleFeatureType.getUserData().put("trackPoints", "true");
    }

    @Override
    public String getRoleName() {
        return "track_point";
    }

    @Override
    public String getRoleLabel() {
        return "track point";
    }
}

