/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.barithm;

import com.bc.jexp.EvalEnv;
import com.bc.jexp.EvalException;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.dataop.barithm.RasterDataEvalEnv;
import org.esa.beam.framework.dataop.barithm.RasterDataSymbol;

public final class SingleFlagSymbol
extends RasterDataSymbol {
    private final int flagMask;

    public SingleFlagSymbol(String symbolName, RasterDataNode raster, int flagMask) {
        super(symbolName, raster, RAW);
        this.flagMask = flagMask;
    }

    @Override
    public final int getRetType() {
        return 1;
    }

    public final int getFlagMask() {
        return this.flagMask;
    }

    @Override
    public final boolean evalB(EvalEnv env) throws EvalException {
        int elemIndex = ((RasterDataEvalEnv)env).getElemIndex();
        return (this.data.getElemIntAt(elemIndex) & this.flagMask) == this.flagMask;
    }

    @Override
    public final int evalI(EvalEnv env) throws EvalException {
        int elemIndex = ((RasterDataEvalEnv)env).getElemIndex();
        return (this.data.getElemIntAt(elemIndex) & this.flagMask) == this.flagMask ? 1 : 0;
    }

    @Override
    public final double evalD(EvalEnv env) throws EvalException {
        int elemIndex = ((RasterDataEvalEnv)env).getElemIndex();
        return (this.data.getElemIntAt(elemIndex) & this.flagMask) == this.flagMask ? 1.0 : 0.0;
    }
}

