/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.maptransf;

import java.awt.geom.Point2D;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.dataop.maptransf.CartographicMapTransform;
import org.esa.beam.framework.dataop.maptransf.DefaultMapTransformUI;
import org.esa.beam.framework.dataop.maptransf.Ellipsoid;
import org.esa.beam.framework.dataop.maptransf.MapProjection;
import org.esa.beam.framework.dataop.maptransf.MapProjectionRegistry;
import org.esa.beam.framework.dataop.maptransf.MapTransform;
import org.esa.beam.framework.dataop.maptransf.MapTransformDescriptor;
import org.esa.beam.framework.dataop.maptransf.MapTransformUI;
import org.esa.beam.framework.param.Parameter;

@Deprecated
public class AlbersEqualAreaConicDescriptor
implements MapTransformDescriptor {
    public static final String TYPE_ID = "Albers_Equal_Area_Conic";
    public static final String NAME = "Albers Equal Area Conic";
    public static final String MAP_UNIT = "meter";
    private static final int SEMI_MAJOR_INDEX = 0;
    private static final int SEMI_MINOR_INDEX = 1;
    private static final int LATITUDE_OF_ORIGIN_INDEX = 2;
    private static final int CENTRAL_MERIDIAN_INDEX = 3;
    private static final int LATITUDE_OF_INTERSECTION_1_INDEX = 4;
    private static final int LATITUDE_OF_INTERSECTION_2_INDEX = 5;
    private static final int SCALE_FACTOR_INDEX = 6;
    private static final int FALSE_EASTING_INDEX = 7;
    private static final int FALSE_NORTHING_INDEX = 8;
    public static final String[] PARAMETER_NAMES = new String[]{"semi_major", "semi_minor", "latitude_of_origin", "central_meridian", "latitude_of_intersection_1", "latitude_of_intersection_2", "scale_factor", "false_easting", "false_northing"};
    public static final double[] PARAMETER_DEFAULT_VALUES = new double[]{Ellipsoid.WGS_84.getSemiMajor(), Ellipsoid.WGS_84.getSemiMinor(), 50.0, 99.0, 56.0, 73.0, 1.0, 1000000.0, 0.0};
    public static final String[] PARAMETER_LABELS = new String[]{"Semi major", "Semi minor", "Latitude of origin", "Central meridian", "Latitude of intersection 1", "Latitude of intersection 2", "Scale factor", "False easting", "False northing"};
    public static final String[] PARAMETER_UNITS = new String[]{"meter", "meter", "degree", "degree", "degree", "degree", "", "meter", "meter"};

    @Override
    public void registerProjections() {
        MapProjectionRegistry.registerProjection(new MapProjection(this.getName(), this.createTransform(null), this.getMapUnit(), false));
    }

    @Override
    public String getTypeID() {
        return TYPE_ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getMapUnit() {
        return MAP_UNIT;
    }

    @Override
    public Parameter[] getParameters() {
        Parameter[] parameters = new Parameter[PARAMETER_NAMES.length];
        int i = 0;
        while (i < parameters.length) {
            parameters[i] = new Parameter(PARAMETER_NAMES[i], PARAMETER_DEFAULT_VALUES[i]);
            parameters[i].getProperties().setLabel(PARAMETER_LABELS[i]);
            parameters[i].getProperties().setPhysicalUnit(PARAMETER_UNITS[i]);
            ++i;
        }
        return parameters;
    }

    @Override
    public double[] getParameterDefaultValues() {
        double[] values = new double[PARAMETER_DEFAULT_VALUES.length];
        System.arraycopy(PARAMETER_DEFAULT_VALUES, 0, values, 0, values.length);
        return values;
    }

    @Override
    public boolean hasTransformUI() {
        return true;
    }

    @Override
    public MapTransformUI getTransformUI(MapTransform transform) {
        return new DefaultMapTransformUI(transform);
    }

    @Override
    public MapTransform createTransform(double[] parameterValues) {
        if (parameterValues == null) {
            parameterValues = this.getParameterDefaultValues();
        }
        return new AEAC(parameterValues);
    }

    @Deprecated
    public class AEAC
    extends CartographicMapTransform {
        private static final double eps10 = 1.0E-10;
        private double[] _parameterValues;
        private double _n;
        private double _rho0;
        private double e;
        private double _c;
        private double es;
        private double _a;
        private double _lam0;

        public AEAC(double[] parameterValues) {
            boolean isSecant;
            super(0.0, parameterValues[7], parameterValues[8], 1.0);
            this._n = 0.0;
            this._rho0 = 0.0;
            this._parameterValues = new double[parameterValues.length];
            System.arraycopy(parameterValues, 0, this._parameterValues, 0, parameterValues.length);
            double phi0 = this._parameterValues[2];
            double phi1 = this._parameterValues[4];
            double phi2 = this._parameterValues[5];
            double lam0 = this._parameterValues[3];
            double _phi0 = Math.toRadians(phi0);
            double _phi1 = Math.toRadians(phi1);
            double _phi2 = Math.toRadians(phi2);
            this._lam0 = Math.toRadians(lam0);
            if (Math.abs(_phi1 + _phi2) < 1.0E-10) {
                throw new IllegalArgumentException("Invalid parameter set.");
            }
            this._a = this._parameterValues[0];
            double b = this._parameterValues[1];
            this.es = 1.0 - b * b / (this._a * this._a);
            this.e = Math.sqrt(this.es);
            double sinPhi0 = Math.sin(_phi0);
            double sinPhi1 = Math.sin(_phi1);
            double sinPhi2 = Math.sin(_phi2);
            double _q0 = (1.0 - this.es) * (sinPhi0 / (1.0 - this.es * sinPhi0 * sinPhi0) - 1.0 / (2.0 * this.e) * Math.log((1.0 - this.e * sinPhi0) / (1.0 + this.e * sinPhi0)));
            double _q1 = (1.0 - this.es) * (sinPhi1 / (1.0 - this.es * sinPhi1 * sinPhi1) - 1.0 / (2.0 * this.e) * Math.log((1.0 - this.e * sinPhi1) / (1.0 + this.e * sinPhi1)));
            double _q2 = (1.0 - this.es) * (sinPhi2 / (1.0 - this.es * sinPhi2 * sinPhi2) - 1.0 / (2.0 * this.e) * Math.log((1.0 - this.e * sinPhi2) / (1.0 + this.e * sinPhi2)));
            double m1 = Math.cos(_phi1) / Math.sqrt(1.0 - this.es * sinPhi1 * sinPhi1);
            double m2 = Math.cos(_phi2) / Math.sqrt(1.0 - this.es * sinPhi2 * sinPhi2);
            boolean bl = isSecant = Math.abs(_phi1 - _phi2) >= 1.0E-10;
            if (isSecant) {
                this._n = (Math.pow(m1, 2.0) - Math.pow(m2, 2.0)) / (_q2 - _q1);
            }
            this._c = Math.pow(m1, 2.0) + this._n * _q1;
            if (Math.abs(Math.abs(_phi0) - 1.5707963267948966) >= 1.0E-10) {
                this._rho0 = this._a * Math.sqrt(this._c - this._n * _q0) / this._n;
            }
        }

        @Override
        public MapTransformDescriptor getDescriptor() {
            return AlbersEqualAreaConicDescriptor.this;
        }

        @Override
        public MapTransform createDeepClone() {
            return new AEAC(this._parameterValues);
        }

        @Override
        public double[] getParameterValues() {
            double[] values = new double[this._parameterValues.length];
            System.arraycopy(this._parameterValues, 0, values, 0, values.length);
            return values;
        }

        @Override
        protected Point2D forward_impl(float phi, float lam, Point2D mapPoint) {
            double _phi = Math.toRadians(phi);
            double _lam = Math.toRadians(lam);
            double rho = 0.0;
            if (Math.abs(Math.abs(_phi) - 1.5707963267948966) < 1.0E-10) {
                if (_phi * this._n < 0.0) {
                    throw new IllegalArgumentException("Invalid parameter range");
                }
            } else {
                double sinPhi = Math.sin(_phi);
                double _q = (1.0 - this.es) * (sinPhi / (1.0 - this.es * sinPhi * sinPhi) - 1.0 / (2.0 * this.e) * Math.log((1.0 - this.e * sinPhi) / (1.0 + this.e * sinPhi)));
                rho = this._a * Math.sqrt(this._c - this._n * _q) / this._n;
            }
            double theta = this._n * (_lam - this._lam0);
            double x = (float)(rho * Math.sin(theta));
            double y = (double)((float)this._rho0) - rho * Math.cos(theta);
            mapPoint.setLocation(x, y);
            return mapPoint;
        }

        @Override
        protected GeoPos inverse_impl(float x, float y, GeoPos geoPoint) {
            double localX = x;
            double localY = y;
            double _phi = 0.0;
            double _lam = 0.0;
            double rho = Math.sqrt(Math.pow(localX, 2.0) + Math.pow(this._rho0 - localY, 2.0));
            if (rho != 0.0) {
                if (this._n < 0.0) {
                    rho = -rho;
                    localX = -localX;
                    localY = -localY;
                }
                double theta = Math.atan(localX / (this._rho0 - localY));
                _lam = this._lam0 + theta / this._n;
                double _q = (this._c - Math.pow(rho, 2.0) * Math.pow(this._n, 2.0) / Math.pow(this._a, 2.0)) / this._n;
                double e2 = this.e * this.e;
                double e4 = e2 * e2;
                double e6 = e2 * e2 * e2;
                double beta = Math.asin(_q / (1.0 - (1.0 - e2) / (2.0 * this.e) * Math.log((1.0 - this.e) / (1.0 + this.e))));
                _phi = beta + (e2 / 3.0 + 31.0 * (e4 / 180.0) + 517.0 * e6 / 5040.0) * Math.sin(2.0 * beta) + (23.0 * e4 / 360.0 + 251.0 * e6 / 3780.0) * Math.sin(4.0 * beta) + 761.0 * e6 / 45360.0 * Math.sin(6.0 * beta);
            } else {
                _lam = 0.0;
            }
            geoPoint.lat = (float)Math.toDegrees(_phi);
            geoPoint.lon = (float)Math.toDegrees(_lam);
            return geoPoint;
        }

        public double getSemiMinor() {
            return this._parameterValues[1];
        }

        public double getLatitudeOfOrigin() {
            return this._parameterValues[2];
        }

        public double getStandardParallel1() {
            return this._parameterValues[4];
        }

        public double getStandardParallel2() {
            return this._parameterValues[5];
        }
    }
}

