/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.maptransf;

import org.esa.beam.framework.dataop.maptransf.Ellipsoid;
import org.esa.beam.framework.dataop.maptransf.MapTransform;
import org.esa.beam.framework.dataop.maptransf.MapTransformDescriptor;
import org.esa.beam.framework.dataop.maptransf.MapTransformUI;
import org.esa.beam.framework.param.Parameter;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.ObjectUtils;

@Deprecated
public class MapProjection
implements Cloneable {
    private String _name;
    private MapTransform _mapTransform;
    private String _mapUnit;
    private boolean _preDefined;

    public MapProjection(String name, MapTransform mapTransform) {
        this(name, mapTransform, mapTransform.getDescriptor().getMapUnit());
    }

    public MapProjection(String name, MapTransform mapTransform, boolean preDefined) {
        this(name, mapTransform, mapTransform.getDescriptor().getMapUnit(), preDefined);
    }

    public MapProjection(String name, MapTransform mapTransform, String mapUnit) {
        this(name, mapTransform, mapUnit, false);
    }

    public MapProjection(String name, MapTransform mapTransform, String mapUnit, boolean preDefined) {
        Guardian.assertNotNullOrEmpty("name", name);
        Guardian.assertNotNull("mapTransform", mapTransform);
        this._name = name;
        this._mapTransform = mapTransform;
        this._mapUnit = mapUnit;
        this._preDefined = preDefined;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public MapTransform getMapTransform() {
        return this._mapTransform;
    }

    public void setMapTransform(MapTransform transform) {
        this._mapTransform = transform;
    }

    public String getMapUnit() {
        return this._mapUnit;
    }

    public void setMapUnit(String mapUnit) {
        this._mapUnit = mapUnit;
    }

    public boolean isPreDefined() {
        return this._preDefined;
    }

    public void setPreDefined(boolean preDefined) {
        this._preDefined = preDefined;
    }

    public boolean hasMapTransformUI() {
        return this.getMapTransform().getDescriptor().hasTransformUI();
    }

    public MapTransformUI getMapTransformUI() {
        MapTransform mapTransform = this.getMapTransform();
        MapTransformDescriptor descriptor = mapTransform.getDescriptor();
        return descriptor.getTransformUI(mapTransform);
    }

    public Object clone() {
        try {
            MapProjection mapProjection = (MapProjection)super.clone();
            mapProjection.setMapTransform(this._mapTransform.createDeepClone());
            return mapProjection;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void alterMapTransform(Ellipsoid ellipsoid) {
        MapTransform oldTransform = this.getMapTransform();
        Parameter[] parameters = oldTransform.getDescriptor().getParameters();
        double[] parameterValues = oldTransform.getParameterValues();
        boolean altered = false;
        int i = 0;
        while (i < parameters.length) {
            if ("semi_minor".equals(parameters[i].getName())) {
                parameterValues[i] = ellipsoid.getSemiMinor();
                altered = true;
            } else if ("semi_major".equals(parameters[i].getName())) {
                parameterValues[i] = ellipsoid.getSemiMajor();
                altered = true;
            }
            ++i;
        }
        if (altered) {
            MapTransform newTransform = oldTransform.getDescriptor().createTransform(parameterValues);
            this.setMapTransform(newTransform);
        }
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof MapProjection) {
            MapProjection other = (MapProjection)obj;
            return ObjectUtils.equalObjects(other.getName(), this.getName()) && ObjectUtils.equalObjects(other.getMapUnit(), this.getMapUnit()) && ObjectUtils.equalObjects(other.getMapTransform().getDescriptor(), this.getMapTransform().getDescriptor()) && ObjectUtils.equalObjects(other.getMapTransform().getParameterValues(), this.getMapTransform().getParameterValues());
        }
        return false;
    }
}

