/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.param.editors;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.esa.beam.framework.param.AbstractParamEditor;
import org.esa.beam.framework.param.Parameter;

public class RadioButtonEditor
extends AbstractParamEditor {
    private JRadioButton _radioButton;

    public RadioButtonEditor(Parameter parameter) {
        super(parameter, false);
    }

    public JRadioButton getRadioButton() {
        return this._radioButton;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.getRadioButton();
    }

    @Override
    protected void initUI() {
        this._radioButton = new JRadioButton();
        this.nameEditorComponent(this._radioButton);
        if (this.getParameter().getProperties().getLabel() != null) {
            this._radioButton.setText(this.getParameter().getProperties().getLabel());
        }
        if (this.getParameter().getProperties().getDescription() != null) {
            this._radioButton.setToolTipText(this.getParameter().getProperties().getDescription());
        }
        this._radioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                RadioButtonEditor.this.updateParameter();
            }
        });
    }

    @Override
    public void updateUI() {
        super.updateUI();
        boolean newValue = this.getParameter().getValue() instanceof Boolean ? ((Boolean)this.getParameter().getValue()).booleanValue() : Boolean.valueOf(this.getParameter().getValueAsText()).booleanValue();
        if (this.getRadioButton().isSelected() != newValue) {
            this.getRadioButton().setSelected(newValue);
        }
        if (this.getRadioButton().isEnabled() != this.isEnabled()) {
            this.getRadioButton().setEnabled(this.isEnabled());
        }
    }

    private void updateParameter() {
        boolean newValue = this.getRadioButton().isSelected();
        this.getParameter().setValue(newValue, null);
    }
}

