/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.param.validators;

import org.esa.beam.framework.param.AbstractParamValidator;
import org.esa.beam.framework.param.ParamFormatException;
import org.esa.beam.framework.param.ParamParseException;
import org.esa.beam.framework.param.ParamProperties;
import org.esa.beam.framework.param.ParamValidateException;
import org.esa.beam.framework.param.Parameter;
import org.esa.beam.framework.param.validators.StringValidator;
import org.esa.beam.util.Debug;
import org.esa.beam.util.StringUtils;

public class StringArrayValidator
extends AbstractParamValidator {
    @Override
    public Object parse(Parameter parameter, String text) throws ParamParseException {
        Debug.assertTrue(text != null);
        if (StringArrayValidator.isAllowedNullText(parameter, text)) {
            return null;
        }
        ParamProperties props = parameter.getProperties();
        char[] separators = new char[]{props.getValueSetDelim()};
        return StringUtils.split(text, separators, true);
    }

    @Override
    public String format(Parameter parameter, Object value) throws ParamFormatException {
        if (StringArrayValidator.isAllowedNullValue(parameter, value)) {
            return "";
        }
        String[] sa = StringArrayValidator.castToStringArray(value);
        if (sa == null) {
            throw new ParamFormatException(parameter, "Value of type 'String[]' expected.");
        }
        ParamProperties props = parameter.getProperties();
        String separator = new String(new char[]{props.getValueSetDelim()});
        return StringUtils.join((Object[])value, separator);
    }

    @Override
    public void validate(Parameter parameter, Object value) throws ParamValidateException {
        this.validateThatNullValueIsAllowed(parameter, value);
        if (value == null) {
            return;
        }
        this.validateThatValueIsAStringArray(parameter, value);
        this.validateThatValueIsAnAllowedEmptyValue(parameter, value);
        this.validateThatValueIsBoundedInValueSet(parameter, value);
    }

    private void validateThatValueIsBoundedInValueSet(Parameter parameter, Object value) throws ParamValidateException {
        if (!parameter.getProperties().isValueSetBound()) {
            return;
        }
        String[] valueSet = parameter.getProperties().getValueSet();
        if (valueSet == null) {
            return;
        }
        String[] sa = StringArrayValidator.castToStringArray(value);
        int i = 0;
        while (i < sa.length) {
            boolean found = false;
            int j = 0;
            while (j < valueSet.length) {
                if (StringValidator.equalValues(parameter.getProperties().isCaseSensitive(), sa[i], valueSet[j])) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                throw new ParamValidateException(parameter, "Value must be contained in predefined value set.");
            }
            ++i;
        }
    }

    private void validateThatValueIsAStringArray(Parameter parameter, Object value) throws ParamValidateException {
        String[] sa = StringArrayValidator.castToStringArray(value);
        if (sa == null) {
            throw new ParamValidateException(parameter, "Value must be an array of text strings.");
        }
    }

    protected void validateThatValueIsAnAllowedEmptyValue(Parameter parameter, Object value) throws ParamValidateException {
        String[] maybeEmpty = StringArrayValidator.castToStringArray(value);
        boolean emptyValuesNotAllowed = parameter.getProperties().isEmptyValuesNotAllowed();
        if (emptyValuesNotAllowed && maybeEmpty != null && maybeEmpty.length == 0) {
            throw new ParamValidateException(parameter, "Value must not be empty.");
        }
    }

    @Override
    public boolean equalValues(Parameter parameter, Object value1, Object value2) {
        String[] sa2;
        String[] sa1 = StringArrayValidator.castToStringArray(value1);
        if (sa1 == (sa2 = StringArrayValidator.castToStringArray(value2))) {
            return true;
        }
        if (sa1 == null && sa2 != null) {
            return false;
        }
        if (sa1 != null && sa2 == null) {
            return false;
        }
        if (sa1.length != sa2.length) {
            return false;
        }
        int i = 0;
        while (i < sa1.length) {
            if (!StringValidator.equalValues(parameter.getProperties().isCaseSensitive(), sa1[i], sa2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int[] getValueSetIndices(Parameter parameter) {
        Debug.assertNotNull(parameter);
        String[] values = StringArrayValidator.castToStringArray(parameter.getValue());
        String[] valueSet = StringArrayValidator.castToStringArray(parameter.getProperties().getValueSet());
        if (values == null || valueSet == null) {
            return new int[0];
        }
        boolean caseSensitive = parameter.getProperties().isCaseSensitive();
        int numSelected = 0;
        int i = 0;
        while (i < values.length) {
            int index = StringArrayValidator.getValueSetIndex(valueSet, values[i], caseSensitive);
            if (index >= 0) {
                ++numSelected;
            }
            ++i;
        }
        int[] indexes = new int[numSelected];
        int i2 = 0;
        int j = 0;
        while (i2 < values.length) {
            int index = StringArrayValidator.getValueSetIndex(valueSet, values[i2], caseSensitive);
            if (index >= 0) {
                indexes[j++] = index;
            }
            ++i2;
        }
        return indexes;
    }

    protected static String[] castToStringArray(Object value) {
        return value instanceof String[] ? (String[])value : null;
    }

    protected static int getValueSetIndex(String[] valueSet, String value, boolean caseSensitive) {
        int i = 0;
        while (i < valueSet.length) {
            if (StringValidator.equalValues(caseSensitive, value, valueSet[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

