/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.param.validators;

import org.esa.beam.framework.param.AbstractParamValidator;
import org.esa.beam.framework.param.ParamFormatException;
import org.esa.beam.framework.param.ParamParseException;
import org.esa.beam.framework.param.ParamValidateException;
import org.esa.beam.framework.param.Parameter;
import org.esa.beam.util.Debug;
import org.esa.beam.util.StringUtils;

public class StringValidator
extends AbstractParamValidator {
    @Override
    public Object parse(Parameter parameter, String text) throws ParamParseException {
        Debug.assertTrue(text != null);
        if (StringValidator.isAllowedNullText(parameter, text)) {
            return null;
        }
        return text;
    }

    @Override
    public String format(Parameter parameter, Object value) throws ParamFormatException {
        if (StringValidator.isAllowedNullValue(parameter, value)) {
            return "";
        }
        String s = StringValidator.castToString(value);
        if (s == null) {
            throw new ParamFormatException(parameter, "Not a string value.");
        }
        return s;
    }

    @Override
    public void validate(Parameter parameter, Object value) throws ParamValidateException {
        this.validateThatNullValueIsAllowed(parameter, value);
        if (value == null) {
            return;
        }
        this.validateThatValueIsAString(parameter, value);
        this.validateThatValueIsAnIdentifier(parameter, value);
        this.validateThatValueIsAnAllowedEmptyValue(parameter, value);
        this.validateThatValueIsInValueSet(parameter, value);
    }

    protected void validateThatValueIsAString(Parameter parameter, Object value) throws ParamValidateException {
        String s = StringValidator.castToString(value);
        if (s == null) {
            throw new ParamValidateException(parameter, "Value must be a text string.");
        }
    }

    protected void validateThatValueIsAnIdentifier(Parameter parameter, Object value) throws ParamValidateException {
        String name = (String)value;
        boolean identifiersOnly = parameter.getProperties().isIdentifiersOnly();
        if (identifiersOnly && !StringUtils.isIdentifier(name)) {
            throw new ParamValidateException(parameter, "Value must be an identifier.\n\n A valid identifier starts with a letter or underscore and is\nfollowed by letters, digits or underscores.");
        }
    }

    protected void validateThatValueIsAnAllowedEmptyValue(Parameter parameter, Object value) throws ParamValidateException {
        String maybeEmpty = (String)value;
        boolean emptyValuesNotAllowed = parameter.getProperties().isEmptyValuesNotAllowed();
        if (emptyValuesNotAllowed && maybeEmpty != null && maybeEmpty.trim().length() == 0) {
            throw new ParamValidateException(parameter, "Value must not be empty.");
        }
    }

    @Override
    public boolean equalValues(Parameter parameter, Object value1, Object value2) {
        return StringValidator.equalValues(parameter.getProperties().isCaseSensitive(), value1, value2);
    }

    public static boolean equalValues(boolean caseSensitive, Object value1, Object value2) {
        String s2;
        String s1 = StringValidator.castToString(value1);
        if (s1 == (s2 = StringValidator.castToString(value2))) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        if (s1 != null && s2 == null) {
            return false;
        }
        return caseSensitive ? s1.equals(s2) : s1.equalsIgnoreCase(s2);
    }

    protected static String castToString(Object value) {
        return value instanceof String ? (String)value : null;
    }
}

