/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.jai;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.IOException;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.jai.RasterDataNodeOpImage;
import org.esa.beam.jai.ResolutionLevel;

public class TiePointGridOpImage
extends RasterDataNodeOpImage {
    public TiePointGridOpImage(TiePointGrid band, ResolutionLevel level) {
        super(band, level);
    }

    public TiePointGrid getTiePointGrid() {
        return (TiePointGrid)this.getRasterDataNode();
    }

    @Override
    protected void computeProductData(ProductData productData, Rectangle destRect) throws IOException {
        if (this.getLevel() == 0) {
            this.getTiePointGrid().readPixels(destRect.x, destRect.y, destRect.width, destRect.height, (float[])productData.getElems(), ProgressMonitor.NULL);
        } else {
            int sourceWidth = this.getSourceWidth(destRect.width);
            ProductData lineData = ProductData.createInstance(this.getTiePointGrid().getDataType(), sourceWidth);
            int[] sourceCoords = this.getSourceCoords(sourceWidth, destRect.width);
            int srcX = this.getSourceX(destRect.x);
            int y = 0;
            while (y < destRect.height) {
                this.getTiePointGrid().readPixels(srcX, this.getSourceY(destRect.y + y), sourceWidth, 1, (float[])lineData.getElems(), ProgressMonitor.NULL);
                TiePointGridOpImage.copyLine(y, destRect.width, lineData, productData, sourceCoords);
                ++y;
            }
        }
    }
}

