/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.util.Debug;
import org.esa.beam.util.ProductUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class FeatureUtils {
    public static FeatureCollection<SimpleFeatureType, SimpleFeature> createFeatureCollection(URL url, CoordinateReferenceSystem targetCrs, Geometry clipGeometry) throws IOException {
        FeatureSource<SimpleFeatureType, SimpleFeature> featureSource = FeatureUtils.getFeatureSource(url);
        FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection = featureSource.getFeatures();
        featureCollection = FeatureUtils.clipCollection(featureCollection, DefaultGeographicCRS.WGS84, clipGeometry, DefaultGeographicCRS.WGS84, null, targetCrs, ProgressMonitor.NULL);
        return featureCollection;
    }

    public static FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(URL url) throws IOException {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put(ShapefileDataStoreFactory.URLP.key, url);
        map.put(ShapefileDataStoreFactory.CREATE_SPATIAL_INDEX.key, Boolean.TRUE);
        DataStore shapefileStore = DataStoreFinder.getDataStore(map);
        String typeName = shapefileStore.getTypeNames()[0];
        return shapefileStore.getFeatureSource(typeName);
    }

    public static FeatureCollection<SimpleFeatureType, SimpleFeature> loadShapefileForProduct(File file, Product product, FeatureCrsProvider crsProvider, ProgressMonitor pm) throws IOException {
        pm.beginTask("Loading Shapefile", 100);
        try {
            FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection = FeatureUtils.loadFeatureCollectionFromShapefile(file);
            pm.worked(10);
            FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection2 = FeatureUtils.clipFeatureCollectionToProductBounds(featureCollection, product, crsProvider, pm);
            return featureCollection2;
        }
        finally {
            pm.done();
        }
    }

    public static FeatureCollection<SimpleFeatureType, SimpleFeature> clipFeatureCollectionToProductBounds(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection, Product product, FeatureCrsProvider crsProvider, ProgressMonitor pm) {
        CoordinateReferenceSystem targetCrs = ImageManager.getModelCrs(product.getGeoCoding());
        Geometry clipGeometry = FeatureUtils.createGeoBoundaryPolygon(product);
        pm.worked(10);
        CoordinateReferenceSystem featureCrs = featureCollection.getSchema().getCoordinateReferenceSystem();
        if (featureCrs == null) {
            featureCrs = crsProvider.getFeatureCrs(product);
        }
        return FeatureUtils.clipCollection(featureCollection, featureCrs, clipGeometry, DefaultGeographicCRS.WGS84, null, targetCrs, SubProgressMonitor.create(pm, 80));
    }

    public static FeatureCollection<SimpleFeatureType, SimpleFeature> loadFeatureCollectionFromShapefile(File shapefile) throws IOException {
        URL shapefileUrl = shapefile.toURI().toURL();
        FeatureSource<SimpleFeatureType, SimpleFeature> featureSource = FeatureUtils.getFeatureSource(shapefileUrl);
        return featureSource.getFeatures();
    }

    public static String createFeatureTypeName(String defaultGeometry) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMMyyyy'T'HH.mm.ss");
        String currentTime = simpleDateFormat.format(Calendar.getInstance().getTime());
        return String.format("org.esa.beam_%s_%s", defaultGeometry, currentTime);
    }

    public static String createFeatureId(int base) {
        return "ID" + String.format("%08d", base);
    }

    /*
     * Exception decompiling
     */
    public static FeatureCollection<SimpleFeatureType, SimpleFeature> clipCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> sourceCollection, CoordinateReferenceSystem defaultSourceCrs, Geometry clipGeometry, CoordinateReferenceSystem clipCrs, String targetID, CoordinateReferenceSystem targetCrs, ProgressMonitor pm) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[UNCONDITIONALDOLOOP]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static SimpleFeature createTargetFeature(Geometry sourceGeometry, SimpleFeatureType targetSchema, SimpleFeature sourceFeature, GeometryCoordinateSequenceTransformer source2TargetTransformer) {
        SimpleFeature targetFeature;
        if (source2TargetTransformer != null) {
            Geometry targetGeometry;
            try {
                targetGeometry = source2TargetTransformer.transform(sourceGeometry);
            }
            catch (Exception e) {
                Debug.trace(e);
                return null;
            }
            targetFeature = SimpleFeatureBuilder.retype(sourceFeature, targetSchema);
            targetFeature.setDefaultGeometry(targetGeometry);
        } else {
            targetFeature = SimpleFeatureBuilder.copy(sourceFeature);
            targetFeature.setDefaultGeometry(sourceGeometry);
        }
        return targetFeature;
    }

    private static Geometry getClippedGeometry(Geometry sourceGeometry, Geometry clipGeometry) {
        Geometry targetGeometry = sourceGeometry.intersection(clipGeometry);
        if (targetGeometry instanceof Polygon) {
            GeometryFactory geometryFactory = new GeometryFactory();
            if (MultiPolygon.class.isAssignableFrom(sourceGeometry.getClass())) {
                targetGeometry = geometryFactory.createMultiPolygon(new Polygon[]{(Polygon)targetGeometry});
            }
        }
        return targetGeometry;
    }

    public static GeometryCoordinateSequenceTransformer getTransform(CoordinateReferenceSystem sourceCrs, CoordinateReferenceSystem targetCrs) {
        GeometryCoordinateSequenceTransformer transformer;
        try {
            MathTransform transform = CRS.findMathTransform(sourceCrs, targetCrs, true);
            transformer = new GeometryCoordinateSequenceTransformer();
            transformer.setMathTransform(transform);
            transformer.setCoordinateReferenceSystem(targetCrs);
        }
        catch (FactoryException e) {
            throw new IllegalStateException(e);
        }
        return transformer;
    }

    public static Geometry createGeoBoundaryPolygon(Product product) {
        Coordinate[] coordinates;
        GeometryFactory gf = new GeometryFactory();
        GeoPos[] geoPositions = ProductUtils.createGeoBoundary(product, 100);
        if (geoPositions.length >= 0 && geoPositions.length <= 3) {
            coordinates = new Coordinate[]{};
        } else {
            coordinates = new Coordinate[geoPositions.length + 1];
            int i = 0;
            while (i < geoPositions.length) {
                GeoPos geoPos = geoPositions[i];
                coordinates[i] = new Coordinate(geoPos.lon, geoPos.lat);
                ++i;
            }
            coordinates[coordinates.length - 1] = coordinates[0];
        }
        return gf.createPolygon(gf.createLinearRing(coordinates), null);
    }

    private static FeatureCollection<SimpleFeatureType, SimpleFeature> transformPixelPosToGeoPos(FeatureCollection<SimpleFeatureType, SimpleFeature> fc, GeoCoding geoCoding) {
        Iterator<SimpleFeature> iterator = fc.iterator();
        DefaultFeatureCollection transformedFc = new DefaultFeatureCollection(fc.getID(), fc.getSchema());
        while (iterator.hasNext()) {
            SimpleFeature sourceFeature = iterator.next();
            Geometry geometry = (Geometry)sourceFeature.getDefaultGeometry();
            GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();
            transformer.setMathTransform(geoCoding.getImageToMapTransform());
            transformer.setCoordinateReferenceSystem(geoCoding.getMapCRS());
            try {
                geometry = transformer.transform(geometry);
            }
            catch (TransformException e) {
                throw new IllegalStateException(e);
            }
            sourceFeature.setDefaultGeometry(geometry);
            transformedFc.add(sourceFeature);
        }
        return transformedFc;
    }

    public static interface FeatureCrsProvider {
        public CoordinateReferenceSystem getFeatureCrs(Product var1);
    }
}

