/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.jai;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import javax.media.jai.ComponentSampleModelJAI;
import org.esa.beam.util.ImageUtils;

public class SingleBandedSampleModel
extends ComponentSampleModelJAI {
    public SingleBandedSampleModel(int dataType, int w, int h) {
        super(dataType, w, h, 1, w, new int[1]);
    }

    @Override
    public SampleModel createCompatibleSampleModel(int w, int h) {
        return new SingleBandedSampleModel(this.dataType, w, h);
    }

    @Override
    public SampleModel createSubsetSampleModel(int[] bands) {
        return this.createCompatibleSampleModel(this.width, this.height);
    }

    @Override
    public final int getOffset(int x, int y) {
        return y * this.width + x;
    }

    @Override
    public final int getOffset(int x, int y, int b) {
        return y * this.width + x;
    }

    @Override
    public Object getDataElements(int x, int y, int w, int h, Object obj, DataBuffer data) {
        if (obj == null) {
            obj = ImageUtils.createDataBufferArray(data.getDataType(), w * h);
        }
        this.getSamplesFast(x, y, w, h, obj, ImageUtils.getPrimitiveArray(data), data.getOffset());
        return obj;
    }

    @Override
    public void setDataElements(int x, int y, int w, int h, Object obj, DataBuffer data) {
        this.setSamplesFast(x, y, w, h, obj, ImageUtils.getPrimitiveArray(data), data.getOffset());
    }

    @Override
    public int[] getPixels(int x, int y, int w, int h, int[] array, DataBuffer data) {
        return this.getSamples(x, y, w, h, 0, array, data);
    }

    @Override
    public float[] getPixels(int x, int y, int w, int h, float[] array, DataBuffer data) {
        return this.getSamples(x, y, w, h, 0, array, data);
    }

    @Override
    public double[] getPixels(int x, int y, int w, int h, double[] array, DataBuffer data) {
        return this.getSamples(x, y, w, h, 0, array, data);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, int[] array, DataBuffer data) {
        this.setSamples(x, y, w, h, 0, array, data);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, float[] array, DataBuffer data) {
        this.setSamples(x, y, w, h, 0, array, data);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, double[] array, DataBuffer data) {
        this.setSamples(x, y, w, h, 0, array, data);
    }

    @Override
    public int[] getPixel(int x, int y, int[] array, DataBuffer data) {
        if (array == null) {
            array = new int[]{this.getSample(x, y, 0, data)};
        }
        return array;
    }

    @Override
    public float[] getPixel(int x, int y, float[] array, DataBuffer data) {
        if (array == null) {
            array = new float[]{this.getSampleFloat(x, y, 0, data)};
        }
        return array;
    }

    @Override
    public double[] getPixel(int x, int y, double[] array, DataBuffer data) {
        if (array == null) {
            array = new double[]{this.getSampleDouble(x, y, 0, data)};
        }
        return array;
    }

    @Override
    public void setPixel(int x, int y, int[] array, DataBuffer data) {
        this.setSample(x, y, 0, array[0], data);
    }

    @Override
    public void setPixel(int x, int y, float[] array, DataBuffer data) {
        this.setSample(x, y, 0, array[0], data);
    }

    @Override
    public void setPixel(int x, int y, double[] array, DataBuffer data) {
        this.setSample(x, y, 0, array[0], data);
    }

    @Override
    public int[] getSamples(int x, int y, int w, int h, int b, int[] array, DataBuffer data) {
        this.checkBounds(x, y, w, h);
        if (array == null) {
            array = new int[w * h];
        }
        if (this.dataType == 3) {
            this.getSamplesFast(x, y, w, h, array, ((DataBufferInt)data).getData(), data.getOffset());
        } else {
            super.getSamples(x, y, w, h, b, array, data);
        }
        return array;
    }

    @Override
    public float[] getSamples(int x, int y, int w, int h, int b, float[] array, DataBuffer data) {
        this.checkBounds(x, y, w, h);
        if (array == null) {
            array = new float[w * h];
        }
        if (this.dataType == 4) {
            this.getSamplesFast(x, y, w, h, array, ((DataBufferFloat)data).getData(), data.getOffset());
        } else {
            super.getSamples(x, y, w, h, b, array, data);
        }
        return array;
    }

    @Override
    public double[] getSamples(int x, int y, int w, int h, int b, double[] array, DataBuffer data) {
        this.checkBounds(x, y, w, h);
        if (array == null) {
            array = new double[w * h];
        }
        if (this.dataType == 5) {
            this.getSamplesFast(x, y, w, h, array, ((DataBufferDouble)data).getData(), data.getOffset());
        } else {
            super.getSamples(x, y, w, h, b, array, data);
        }
        return array;
    }

    @Override
    public void setSamples(int x, int y, int w, int h, int b, int[] array, DataBuffer data) {
        this.checkBounds(x, y, w, h);
        if (this.dataType == 3) {
            this.setSamplesFast(x, y, w, h, array, ((DataBufferInt)data).getData(), data.getOffset());
        } else {
            super.setSamples(x, y, w, h, b, array, data);
        }
    }

    @Override
    public void setSamples(int x, int y, int w, int h, int b, float[] array, DataBuffer data) {
        this.checkBounds(x, y, w, h);
        if (this.dataType == 4) {
            this.setSamplesFast(x, y, w, h, array, ((DataBufferFloat)data).getData(), data.getOffset());
        } else {
            super.setSamples(x, y, w, h, b, array, data);
        }
    }

    @Override
    public void setSamples(int x, int y, int w, int h, int b, double[] array, DataBuffer data) {
        this.checkBounds(x, y, w, h);
        if (this.dataType == 5) {
            this.setSamplesFast(x, y, w, h, array, ((DataBufferDouble)data).getData(), data.getOffset());
        } else {
            super.setSamples(x, y, w, h, b, array, data);
        }
    }

    @Override
    public int getSample(int x, int y, int b, DataBuffer data) {
        this.checkBounds(x, y);
        return data.getElem(y * this.width + x);
    }

    @Override
    public float getSampleFloat(int x, int y, int b, DataBuffer data) {
        this.checkBounds(x, y);
        return data.getElemFloat(y * this.width + x);
    }

    @Override
    public double getSampleDouble(int x, int y, int b, DataBuffer data) {
        this.checkBounds(x, y);
        return data.getElemDouble(y * this.width + x);
    }

    @Override
    public void setSample(int x, int y, int b, int s, DataBuffer data) {
        this.checkBounds(x, y);
        data.setElem(y * this.width + x, s);
    }

    @Override
    public void setSample(int x, int y, int b, float s, DataBuffer data) {
        this.checkBounds(x, y);
        data.setElemFloat(y * this.width + x, s);
    }

    @Override
    public void setSample(int x, int y, int b, double s, DataBuffer data) {
        this.checkBounds(x, y);
        data.setElemDouble(y * this.width + x, s);
    }

    private void setSamplesFast(int x, int y, int w, int h, Object sourceArray, Object targetArray, int targetOffset) {
        int targetIndex = y * this.width + x;
        if (w == this.width) {
            System.arraycopy(sourceArray, 0, targetArray, targetOffset + targetIndex, w * h);
        } else {
            int i = 0;
            while (i < h) {
                System.arraycopy(sourceArray, i * w, targetArray, targetOffset + targetIndex, w);
                targetIndex += this.width;
                ++i;
            }
        }
    }

    private void getSamplesFast(int x, int y, int w, int h, Object targetArray, Object sourceArray, int sourceOffset) {
        int sourceIndex = y * this.width + x;
        if (w == this.width) {
            System.arraycopy(sourceArray, sourceOffset + sourceIndex, targetArray, 0, w * h);
        } else {
            int i = 0;
            while (i < h) {
                System.arraycopy(sourceArray, sourceOffset + sourceIndex, targetArray, i * w, w);
                sourceIndex += this.width;
                ++i;
            }
        }
    }

    private void checkBounds(int x, int y, int w, int h) {
        this.checkBounds(x, y);
        this.checkBounds(x + w - 1, y + h - 1);
    }

    private void checkBounds(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(String.format("(x < 0) || (y < 0) || (x >= %d) || (y >= %d) for x=%d,y=%d", this.width, this.height, x, y));
        }
    }
}

