/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.math;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import org.esa.beam.util.math.FX;
import org.esa.beam.util.math.FXY;
import org.esa.beam.util.math.FXYSum;

public class Approximator {
    public static void approximateFX(double[][] data, int[] indices, FX[] f, double[] c) {
        int n = f.length;
        int m = data.length;
        double[][] a = new double[n][n];
        double[] b = new double[n];
        int iX = 0;
        int iY = 1;
        if (indices != null) {
            iX = indices[0];
            iY = indices[1];
        }
        int i = 0;
        while (i < n) {
            double result;
            double x;
            int k;
            int j = i;
            while (j < n) {
                k = 0;
                while (k < m) {
                    x = data[k][iX];
                    result = f[i].f(x) * f[j].f(x);
                    if (!Double.isNaN(result)) {
                        double[] dArray = a[i];
                        int n2 = j;
                        dArray[n2] = dArray[n2] + result;
                    }
                    ++k;
                }
                ++j;
            }
            j = 0;
            while (j < i) {
                a[i][j] = a[j][i];
                ++j;
            }
            k = 0;
            while (k < m) {
                double y = data[k][iY];
                x = data[k][iX];
                result = y * f[i].f(x);
                if (!Double.isNaN(result)) {
                    int n3 = i;
                    b[n3] = b[n3] + result;
                }
                ++k;
            }
            ++i;
        }
        Approximator.solve2(a, b, c);
    }

    public static void approximateFXY(double[][] data, int[] indices, FXY[] f, double[] c) {
        int n = f.length;
        int cfr_ignored_0 = data.length;
        double[][] a = new double[n][n];
        double[] b = new double[n];
        int iX = 0;
        int iY = 1;
        int iZ = 2;
        if (indices != null) {
            iX = indices[0];
            iY = indices[1];
            iZ = indices[2];
        }
        int i = 0;
        while (i < n) {
            double y;
            double x;
            int n2;
            int j = i;
            while (j < n) {
                double[][] dArray = data;
                int n3 = data.length;
                n2 = 0;
                while (n2 < n3) {
                    double[] point = dArray[n2];
                    x = point[iX];
                    y = point[iY];
                    double result = f[i].f(x, y) * f[j].f(x, y);
                    if (!Double.isNaN(result)) {
                        double[] dArray2 = a[i];
                        int n4 = j;
                        dArray2[n4] = dArray2[n4] + result;
                    }
                    ++n2;
                }
                ++j;
            }
            j = 0;
            while (j < i) {
                a[i][j] = a[j][i];
                ++j;
            }
            double[][] dArray = data;
            n2 = data.length;
            int n5 = 0;
            while (n5 < n2) {
                double[] point = dArray[n5];
                double z = point[iZ];
                x = point[iX];
                y = point[iY];
                double result = z * f[i].f(x, y);
                if (!Double.isNaN(result)) {
                    int n6 = i;
                    b[n6] = b[n6] + result;
                }
                ++n5;
            }
            ++i;
        }
        Approximator.solve2(a, b, c);
    }

    public static double getRMSE(double[][] data, int[] indices, FX[] f, double[] c) {
        int m = data.length;
        double mse = 0.0;
        int iX = 0;
        int iY = 1;
        if (indices != null) {
            iX = indices[0];
            iY = indices[1];
        }
        double[][] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double[] point = dArray[n2];
            double x = point[iX];
            double y = point[iY];
            double d = Approximator.computeY(f, c, x) - y;
            mse += d * d;
            ++n2;
        }
        return Math.sqrt(mse /= (double)m);
    }

    public static double computeRMSE(double[][] data, int[] indices, FXY[] f, double[] c) {
        int m = data.length;
        double mse = 0.0;
        int iX = 0;
        int iY = 1;
        int iZ = 2;
        if (indices != null) {
            iX = indices[0];
            iY = indices[1];
            iZ = indices[2];
        }
        double[][] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double[] point = dArray[n2];
            double x = point[iX];
            double y = point[iY];
            double z = point[iZ];
            double d = FXYSum.computeZ(f, c, x, y) - z;
            mse += d * d;
            ++n2;
        }
        return Math.sqrt(mse /= (double)m);
    }

    public static double[] computeErrorStatistics(double[][] data, int[] indices, FXY[] f, double[] c) {
        int m = data.length;
        double mse = 0.0;
        double emax = 0.0;
        int iX = 0;
        int iY = 1;
        int iZ = 2;
        if (indices != null) {
            iX = indices[0];
            iY = indices[1];
            iZ = indices[2];
        }
        double[][] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double[] point = dArray[n2];
            double x = point[iX];
            double y = point[iY];
            double z = point[iZ];
            double d = FXYSum.computeZ(f, c, x, y) - z;
            emax = Math.max(emax, Math.abs(d));
            mse += d * d;
            ++n2;
        }
        double rmse = Math.sqrt(mse /= (double)m);
        return new double[]{rmse, emax};
    }

    public static double computeY(FX[] f, double[] c, double x) {
        int n = f.length;
        double y = 0.0;
        int i = 0;
        while (i < n) {
            y += c[i] * f[i].f(x);
            ++i;
        }
        return y;
    }

    public static double computeZ(FXY[] f, double[] c, double x, double y) {
        return FXYSum.computeZ(f, c, x, y);
    }

    public static void solve1(double[][] a, double[] b, double[] c) {
        Matrix matrixA = new Matrix(a);
        double[][] tempB = new double[b.length][1];
        int i = 0;
        while (i < tempB.length) {
            tempB[i][0] = b[i];
            ++i;
        }
        Matrix matrixB = new Matrix(tempB);
        Matrix matrixC = matrixA.solve(matrixB);
        double[][] tempC = matrixC.getArray();
        int i2 = 0;
        while (i2 < tempB.length) {
            c[i2] = tempC[i2][0];
            ++i2;
        }
    }

    private static void solve2(double[][] a, double[] b, double[] x) {
        int i;
        int m = b.length;
        int n = x.length;
        Matrix matrix = new Matrix(a, m, n);
        double det = matrix.det();
        if (det == 0.0 || Double.isNaN(det) || Double.isInfinite(det)) {
            throw new ArithmeticException("Expected an invertible matrix, but matrix is degenerate: det = " + det);
        }
        SingularValueDecomposition svd = matrix.svd();
        Matrix u = svd.getU();
        Matrix v = svd.getV();
        double[] s = svd.getSingularValues();
        int rank = svd.rank();
        int j = 0;
        while (j < rank) {
            x[j] = 0.0;
            i = 0;
            while (i < m) {
                int n2 = j;
                x[n2] = x[n2] + u.get(i, j) * b[i];
                ++i;
            }
            s[j] = x[j] / s[j];
            ++j;
        }
        j = 0;
        while (j < n) {
            x[j] = 0.0;
            i = 0;
            while (i < rank) {
                int n3 = j;
                x[n3] = x[n3] + v.get(j, i) * s[i];
                ++i;
            }
            ++j;
        }
    }
}

