/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.math;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.awt.image.RenderedImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.HistogramDescriptor;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.jai.JAIUtils;
import org.esa.beam.util.math.DoubleList;
import org.esa.beam.util.math.IndexValidator;
import org.esa.beam.util.math.MathUtils;
import org.esa.beam.util.math.Range;

public class Histogram
extends Range {
    public static final float LEFT_AREA_SKIPPED_95 = 0.025f;
    public static final float RIGHT_AREA_SKIPPED_95 = 0.025f;
    private int[] binCounts;
    private int maxBinCount;
    private int binCountsSum;

    public Histogram(int[] binCounts, double min, double max) {
        this.setBinCounts(binCounts, min, max);
    }

    public int getNumBins() {
        return this.binCounts.length;
    }

    public int[] getBinCounts() {
        return this.binCounts;
    }

    public void setBinCounts(int[] binValues, double min, double max) {
        this.setBinCounts(binValues);
        this.setMin(min);
        this.setMax(max);
    }

    public void setBinCounts(int[] binCounts) {
        this.binCounts = binCounts;
        this.updateBinCountSumAndBinCountMax();
    }

    public int getMaxBinCount() {
        return this.maxBinCount;
    }

    public int getBinCountsSum() {
        return this.binCountsSum;
    }

    public Range findRangeFor95Percent() {
        return this.findRange(0.025f, 0.025f);
    }

    public Range findRange(double leftHistoAreaSkipped, double rightHistoAreaSkipped) {
        return this.findRange(leftHistoAreaSkipped, rightHistoAreaSkipped, false, false);
    }

    public Range findRange(double leftHistoAreaSkipped, double rightHistoAreaSkipped, boolean skipLeftPeek, boolean skipRightPeek) {
        int c2;
        int c1;
        int c0;
        int j;
        int jSkip;
        int numBins = this.getNumBins();
        int[] binCounts = this.getBinCounts();
        int numSamplesTotal = this.getBinCountsSum();
        int jMax = numBins - 1;
        int j1 = 0;
        int j2 = jMax;
        int numSamples = numSamplesTotal;
        if (skipLeftPeek) {
            jSkip = -1;
            j = 1;
            while (j <= jMax) {
                c0 = binCounts[j];
                c1 = binCounts[j - 1];
                int n = c2 = j < 2 ? 0 : binCounts[j - 2];
                if (c1 > 0) {
                    if (c0 != 0 || c2 != 0) break;
                    jSkip = j;
                    break;
                }
                ++j;
            }
            if (jSkip != -1) {
                j1 = jSkip;
                numSamples -= binCounts[jSkip];
            }
        }
        if (skipRightPeek) {
            jSkip = -1;
            j = jMax - 1;
            while (j >= 0) {
                c0 = binCounts[j];
                c1 = binCounts[j + 1];
                int n = c2 = j < jMax - 2 ? 0 : binCounts[j + 2];
                if (c1 > 0) {
                    if (c0 != 0 || c2 != 0) break;
                    jSkip = j;
                    break;
                }
                --j;
            }
            if (jSkip != -1) {
                j2 = jSkip;
                numSamples -= binCounts[jSkip];
            }
        }
        if (j1 >= j2 || numSamples <= 0) {
            j1 = 0;
            j2 = jMax;
            numSamples = numSamplesTotal;
        }
        double binCountSum = 0.0;
        while (j1 <= jMax) {
            double leftArea = (binCountSum += (double)binCounts[j1]) / (double)numSamples;
            if (leftArea > leftHistoAreaSkipped) break;
            ++j1;
        }
        if (j1 > jMax) {
            j1 = jMax;
        }
        binCountSum = 0.0;
        while (j2 >= 0) {
            double rightArea = (binCountSum += (double)binCounts[j2]) / (double)numSamples;
            if (rightArea > rightHistoAreaSkipped) break;
            --j2;
        }
        if (j2 < 0) {
            j2 = 0;
        }
        if (j1 > j2) {
            int temp = j1;
            j1 = j2;
            j2 = temp;
        } else if (j1 == j2) {
            if (j2 < jMax) {
                ++j2;
            } else if (j1 > 0) {
                --j1;
            }
        }
        Range range = this.getRange(j1, j2);
        Debug.trace("Histogram: lower bin index = " + j1 + " (less than " + leftHistoAreaSkipped * 100.0 + "% of pixels skipped)");
        Debug.trace("Histogram: upper bin index = " + j2 + " (less than " + rightHistoAreaSkipped * 100.0 + "% of pixels skipped)");
        Debug.trace("Histogram: histo sample min = " + range.getMin() + "; sample max = " + range.getMax());
        return range;
    }

    public Range getRange(int binIndex) {
        return this.getRange(binIndex, binIndex);
    }

    public Range getRange(int binIndex1, int binIndex2) {
        return new Range(this.getMin() + (double)binIndex1 * (this.getMax() - this.getMin()) / (double)this.getNumBins(), this.getMin() + (double)(binIndex2 + 1) * (this.getMax() - this.getMin()) / (double)this.getNumBins());
    }

    public int getBinIndex(double value) {
        if (value == this.getMin()) {
            return 0;
        }
        if (value == this.getMax()) {
            return this.getNumBins() - 1;
        }
        int binIndex = MathUtils.floorInt((value - this.getMin()) / (this.getMax() - this.getMin()) * (double)this.getNumBins());
        if (binIndex >= 0 && binIndex < this.getNumBins()) {
            return binIndex;
        }
        return -1;
    }

    @Override
    public void aggregate(Object values, boolean unsigned, IndexValidator validator, ProgressMonitor pm) {
        Guardian.assertNotNull("validator", validator);
        Histogram histogram = Histogram.computeHistogramGeneric(values, unsigned, validator, this.getNumBins(), new Range(this.getMin(), this.getMax()), null, pm);
        int[] newCounts = histogram.getBinCounts();
        int[] thisCounts = this.getBinCounts();
        int i = 0;
        while (i < thisCounts.length) {
            int n = i;
            thisCounts[n] = thisCounts[n] + newCounts[i];
            ++i;
        }
        this.updateBinCountSumAndBinCountMax();
    }

    private void updateBinCountSumAndBinCountMax() {
        int[] binCounts = this.getBinCounts();
        this.maxBinCount = Integer.MIN_VALUE;
        this.binCountsSum = 0;
        if (binCounts != null) {
            int i = 0;
            while (i < binCounts.length) {
                int binCount = binCounts[i];
                if (this.maxBinCount < binCount) {
                    this.maxBinCount = binCount;
                }
                this.binCountsSum += binCount;
                ++i;
            }
        }
    }

    public static Histogram computeHistogramByte(byte[] values, IndexValidator validator, int numBins, Range range, Histogram histo, ProgressMonitor pm) {
        Guardian.assertNotNull("validator", validator);
        int numValues = values.length;
        int[] binVals = new int[numBins];
        pm.beginTask("Computing histogram", range == null ? 2 : 1);
        try {
            if (range == null) {
                range = Histogram.computeRangeByte(values, validator, range, SubProgressMonitor.create(pm, 1));
            }
            int min = MathUtils.floorInt(range.getMin());
            int max = MathUtils.floorInt(range.getMax());
            int delta = max > min ? max - min : 1;
            ProgressMonitor subPm = SubProgressMonitor.create(pm, 1);
            subPm.beginTask("Computing histogram", numValues);
            try {
                int i = 0;
                while (i < numValues) {
                    byte value;
                    if (validator.validateIndex(i) && (value = values[i]) >= min && value <= max) {
                        int binIndex = numBins * (value - min) / delta;
                        if (binIndex == numBins) {
                            binIndex = numBins - 1;
                        }
                        int n = binIndex;
                        binVals[n] = binVals[n] + 1;
                    }
                    subPm.worked(1);
                    ++i;
                }
            }
            finally {
                subPm.done();
            }
            if (histo != null) {
                histo.setBinCounts(binVals, min, max);
            } else {
                histo = new Histogram(binVals, min, max);
            }
        }
        finally {
            pm.done();
        }
        return histo;
    }

    public static Histogram computeHistogramUByte(byte[] values, IndexValidator validator, int numBins, Range range, Histogram histo, ProgressMonitor pm) {
        Guardian.assertNotNull("validator", validator);
        int numValues = values.length;
        int[] binVals = new int[numBins];
        pm.beginTask("Computing histogram", range == null ? 2 : 1);
        try {
            if (range == null) {
                range = Histogram.computeRangeUByte(values, validator, range, SubProgressMonitor.create(pm, 1));
            }
            int min = MathUtils.floorInt(range.getMin());
            int max = MathUtils.floorInt(range.getMax());
            int delta = max > min ? max - min : 1;
            ProgressMonitor subPm = SubProgressMonitor.create(pm, 1);
            subPm.beginTask("Computing histogram", numValues);
            try {
                int i = 0;
                while (i < numValues) {
                    int value;
                    if (validator.validateIndex(i) && (value = values[i] & 0xFF) >= min && value <= max) {
                        int binIndex = numBins * (value - min) / delta;
                        if (binIndex == numBins) {
                            binIndex = numBins - 1;
                        }
                        int n = binIndex;
                        binVals[n] = binVals[n] + 1;
                    }
                    subPm.worked(1);
                    ++i;
                }
            }
            finally {
                subPm.done();
            }
            if (histo != null) {
                histo.setBinCounts(binVals, min, max);
            } else {
                histo = new Histogram(binVals, min, max);
            }
        }
        finally {
            pm.done();
        }
        return histo;
    }

    public static Histogram computeHistogramShort(short[] values, IndexValidator validator, int numBins, Range range, Histogram histo, ProgressMonitor pm) {
        Guardian.assertNotNull("validator", validator);
        int numValues = values.length;
        int[] binVals = new int[numBins];
        pm.beginTask("Computing histogram", range == null ? 2 : 1);
        try {
            if (range == null) {
                range = Histogram.computeRangeShort(values, validator, range, SubProgressMonitor.create(pm, 1));
            }
            int min = MathUtils.floorInt(range.getMin());
            int max = MathUtils.floorInt(range.getMax());
            int delta = max > min ? max - min : 1;
            ProgressMonitor subPm = SubProgressMonitor.create(pm, 1);
            subPm.beginTask("Computing histogram", numValues);
            try {
                int i = 0;
                while (i < numValues) {
                    short value;
                    if (validator.validateIndex(i) && (value = values[i]) >= min && value <= max) {
                        int binIndex = numBins * (value - min) / delta;
                        if (binIndex == numBins) {
                            binIndex = numBins - 1;
                        }
                        int n = binIndex;
                        binVals[n] = binVals[n] + 1;
                    }
                    subPm.worked(1);
                    ++i;
                }
            }
            finally {
                subPm.done();
            }
            if (histo != null) {
                histo.setBinCounts(binVals, min, max);
            } else {
                histo = new Histogram(binVals, min, max);
            }
        }
        finally {
            pm.done();
        }
        return histo;
    }

    public static Histogram computeHistogramUShort(short[] values, IndexValidator validator, int numBins, Range range, Histogram histo, ProgressMonitor pm) {
        Guardian.assertNotNull("validator", validator);
        int numValues = values.length;
        int[] binVals = new int[numBins];
        pm.beginTask("Computing histogram", range == null ? 2 : 1);
        try {
            if (range == null) {
                range = Histogram.computeRangeUShort(values, validator, range, SubProgressMonitor.create(pm, 1));
            }
            int min = MathUtils.floorInt(range.getMin());
            int max = MathUtils.floorInt(range.getMax());
            int delta = max > min ? max - min : 1;
            ProgressMonitor subPm = SubProgressMonitor.create(pm, 1);
            subPm.beginTask("Computing histogram", numValues);
            try {
                int i = 0;
                while (i < numValues) {
                    int value;
                    if (validator.validateIndex(i) && (value = values[i] & 0xFFFF) >= min && value <= max) {
                        int binIndex = numBins * (value - min) / delta;
                        if (binIndex == numBins) {
                            binIndex = numBins - 1;
                        }
                        int n = binIndex;
                        binVals[n] = binVals[n] + 1;
                    }
                    subPm.worked(1);
                    ++i;
                }
            }
            finally {
                subPm.done();
            }
            if (histo != null) {
                histo.setBinCounts(binVals, min, max);
            } else {
                histo = new Histogram(binVals, min, max);
            }
        }
        finally {
            pm.done();
        }
        return histo;
    }

    public static Histogram computeHistogramInt(int[] values, IndexValidator validator, int numBins, Range range, Histogram histogram, ProgressMonitor pm) {
        Guardian.assertNotNull("validator", validator);
        int numValues = values.length;
        int[] binVals = new int[numBins];
        pm.beginTask("Computing histogram", range == null ? 2 : 1);
        try {
            if (range == null) {
                range = Histogram.computeRangeInt(values, validator, range, SubProgressMonitor.create(pm, 1));
            }
            long min = MathUtils.floorLong(range.getMin());
            long max = MathUtils.floorLong(range.getMax());
            long delta = max > min ? max - min : 1L;
            double scale = (double)numBins / (double)delta;
            double offset = -scale * (double)min;
            ProgressMonitor subPm = SubProgressMonitor.create(pm, 1);
            subPm.beginTask("Computing histogram", numValues);
            try {
                int i = 0;
                while (i < numValues) {
                    int value;
                    if (validator.validateIndex(i) && (long)(value = values[i]) >= min && (long)value <= max) {
                        int binIndex = (int)(scale * (double)value + offset);
                        if (binIndex == numBins) {
                            binIndex = numBins - 1;
                        }
                        int n = binIndex;
                        binVals[n] = binVals[n] + 1;
                    }
                    subPm.worked(1);
                    ++i;
                }
            }
            finally {
                subPm.done();
            }
            if (histogram != null) {
                histogram.setBinCounts(binVals, min, max);
            } else {
                histogram = new Histogram(binVals, min, max);
            }
        }
        finally {
            pm.done();
        }
        return histogram;
    }

    public static Histogram computeHistogramUInt(int[] values, IndexValidator validator, int numBins, Range range, Histogram histogram, ProgressMonitor pm) {
        Guardian.assertNotNull("validator", validator);
        int numValues = values.length;
        int[] binVals = new int[numBins];
        pm.beginTask("Computing histogram", range == null ? 2 : 1);
        try {
            if (range == null) {
                range = Histogram.computeRangeUInt(values, validator, range, SubProgressMonitor.create(pm, 1));
            }
            long min = MathUtils.floorLong(range.getMin());
            long max = MathUtils.floorLong(range.getMax());
            long delta = max > min ? max - min : 1L;
            ProgressMonitor subPm = SubProgressMonitor.create(pm, 1);
            subPm.beginTask("Computing histogram", numValues);
            try {
                int i = 0;
                while (i < numValues) {
                    long value;
                    if (validator.validateIndex(i) && (value = (long)values[i] & 0xFFFFFFFFL) >= min && value <= max) {
                        int binIndex = (int)((long)numBins * (value - min) / delta);
                        if (binIndex == numBins) {
                            binIndex = numBins - 1;
                        }
                        int n = binIndex;
                        binVals[n] = binVals[n] + 1;
                    }
                    subPm.worked(1);
                    ++i;
                }
            }
            finally {
                subPm.done();
            }
            if (histogram != null) {
                histogram.setBinCounts(binVals, min, max);
            } else {
                histogram = new Histogram(binVals, min, max);
            }
        }
        finally {
            pm.done();
        }
        return histogram;
    }

    public static Histogram computeHistogramFloat(float[] values, IndexValidator validator, int numBins, Range range, Histogram histogram, ProgressMonitor pm) {
        Guardian.assertNotNull("validator", validator);
        int numValues = values.length;
        int[] binVals = new int[numBins];
        pm.beginTask("Computing histogram", range == null ? 2 : 1);
        try {
            if (range == null) {
                range = Histogram.computeRangeFloat(values, validator, range, SubProgressMonitor.create(pm, 1));
            }
            float min = (float)range.getMin();
            float max = (float)range.getMax();
            float delta = max > min ? max - min : 1.0f;
            float scale = (float)numBins / delta;
            float offset = -scale * min;
            ProgressMonitor subPm = SubProgressMonitor.create(pm, 1);
            subPm.beginTask("Computing histogram", numValues);
            try {
                int i = 0;
                while (i < numValues) {
                    float value;
                    if (validator.validateIndex(i) && !Float.isNaN(value = values[i]) && !Float.isInfinite(value) && value >= min && value <= max) {
                        int binIndex = (int)(scale * value + offset);
                        if (binIndex == numBins) {
                            binIndex = numBins - 1;
                        }
                        int n = binIndex;
                        binVals[n] = binVals[n] + 1;
                    }
                    subPm.worked(1);
                    ++i;
                }
            }
            finally {
                subPm.done();
            }
            if (histogram != null) {
                histogram.setBinCounts(binVals, min, max);
            } else {
                histogram = new Histogram(binVals, min, max);
            }
        }
        finally {
            pm.done();
        }
        return histogram;
    }

    public static Histogram computeHistogramDouble(double[] values, IndexValidator validator, int numBins, Range range, Histogram histogram, ProgressMonitor pm) {
        Guardian.assertNotNull("validator", validator);
        int numValues = values.length;
        int[] binVals = new int[numBins];
        pm.beginTask("Computing histogram", range == null ? 2 : 1);
        try {
            if (range == null) {
                range = Histogram.computeRangeDouble(values, validator, range, SubProgressMonitor.create(pm, 1));
            }
            double min = range.getMin();
            double max = range.getMax();
            double delta = max > min ? max - min : 1.0;
            double scale = (double)numBins / delta;
            double offset = -scale * min;
            ProgressMonitor subPm = SubProgressMonitor.create(pm, 1);
            subPm.beginTask("Computing histogram", numValues);
            try {
                int i = 0;
                while (i < numValues) {
                    double value;
                    if (validator.validateIndex(i) && !Double.isNaN(value = values[i]) && !Double.isInfinite(value) && value >= min && value <= max) {
                        int binIndex = (int)(scale * value + offset);
                        if (binIndex == numBins) {
                            binIndex = numBins - 1;
                        }
                        int n = binIndex;
                        binVals[n] = binVals[n] + 1;
                    }
                    subPm.worked(1);
                    ++i;
                }
            }
            finally {
                subPm.done();
            }
            if (histogram != null) {
                histogram.setBinCounts(binVals, min, max);
            } else {
                histogram = new Histogram(binVals, min, max);
            }
        }
        finally {
            pm.done();
        }
        return histogram;
    }

    public static Histogram computeHistogramDouble(DoubleList values, IndexValidator validator, int numBins, Range range, Histogram histo, ProgressMonitor pm) {
        Guardian.assertNotNull("validator", validator);
        int numValues = values.getSize();
        int[] binVals = new int[numBins];
        pm.beginTask("Computing histogram", range == null ? 2 : 1);
        try {
            if (range == null) {
                range = Histogram.computeRangeDouble(values, validator, range, SubProgressMonitor.create(pm, 1));
            }
            double min = range.getMin();
            double max = range.getMax();
            double delta = max - min;
            ProgressMonitor subPm = SubProgressMonitor.create(pm, 1);
            subPm.beginTask("Computing histogram", numValues);
            try {
                int i = 0;
                while (i < numValues) {
                    double value;
                    if (validator.validateIndex(i) && !Double.isNaN(value = values.getDouble(i)) && !Double.isInfinite(value) && value >= min && value <= max) {
                        int binIndex = (int)((double)numBins * (value - min) / delta);
                        if (binIndex == numBins) {
                            binIndex = numBins - 1;
                        }
                        int n = binIndex;
                        binVals[n] = binVals[n] + 1;
                    }
                    subPm.worked(1);
                    ++i;
                }
            }
            finally {
                subPm.done();
            }
            if (histo != null) {
                histo.setBinCounts(binVals, min, max);
            } else {
                histo = new Histogram(binVals, min, max);
            }
        }
        finally {
            pm.done();
        }
        return histo;
    }

    public static Histogram computeHistogramGeneric(Object values, boolean unsigned, IndexValidator validator, int numBins, Range range, Histogram histogram, ProgressMonitor pm) {
        Guardian.assertNotNull("validator", validator);
        if (values instanceof byte[]) {
            histogram = unsigned ? Histogram.computeHistogramUByte((byte[])values, validator, numBins, range, histogram, pm) : Histogram.computeHistogramByte((byte[])values, validator, numBins, range, histogram, pm);
        } else if (values instanceof short[]) {
            histogram = unsigned ? Histogram.computeHistogramUShort((short[])values, validator, numBins, range, histogram, pm) : Histogram.computeHistogramShort((short[])values, validator, numBins, range, histogram, pm);
        } else if (values instanceof int[]) {
            histogram = unsigned ? Histogram.computeHistogramUInt((int[])values, validator, numBins, range, histogram, pm) : Histogram.computeHistogramInt((int[])values, validator, numBins, range, histogram, pm);
        } else if (values instanceof float[]) {
            histogram = Histogram.computeHistogramFloat((float[])values, validator, numBins, range, histogram, pm);
        } else if (values instanceof double[]) {
            histogram = Histogram.computeHistogramDouble((double[])values, validator, numBins, range, histogram, pm);
        } else if (values instanceof DoubleList) {
            histogram = Histogram.computeHistogramDouble((DoubleList)values, validator, numBins, range, histogram, pm);
        } else {
            if (values == null) {
                throw new IllegalArgumentException("values is null");
            }
            throw new IllegalArgumentException("values has an illegal type: " + values.getClass());
        }
        return histogram;
    }

    public static Histogram computeHistogram(RenderedImage image, ROI roi, int numBins, Range range) {
        Histogram histogram;
        double max;
        double min = range.getMin();
        if (min < (max = range.getMax())) {
            RenderedOp histogramOp = HistogramDescriptor.create(image, roi, 1, 1, new int[]{numBins}, new double[]{min}, new double[]{max}, null);
            histogram = Histogram.getBeamHistogram(histogramOp);
        } else {
            long imageSize = (long)image.getWidth() * (long)image.getHeight();
            int numPixels = (int)Math.min(Integer.MAX_VALUE, imageSize);
            histogram = new Histogram(new int[]{numPixels}, min, min);
        }
        return histogram;
    }

    private static Histogram getBeamHistogram(RenderedOp histogramImage) {
        javax.media.jai.Histogram jaiHistogram = JAIUtils.getHistogramOf(histogramImage);
        int[] bins = jaiHistogram.getBins(0);
        int minIndex = 0;
        int maxIndex = bins.length - 1;
        int i = 0;
        while (i < bins.length) {
            if (bins[i] > 0) {
                minIndex = i;
                break;
            }
            ++i;
        }
        i = bins.length - 1;
        while (i >= 0) {
            if (bins[i] > 0) {
                maxIndex = i;
                break;
            }
            --i;
        }
        double lowValue = jaiHistogram.getLowValue(0);
        double highValue = jaiHistogram.getHighValue(0);
        int numBins = jaiHistogram.getNumBins(0);
        double binWidth = (highValue - lowValue) / (double)numBins;
        int[] croppedBins = new int[maxIndex - minIndex + 1];
        System.arraycopy(bins, minIndex, croppedBins, 0, croppedBins.length);
        return new Histogram(croppedBins, lowValue + (double)minIndex * binWidth, lowValue + ((double)maxIndex + 1.0) * binWidth);
    }
}

