/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.math;

import org.esa.beam.util.math.Array;

public class IntervalPartition {
    private double[] sequence;

    public IntervalPartition(double ... sequence) {
        this(new Array.Double(sequence));
    }

    public IntervalPartition(float ... sequence) {
        this(new Array.Float(sequence));
    }

    private IntervalPartition(Array sequence) {
        if (sequence.getLength() < 2) {
            throw new IllegalArgumentException("sequence.length < 2");
        }
        IntervalPartition.ensureStrictIncrease(sequence);
        this.sequence = new double[sequence.getLength()];
        sequence.copyTo(0, this.sequence, 0, this.sequence.length);
    }

    public static IntervalPartition[] createArray(double[] ... sequences) {
        if (sequences == null) {
            throw new NullPointerException("sequences == null");
        }
        if (sequences.length == 0) {
            throw new IllegalArgumentException("sequences.length == 0");
        }
        IntervalPartition[] partitions = new IntervalPartition[sequences.length];
        int i = 0;
        while (i < partitions.length) {
            partitions[i] = new IntervalPartition(sequences[i]);
            ++i;
        }
        return partitions;
    }

    public static IntervalPartition[] createArray(float[] ... sequences) {
        if (sequences == null) {
            throw new NullPointerException("sequences == null");
        }
        if (sequences.length == 0) {
            throw new IllegalArgumentException("sequences.length == 0");
        }
        IntervalPartition[] partitions = new IntervalPartition[sequences.length];
        int i = 0;
        while (i < partitions.length) {
            partitions[i] = new IntervalPartition(sequences[i]);
            ++i;
        }
        return partitions;
    }

    public final int getCardinal() {
        return this.sequence.length;
    }

    public final double get(int i) {
        return this.sequence[i];
    }

    public final double[] getSequence() {
        return (double[])this.sequence.clone();
    }

    public final double getMax() {
        return this.sequence[this.sequence.length - 1];
    }

    public final double getMin() {
        return this.sequence[0];
    }

    public final double getMesh() {
        double mesh = 0.0;
        int i = 1;
        while (i < this.sequence.length) {
            double length = this.sequence[i] - this.sequence[i - 1];
            if (length > mesh) {
                mesh = length;
            }
            ++i;
        }
        return mesh;
    }

    private static void ensureStrictIncrease(Array sequence) throws IllegalArgumentException {
        int i = 1;
        while (i < sequence.getLength()) {
            if (!(sequence.getValue(i - 1) < sequence.getValue(i))) {
                throw new IllegalArgumentException("sequence is not strictly increasing");
            }
            ++i;
        }
    }
}

