/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.math;

import java.text.MessageFormat;
import org.esa.beam.util.math.Array;
import org.esa.beam.util.math.FracIndex;
import org.esa.beam.util.math.IntervalPartition;

public class LookupTable {
    private final Array values;
    private final IntervalPartition[] dimensions;
    private final int[] strides;
    private final int[] o;

    public LookupTable(double[] values, IntervalPartition ... dimensions) {
        this(new Array.Double(values), dimensions);
    }

    public LookupTable(float[] values, IntervalPartition ... dimensions) {
        this(new Array.Float(values), dimensions);
    }

    public LookupTable(double[] values, double[] ... dimensions) {
        this(values, IntervalPartition.createArray(dimensions));
    }

    public LookupTable(float[] values, float[] ... dimensions) {
        this(values, IntervalPartition.createArray(dimensions));
    }

    private LookupTable(Array values, IntervalPartition ... dimensions) {
        LookupTable.ensureLegalArray(dimensions);
        LookupTable.ensureLegalArray(values, LookupTable.getVertexCount(dimensions));
        this.values = values;
        this.dimensions = dimensions;
        int n = dimensions.length;
        this.strides = new int[n];
        int i = n;
        int stride = 1;
        while (i-- > 0) {
            this.strides[i] = stride;
            stride *= dimensions[i].getCardinal();
        }
        this.o = new int[1 << n];
        LookupTable.computeVertexOffsets(this.strides, this.o);
    }

    public final int getDimensionCount() {
        return this.dimensions.length;
    }

    public final IntervalPartition[] getDimensions() {
        return this.dimensions;
    }

    public final IntervalPartition getDimension(int i) {
        return this.dimensions[i];
    }

    public final double getValue(double ... coordinates) throws IllegalArgumentException, NullPointerException {
        return this.getValue(coordinates, FracIndex.createArray(coordinates.length), new double[1 << coordinates.length]);
    }

    public final double getValue(double[] coordinates, FracIndex[] fracIndexes, double[] v) throws IllegalArgumentException, IndexOutOfBoundsException, NullPointerException {
        LookupTable.ensureLegalArray(coordinates, this.dimensions.length);
        int i = 0;
        while (i < this.dimensions.length) {
            LookupTable.computeFracIndex(this.dimensions[i], coordinates[i], fracIndexes[i]);
            ++i;
        }
        return this.getValue(fracIndexes, v);
    }

    public final double getValue(FracIndex[] fracIndexes, double[] v) {
        int origin = 0;
        int i = 0;
        while (i < this.dimensions.length) {
            origin += fracIndexes[i].i * this.strides[i];
            ++i;
        }
        i = 0;
        while (i < v.length) {
            v[i] = this.values.getValue(origin + this.o[i]);
            ++i;
        }
        i = this.dimensions.length;
        while (i-- > 0) {
            int m = 1 << i;
            double f = fracIndexes[i].f;
            int j = 0;
            while (j < m) {
                int n = j;
                v[n] = v[n] + f * (v[m + j] - v[j]);
                ++j;
            }
        }
        return v[0];
    }

    public static final void computeFracIndex(IntervalPartition partition, double coordinate, FracIndex fracIndex) {
        int lo = 0;
        int hi = partition.getCardinal() - 1;
        while (hi > lo + 1) {
            int m = lo + hi >> 1;
            if (coordinate < partition.get(m)) {
                hi = m;
                continue;
            }
            lo = m;
        }
        fracIndex.i = lo;
        fracIndex.f = (coordinate - partition.get(lo)) / (partition.get(hi) - partition.get(lo));
        fracIndex.truncate();
    }

    static void computeVertexOffsets(int[] strides, int[] offsets) {
        int i = 0;
        while (i < strides.length) {
            int k = 1 << i;
            int j = 0;
            while (j < k) {
                offsets[k + j] = offsets[j] + strides[i];
                ++j;
            }
            ++i;
        }
    }

    static int getVertexCount(IntervalPartition[] dimensions) {
        int count = 1;
        IntervalPartition[] intervalPartitionArray = dimensions;
        int n = dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            IntervalPartition dimension = intervalPartitionArray[n2];
            count *= dimension.getCardinal();
            ++n2;
        }
        return count;
    }

    static <T> void ensureLegalArray(T[] array) throws IllegalArgumentException, NullPointerException {
        if (array == null) {
            throw new NullPointerException("array == null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("array.length == 0");
        }
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            if (element == null) {
                throw new NullPointerException("element == null");
            }
            ++n2;
        }
    }

    static void ensureLegalArray(float[] array, int length) throws IllegalArgumentException, NullPointerException {
        if (array == null) {
            throw new NullPointerException("array == null");
        }
        if (array.length != length) {
            throw new IllegalArgumentException(MessageFormat.format("array.length = {0} does not correspond to the expected length {1}", array.length, length));
        }
    }

    static void ensureLegalArray(double[] array, int length) throws IllegalArgumentException, NullPointerException {
        if (array == null) {
            throw new NullPointerException("array == null");
        }
        if (array.length != length) {
            throw new IllegalArgumentException(MessageFormat.format("array.length = {0} does not correspond to the expected length {1}", array.length, length));
        }
    }

    static void ensureLegalArray(Array array, int length) throws IllegalArgumentException, NullPointerException {
        if (array == null) {
            throw new NullPointerException("array == null");
        }
        if (array.getLength() != length) {
            throw new IllegalArgumentException(MessageFormat.format("array.length = {0} does not correspond to the expected length {1}", array.getLength(), length));
        }
    }
}

