/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.util.List;
import javax.vecmath.MismatchedSizeException;
import org.geotools.referencing.operation.builder.MappedPosition;
import org.geotools.referencing.operation.builder.ProjectiveTransformBuilder;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimilarTransformBuilder
extends ProjectiveTransformBuilder {
    public SimilarTransformBuilder(List<MappedPosition> vectors) throws MismatchedSizeException, MismatchedDimensionException, MismatchedReferenceSystemException {
        super.setMappedPositions(vectors);
    }

    @Override
    protected void fillAMatrix() {
        int j;
        this.A = new GeneralMatrix(2 * this.getSourcePoints().length, 4);
        int numRow = this.getSourcePoints().length * 2;
        for (j = 0; j < numRow / 2; ++j) {
            this.A.setRow(j, new double[]{this.getSourcePoints()[j].getCoordinates()[0], -this.getSourcePoints()[j].getCoordinates()[1], 1.0, 0.0});
        }
        for (j = numRow / 2; j < numRow; ++j) {
            this.A.setRow(j, new double[]{this.getSourcePoints()[j - numRow / 2].getCoordinates()[1], this.getSourcePoints()[j - numRow / 2].getCoordinates()[0], 0.0, 1.0});
        }
    }

    @Override
    public int getMinimumPointCount() {
        return 2;
    }

    @Override
    protected GeneralMatrix getProjectiveMatrix() {
        GeneralMatrix M2 = new GeneralMatrix(3, 3);
        double[] param = this.calculateLSM();
        double[] m0 = new double[]{param[0], -param[1], param[2]};
        double[] m1 = new double[]{param[1], param[0], param[3]};
        double[] m2 = new double[]{0.0, 0.0, 1.0};
        M2.setRow(0, m0);
        M2.setRow(1, m1);
        M2.setRow(2, m2);
        return M2;
    }
}

