/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.List;
import org.geotools.filter.IllegalFilterException;
import org.geotools.styling.Font;
import org.geotools.util.Utilities;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.StyleVisitor;
import org.opengis.util.Cloneable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontImpl
implements Font,
Cloneable {
    private final List<Expression> fontFamily = new ArrayList<Expression>();
    private Expression fontSize = null;
    private Expression fontStyle = null;
    private Expression fontWeight = null;

    protected FontImpl() {
    }

    @Override
    @Deprecated
    public Expression getFontFamily() {
        if (this.fontFamily.isEmpty()) {
            return null;
        }
        return this.fontFamily.get(0);
    }

    @Override
    public List<Expression> getFamily() {
        return this.fontFamily;
    }

    @Override
    @Deprecated
    public void setFontFamily(Expression fontFamily) {
        this.fontFamily.clear();
        this.fontFamily.add(fontFamily);
    }

    @Override
    @Deprecated
    public Expression getFontSize() {
        return this.fontSize;
    }

    @Override
    public Expression getSize() {
        return this.fontSize;
    }

    @Override
    public void setSize(Expression size) {
        this.fontSize = size;
    }

    @Override
    @Deprecated
    public void setFontSize(Expression fontSize) {
        this.fontSize = fontSize;
    }

    @Override
    @Deprecated
    public Expression getFontStyle() {
        return this.fontStyle;
    }

    @Override
    public Expression getStyle() {
        return this.fontStyle;
    }

    @Override
    public void setStyle(Expression style) {
        this.fontStyle = style;
    }

    @Override
    @Deprecated
    public void setFontStyle(Expression fontStyle) {
        this.fontStyle = fontStyle;
    }

    @Override
    @Deprecated
    public Expression getFontWeight() {
        return this.fontWeight;
    }

    @Override
    public Expression getWeight() {
        return this.fontWeight;
    }

    @Override
    public void setWeight(Expression weight) {
        this.fontWeight = weight;
    }

    @Override
    @Deprecated
    public void setFontWeight(Expression fontWeight) {
        this.fontWeight = fontWeight;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("This should not happen", e);
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.fontFamily != null) {
            result = 1000003 * result + ((Object)this.fontFamily).hashCode();
        }
        if (this.fontSize != null) {
            result = 1000003 * result + this.fontSize.hashCode();
        }
        if (this.fontStyle != null) {
            result = 1000003 * result + this.fontStyle.hashCode();
        }
        if (this.fontWeight != null) {
            result = 1000003 * result + this.fontWeight.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (oth instanceof FontImpl) {
            FontImpl other = (FontImpl)oth;
            return Utilities.equals(this.fontFamily, other.fontFamily) && Utilities.equals(this.fontSize, other.fontSize) && Utilities.equals(this.fontStyle, other.fontStyle) && Utilities.equals(this.fontWeight, other.fontWeight);
        }
        return false;
    }

    static Font createDefault(FilterFactory filterFactory) {
        FontImpl font = new FontImpl();
        try {
            font.setSize(filterFactory.literal(new Integer(10)));
            font.setStyle(filterFactory.literal("normal"));
            font.setWeight(filterFactory.literal("normal"));
            font.setFontFamily(filterFactory.literal("Serif"));
        }
        catch (IllegalFilterException ife) {
            throw new RuntimeException("Error creating default", ife);
        }
        return font;
    }

    @Override
    public Object accept(StyleVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    static FontImpl cast(org.opengis.style.Font font) {
        if (font == null) {
            return null;
        }
        if (font instanceof FontImpl) {
            return (FontImpl)font;
        }
        FontImpl copy = new FontImpl();
        copy.getFamily().addAll(font.getFamily());
        copy.setSize(font.getSize());
        copy.setStyle(font.getStyle());
        copy.setWeight(font.getWeight());
        return copy;
    }
}

