/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data;

import gov.nasa.giss.data.ContourLevel;
import java.util.ArrayList;
import java.util.Iterator;

public class ContourLevels
implements Iterable<ContourLevel> {
    private ArrayList<ContourLevel> levels_;
    private boolean sorted_;

    public ContourLevels() {
        this(20);
    }

    public ContourLevels(int size) {
        this.levels_ = new ArrayList(size);
    }

    @Override
    public Iterator<ContourLevel> iterator() {
        return this.levels_.iterator();
    }

    public int size() {
        return this.levels_.size();
    }

    public void addLevel(ContourLevel level) {
        this.levels_.add(level);
    }

    public ContourLevel getLevel(int index) {
        if (!this.sorted_) {
            this.sort();
        }
        return this.levels_.get(index);
    }

    private synchronized void sort() {
        if (this.levels_.size() > 1) {
            int i;
            int isize = this.levels_.size();
            int[] index = new int[isize];
            boolean flipped = true;
            for (i = 0; i < isize; ++i) {
                index[i] = i;
            }
            while (flipped) {
                flipped = false;
                for (i = 0; i < isize - 1; ++i) {
                    double b;
                    double a = this.levels_.get(index[i]).getValue();
                    if (!(a > (b = this.levels_.get(index[i + 1]).getValue()))) continue;
                    int temp = index[i];
                    index[i] = index[i + 1];
                    index[i + 1] = temp;
                    flipped = true;
                }
            }
            ArrayList<ContourLevel> oldValues = this.levels_;
            this.levels_ = new ArrayList(isize);
            for (int i2 = 0; i2 < isize; ++i2) {
                this.levels_.add(oldValues.get(index[i2]));
            }
        }
        this.sorted_ = true;
    }
}

