/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcCatalogNode;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.net.URI;
import java.util.Iterator;
import java.util.Objects;
import thredds.client.catalog.Access;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.Service;
import thredds.client.catalog.ServiceType;

public class NcCatalogDataset
extends NcCatalogNode {
    private Dataset dataset_;
    private boolean childrenInitialized_;
    private URI uri_;
    private boolean isSimpleDataset_;

    private NcCatalogDataset() {
    }

    private NcCatalogDataset(Dataset dataset) {
        this(null, dataset);
    }

    public NcCatalogDataset(NcCatalogNode parent, Dataset dataset) {
        this.setParent(parent);
        this.dataset_ = dataset;
        this.initURI();
    }

    private final void initURI() {
        Access access;
        Service dservice = this.dataset_.getServiceDefault();
        ServiceType dstype = dservice != null ? dservice.getType() : null;
        for (Access info : this.dataset_.getAccess()) {
            access = info;
            Service service = access.getService();
            if (service == null) continue;
            ServiceType stype = service.getType();
            if (dstype != null && !stype.equals((Object)dstype)) continue;
            this.uri_ = access.getStandardUri();
            this.isSimpleDataset_ = true;
            return;
        }
        Iterator<Access> iterator = this.dataset_.getAccess().iterator();
        if (iterator.hasNext()) {
            Access info;
            access = info = iterator.next();
            this.uri_ = access.getStandardUri();
            this.isSimpleDataset_ = true;
            return;
        }
    }

    private synchronized void initChildren() {
        Iterator<Dataset> iterator = this.dataset_.getDatasetsLogical().iterator();
        while (iterator.hasNext()) {
            Dataset o;
            Dataset d = o = iterator.next();
            super.add(new NcCatalogDataset(this, d));
        }
        this.childrenInitialized_ = true;
    }

    public String getCatalogURL() {
        return this.dataset_.getCatalogUrl();
    }

    public URI getURI() {
        return this.uri_;
    }

    @Override
    public boolean isLeaf() {
        return this.isSimpleDataset_;
    }

    public boolean hasChildren() {
        if (!this.childrenInitialized_) {
            this.initChildren();
        }
        if (this.dataset_ instanceof CatalogRef) {
            return true;
        }
        return this.getChildCount() > 0;
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isSimpleDataset_;
    }

    @Override
    public Object getObject() {
        return this.dataset_;
    }

    @Override
    public String getName() {
        return this.dataset_.getName();
    }

    @Override
    public String getLongName() {
        return this.dataset_.getName();
    }

    @Override
    public String getDetail() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("<html><head>");
        this.appendDetailStyle(sb);
        sb.append("</head>").append("<body>").append("<h2>");
        if (this.getAllowsChildren()) {
            sb.append("Catalog Branch \"");
        } else {
            sb.append("Dataset \"");
        }
        sb.append(this.getName()).append("\"</h2>\n").append("<hr>").append("<pre>").append("Full Name:       ").append(this.dataset_.getName()).append('\n');
        if (this.dataset_.getCatalogUrl() != null) {
            sb.append("Catalog URL:     ").append(this.dataset_.getCatalogUrl()).append('\n');
        }
        if (this.dataset_.getID() != null) {
            sb.append("ID:              ").append(this.dataset_.getID()).append('\n');
        }
        if (this.dataset_.getDataFormatType() != null) {
            sb.append("Data FormatType: ").append((Object)this.dataset_.getDataFormatType()).append('\n');
        }
        if (this.dataset_.getDataFormatName() != null) {
            sb.append("Data Type:       ").append(this.dataset_.getDataFormatName()).append('\n');
        }
        Iterator<Access> iterator = this.dataset_.getAccess().iterator();
        while (iterator.hasNext()) {
            Access info;
            Access md = info = iterator.next();
            sb.append('\n').append("Access-Service:  ").append(md.getService().getServiceTypeName()).append('\n').append("Access-URI:      ").append("<a href=").append(md.getStandardUri()).append('>').append(md.getStandardUri()).append("</a>\n");
        }
        sb.append("</pre>").append("</body>").append(")</html>");
        return sb.toString();
    }

    @Override
    public String getDetailType() {
        return "text/html";
    }

    @Override
    public int getChildCount() {
        if (!this.childrenInitialized_) {
            this.initChildren();
        }
        return super.getChildCount();
    }

    @Override
    public TreeTableNode getChildAt(int index) {
        if (!this.childrenInitialized_) {
            this.initChildren();
        }
        return super.getChildAt(index);
    }

    @Override
    public TreeTableNode[] getChildren() {
        if (!this.childrenInitialized_) {
            this.initChildren();
        }
        return super.getChildren();
    }

    @Override
    public void add(TreeTableNode child) throws IllegalStateException {
        Objects.requireNonNull(child, "Cannot add a null child.");
        if (!this.childrenInitialized_) {
            this.initChildren();
        }
        super.add(child);
    }
}

