/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcVarClass;
import gov.nasa.giss.data.nc.NcVarSorting;
import gov.nasa.giss.data.nc.ui.NcDataTreeTableModel;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NcDataNode
extends TreeTableNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static NcVarSorting sorting_ = NcVarSorting.ALPHA;
    private NcVarClass visVarClass_ = NcVarClass.ALL;
    protected ArrayList<String> childNameList_ = new ArrayList(40);

    public static void setSorting(NcVarSorting sorting) {
        sorting_ = sorting;
    }

    public abstract String getNcType();

    public abstract String getLongName();

    public abstract String getDetail(boolean var1);

    protected void appendDetailStyle(StringBuilder sb) {
        sb.append("<style type=\"text/css\"><!-- ");
        sb.append("body { padding:8px; margin:8px }");
        sb.append("body h2 { font-family:sans-serif; font-size:12px; margin-bottom:0; padding-bottom:0 } ");
        sb.append("body h3 { font-family:sans-serif; font-size:11px; margin-bottom:0; padding-bottom:0 } ");
        sb.append("body h4 { font-family:sans-serif; font-size:10px; margin-bottom:0; padding-bottom:0 } ");
        sb.append("body p  { font-size:10px; font-family:sans-serif } ");
        sb.append("body pre { font-size:10px; border:solid gray 1px;padding: 8px; background:#f8f8f8 } ");
        sb.append("body hr  { border:none; background-color:#999999; color:#999999; height:1px } ");
        sb.append("// --></style>");
    }

    public abstract String getDetailType();

    public NcVarClass getVisibleVarClass() {
        return this.visVarClass_;
    }

    public void setVisibleVarClass(NcDataTreeTableModel model, NcVarClass vclass) {
        if (vclass.equals(this.visVarClass_)) {
            return;
        }
        this.visVarClass_ = vclass;
        if (!this.getAllowsChildren()) {
            return;
        }
        TreeTableNode[] children = this.getChildren();
        for (int i = children.length - 1; i >= 0; --i) {
            NcDataNode node = (NcDataNode)children[i];
            if (!node.getAllowsChildren()) continue;
            node.setVisibleVarClass(model, vclass);
        }
    }

    @Override
    public void add(TreeTableNode node) {
        throw new UnsupportedOperationException("Use addSorted(node) instead.");
    }

    protected int addSorted(NcDataNode node) {
        if (!this.getAllowsChildren()) {
            LOGGER.warn("Node does not allow children: {}", (Object)this.getName(), (Object)node.getName());
            throw new NcException("Node does not allow children");
        }
        int ipos = sorting_ == NcVarSorting.ALPHA ? this.addAlphabetically(node) : this.addSimple(node);
        node.setParent(this);
        return ipos;
    }

    private int addSimple(NcDataNode node) {
        if (this.childNameList_.isEmpty()) {
            super.add(node);
            return this.getChildCount() - 1;
        }
        String nname = node.getLongName();
        int npos = -1;
        for (int i = 0; i < this.childNameList_.size(); ++i) {
            if (!nname.equals(this.childNameList_.get(i))) continue;
            npos = i;
            break;
        }
        int isize = this.getChildCount();
        for (int i = 0; i < isize; ++i) {
            NcDataNode inode = (NcDataNode)this.getChildAt(i);
            if (node.equals(inode)) {
                throw new NcException("Child node already added");
            }
            String iname = inode.getLongName();
            int ipos = -1;
            for (int j = 0; j < this.childNameList_.size(); ++j) {
                if (!iname.equals(this.childNameList_.get(j))) continue;
                ipos = j;
                break;
            }
            if (npos <= ipos) continue;
            super.add(i, node);
            return i;
        }
        super.add(node);
        return isize;
    }

    private int addAlphabetically(NcDataNode node) {
        int isize = this.getChildCount();
        String name = node.getName();
        for (int i = 0; i < isize; ++i) {
            NcDataNode inode = (NcDataNode)this.getChildAt(i);
            if (node.equals(inode)) {
                throw new NcException("Child node already added");
            }
            String iname = inode.getName();
            int compare = name.compareToIgnoreCase(iname);
            if (compare >= 0) continue;
            super.add(i, node);
            return i;
        }
        super.add(node);
        return isize;
    }

    protected boolean isChild(NcDataNode node) {
        TreeTableNode[] children = this.getChildren();
        if (children == null) {
            return false;
        }
        String name = node.getName();
        for (int i = 0; i < children.length; ++i) {
            NcDataNode onode = (NcDataNode)children[i];
            if (!name.equals(onode.getName())) continue;
            return true;
        }
        return false;
    }
}

