/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcAltGriddingVarType;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcCartesianVarType;
import gov.nasa.giss.data.nc.NcCoordinateVarType;
import gov.nasa.giss.data.nc.NcDataGrouping;
import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.NcDiscreteVarType;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVarTypeDetector;
import gov.nasa.giss.data.nc.NcVarUtils;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayString;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NCdumpW;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;

public class NcVariable
extends NcDataNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static String SYSTEM_EOL = System.getProperty("line.separator");
    private NcDataset ncdataset_;
    private NcDataGrouping ncgrouping_;
    protected VariableDS njvarDS_;
    protected int rank_;
    protected int[] shape_;
    protected NcVarType varType_;
    protected NcCoordinateVarType cvarType_;
    private NcDimension[] ncdims_;
    protected Array extractSlice_;
    protected int[] extractOrigin_;
    protected int[] extractShape_;

    public NcVariable(NcDataset ncd, NcDataGrouping ncg, VariableDS njvarDS) {
        this.ncdataset_ = ncd;
        this.ncgrouping_ = ncg;
        this.njvarDS_ = njvarDS;
        this.rank_ = this.njvarDS_.getRank();
        this.shape_ = this.njvarDS_.getShape();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof NcVariable)) {
            return false;
        }
        NcVariable var2 = (NcVariable)o;
        return this.njvarDS_.equals(var2.getObject());
    }

    public int hashCode() {
        return this.njvarDS_.hashCode();
    }

    public NcDataset getDataset() {
        return this.ncdataset_;
    }

    public NcDataGrouping getGrouping() {
        return this.ncgrouping_;
    }

    public NcVarType getVarType() {
        if (this.varType_ == null) {
            this.initVarType();
        }
        return this.varType_;
    }

    private void initVarType() {
        try {
            this.varType_ = NcVarTypeDetector.getVarType(this.ncdataset_, this.ncgrouping_, this.njvarDS_);
        }
        catch (Exception exc) {
            LOGGER.warn("Exception getting var type {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.varType_ = NcVarType.OTHER;
        }
    }

    public NcCoordinateVarType getCoordinateVarType() {
        if (this.cvarType_ == null) {
            try {
                this.cvarType_ = NcVarTypeDetector.getCoordinateVarType(this.njvarDS_);
            }
            catch (Exception exc) {
                this.cvarType_ = NcCoordinateVarType.NONE;
            }
        }
        return this.cvarType_;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public Object getObject() {
        return this.njvarDS_;
    }

    public VariableDS getNjVariable() {
        return this.njvarDS_;
    }

    @Override
    public String getName() {
        return this.njvarDS_.getShortName();
    }

    @Override
    public String getLongName() {
        return NcVarUtils.getLongName(this.njvarDS_);
    }

    public Group getNjGroup() {
        return this.njvarDS_.getGroup();
    }

    public String getUnitsString() {
        return NcVarUtils.getUnitsString(this.njvarDS_);
    }

    @Override
    public String getNcType() {
        String result = null;
        result = this.isTrajectory() ? "GeoTraj" : (this.isGriddable2DGeo() ? "Geo2D" : (this.isGriddable2D() ? "2D" : (this.isGriddable1D() ? "1D" : "\u2014")));
        if (this.varType_ == null) {
            this.initVarType();
        }
        LOGGER.trace("{} = {} = {}", this.njvarDS_.getShortName(), this.varType_, result);
        return result;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public TreeTableNode[] getChildren() {
        return null;
    }

    @Override
    public String toString() {
        return this.njvarDS_.getFullName();
    }

    @Override
    public String getDetail(boolean enhanced) {
        StringBuilder sb;
        block44: {
            if (this.varType_ == null) {
                this.initVarType();
            }
            String sname = this.njvarDS_.getShortName();
            String fname = this.njvarDS_.getFullName();
            VariableDS unenhanced = this.ncdataset_.getNjVariableUnenhanced(fname);
            Variable njvar = this.njvarDS_.getOriginalVariable();
            boolean doubleEnhanced = false;
            if (njvar instanceof VariableEnhanced) {
                LOGGER.trace("Original variable is double enhanced!");
                doubleEnhanced = true;
                njvar = ((VariableEnhanced)((Object)njvar)).getOriginalVariable();
            }
            sb = new StringBuilder(256);
            sb.append("<html>").append("<head>");
            this.appendDetailStyle(sb);
            sb.append("</head>").append("<body>").append("<h2>Variable \"").append(sname).append("\"</h2>").append("<h3>In file \"").append(this.ncdataset_.getName()).append("\"</h3>");
            if (!sname.equals(fname)) {
                sb.append("<p>Variable full name: ").append(fname).append("</p>");
            }
            if (enhanced || unenhanced == null && njvar == null) {
                sb.append("<p>Variable type for plotting is ").append(this.varType_).append("</p>");
                if (doubleEnhanced) {
                    sb.append("<p>Variable appears to be 'double enhanced'</p>.");
                } else if (unenhanced == null && njvar == null) {
                    sb.append("<p>Variable appears to be 'virtual', constructed based on file metadata.</p>");
                } else {
                    sb.append("<p><b>Showing enhanced mode description.</b></p>");
                }
            }
            sb.append("<pre>");
            if (enhanced || unenhanced == null && njvar == null) {
                sb.append(StringUtils.escapeHtmlSimplistic(this.njvarDS_.toString()));
            } else if (unenhanced != null) {
                sb.append(StringUtils.escapeHtmlSimplistic(unenhanced.toString()));
            } else {
                sb.append(StringUtils.escapeHtmlSimplistic(njvar.toString()));
            }
            sb.append("</pre>");
            if (LOGGER.isDebugEnabled()) {
                sb.append("<hr>").append("<p><b>Debug info:</b></p>\n").append("<pre>").append("isCoordinateVar ").append(this.njvarDS_.isCoordinateVariable()).append('\n').append("hasFillValue    ").append(this.njvarDS_.hasFillValue()).append('\n').append("hasMissing      ").append(this.njvarDS_.hasMissing()).append('\n').append("hasMissingValue ").append(this.njvarDS_.hasMissingValue()).append('\n').append("getValidMin     ").append(this.njvarDS_.getValidMin()).append('\n').append("getValidMax     ").append(this.njvarDS_.getValidMax()).append('\n');
                Formatter ff = new Formatter();
                this.njvarDS_.showScaleMissingProxy(ff);
                sb.append('\n').append("S-M-P...\n").append(ff).append('\n');
                sb.append("</pre>");
            }
            if (this.isScalar()) {
                try {
                    Object oo = this.getScalarValue();
                    if (oo == null) {
                        LOGGER.trace("getScalarValue returned null");
                        break block44;
                    }
                    sb.append("<hr>").append("<p>");
                    if (this.njvarDS_.isScalar()) {
                        sb.append("Scalar variable has value: ");
                    } else {
                        sb.append("Array is single-valued, with value: ");
                    }
                    if (oo instanceof Double || oo instanceof Float) {
                        sb.append(PrintfFormat.PFORMAT_7G.sprintg(oo));
                    } else if (oo instanceof Long || oo instanceof Integer || oo instanceof Short || oo instanceof Byte) {
                        sb.append(oo.toString());
                    } else if (oo instanceof Character) {
                        Character cc = (Character)oo;
                        sb.append((int)cc.charValue());
                        if (Character.isAlphabetic(cc.charValue())) {
                            sb.append(" = '").append(cc).append("'");
                        }
                    } else {
                        sb.append("'").append(oo.toString()).append("'");
                    }
                    sb.append("</p>");
                }
                catch (Exception exc) {
                    sb.append("<hr>").append("<p>");
                    sb.append("An exception occurred while extracting scalar value: ");
                    sb.append(exc.toString());
                    sb.append("</p>");
                    LOGGER.debug("Could not extract scalar value: {}", (Object)exc.toString());
                    if (LOGGER.isTraceEnabled()) {
                        exc.printStackTrace();
                    }
                    break block44;
                }
            }
            if (this.isTrajectory()) {
                int[] shape = this.njvarDS_.getShape();
                boolean big = false;
                boolean verybig = false;
                for (int i = 0; i < shape.length; ++i) {
                    if (shape[i] > 50000) {
                        big = true;
                    }
                    if (shape[i] <= 200000) continue;
                    verybig = true;
                }
                if (verybig) {
                    sb.append("<hr>").append("<p>");
                    sb.append("Trajectory variable contains a very large number of elements; ");
                    sb.append("plotting it could be extremely slow.</p>");
                } else if (big) {
                    sb.append("<hr>").append("<p>");
                    sb.append("Trajectory variable contains a large number of elements; ");
                    sb.append("plotting it could be slow.</p>");
                }
            } else {
                DataType dt = this.njvarDS_.getDataType();
                long ichars = njvar.getSize();
                if (ichars < 80000L) {
                    if (dt == DataType.CHAR && this.rank_ < 2) {
                        try {
                            char c;
                            Array aarray = njvar.read();
                            Index cindex = aarray.getIndex();
                            StringBuilder sbx = new StringBuilder("");
                            int ii = 0;
                            while ((long)ii < ichars && (c = aarray.getChar(cindex.set(ii))) != '\u0000') {
                                sbx.append(c);
                                ++ii;
                            }
                            sb.append("<p>Char content reads:</p>").append("<pre>").append(StringUtils.escapeHtmlSimplistic(sbx)).append("</pre>");
                        }
                        catch (Exception aarray) {}
                    } else if (dt == DataType.STRING && this.rank_ == 0) {
                        LOGGER.trace("Yo, it's a String");
                        try {
                            Array aarray = njvar.read();
                            if (aarray instanceof ArrayString) {
                                Index cindex = aarray.getIndex();
                                StringBuilder stringBuilder = new StringBuilder("");
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        sb.append("</body>");
        sb.append("</html>");
        return sb.toString();
    }

    @Override
    public String getDetailType() {
        return "text/html";
    }

    public boolean isGriddable() {
        if (this.isTrajectory()) {
            return true;
        }
        return this.isGriddable1D() || this.isGriddable2D() || this.isGriddable2DGeo();
    }

    public boolean isGriddable1D() {
        if (this.varType_ == null) {
            this.initVarType();
        }
        if (this.varType_ == NcVarType.OTHER || this.varType_ == NcVarType.SCALAR) {
            return false;
        }
        return NcVarUtils.isGriddable1D(this.njvarDS_);
    }

    public boolean isGriddable2D() {
        if (!this.isGriddable1D()) {
            return false;
        }
        if (this.varType_ == NcVarType.ONED) {
            return false;
        }
        return NcVarUtils.isGriddable2D(this.njvarDS_);
    }

    public boolean isGriddable2DGeo() {
        if (this.varType_ == null) {
            this.initVarType();
        }
        return this.varType_.isGeoreferenced() && !this.isTrajectory();
    }

    public boolean isTrajectory() {
        if (this.varType_ == null) {
            this.initVarType();
        }
        if (this.varType_ instanceof NcDiscreteVarType) {
            return ((NcDiscreteVarType)this.varType_).isTrajectory();
        }
        return false;
    }

    public boolean hasAxesOfType(NcAxisType atype1, NcAxisType atype2) {
        if (this.varType_ == null) {
            this.initVarType();
        }
        if (this.varType_ instanceof NcCartesianVarType) {
            NcCartesianVarType cvtype = (NcCartesianVarType)this.varType_;
            return cvtype.hasAxis(atype1) && cvtype.hasAxis(atype2);
        }
        if (this.varType_ instanceof NcAltGriddingVarType) {
            return atype1 == NcAxisType.LON && atype2 == NcAxisType.LAT || atype1 == NcAxisType.LAT && atype2 == NcAxisType.LON;
        }
        return false;
    }

    private boolean isScalar() {
        if (this.varType_ == null) {
            this.initVarType();
        }
        return this.njvarDS_.isScalar() || this.varType_.isScalar();
    }

    public int getRank() {
        return this.rank_;
    }

    public long getElementCount() {
        long count = 1L;
        for (int i = 0; i < this.rank_; ++i) {
            count *= (long)this.shape_[i];
        }
        return count;
    }

    public NcDimension getDimension(int index) {
        if (this.ncdims_ == null) {
            this.extractDimensions();
        }
        return this.ncdims_[index];
    }

    public NcDimension[] getDimensions() {
        if (this.ncdims_ == null) {
            this.extractDimensions();
        }
        return this.ncdims_;
    }

    private final void extractDimensions() {
        this.ncdims_ = new NcDimension[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            Dimension d = this.njvarDS_.getDimension(i);
            this.ncdims_[i] = new NcDimension(this.ncdataset_, this.njvarDS_, d);
            LOGGER.trace("{} -- {}", (Object)i, (Object)this.ncdims_[i]);
        }
    }

    public double doubleValueAt(int ... indices) {
        Double oo = this.objectAt(indices);
        if (oo == null) {
            return Double.NaN;
        }
        return this.valueToDouble(oo);
    }

    private double objectAt(int ... indices) {
        if (this.isScalar()) {
            if (indices == null || indices.length == 0) {
                return this.valueToDouble(this.getScalarValue());
            }
            throw new IllegalArgumentException("Indices are unnecssary. Variable is a scalar.");
        }
        if (indices.length != this.rank_) {
            throw new IllegalArgumentException("Indices array is wrong rank.");
        }
        boolean needsExtract = false;
        if (this.extractOrigin_ == null) {
            this.extractOrigin_ = new int[this.rank_];
            this.extractShape_ = new int[this.rank_];
            needsExtract = true;
        }
        int rankM1 = this.rank_ - 1;
        for (int i = 0; i < rankM1; ++i) {
            if (indices[i] < 0 || indices[i] >= this.shape_[i]) {
                throw new IndexOutOfBoundsException("Index " + indices[i] + " out of range 0," + (this.shape_[i] - 1) + " for dimension " + i);
            }
            if (indices[i] != this.extractOrigin_[i]) {
                needsExtract = true;
            }
            this.extractOrigin_[i] = indices[i];
            this.extractShape_[i] = 1;
        }
        this.extractOrigin_[rankM1] = 0;
        this.extractShape_[rankM1] = this.shape_[rankM1];
        try {
            if (needsExtract) {
                this.extractSlice_ = this.njvarDS_.read(this.extractOrigin_, this.extractShape_).reduce();
            }
            Object oo = this.extractSlice_.getObject(indices[rankM1]);
            return this.valueToDouble(oo);
        }
        catch (Exception exc) {
            LOGGER.warn("Exception occurred while extracting scalar value: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return Double.NaN;
        }
    }

    private Object getScalarValue() {
        if (!this.isScalar()) {
            throw new NcException("Variable is not a scalar.");
        }
        try {
            Array aa = this.njvarDS_.read().reduce();
            if (aa.getRank() > 0) {
                LOGGER.warn("- array has rank > 0");
            } else if (aa.getSize() != 1L) {
                LOGGER.warn("- array has size != 1");
            }
            return aa.getObject(0);
        }
        catch (Exception exc) {
            LOGGER.warn("Exception occurred while extracting scalar value: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return null;
        }
    }

    protected double valueToDouble(Object oo) {
        if (oo == null) {
            return Double.NaN;
        }
        if (oo instanceof Double || oo instanceof Float) {
            return (Double)oo;
        }
        if (oo instanceof Long || oo instanceof Integer || oo instanceof Short || oo instanceof Byte) {
            return (Double)oo;
        }
        if (oo instanceof Character) {
            Character cc = (Character)oo;
            char ii = cc.charValue();
            return ii;
        }
        LOGGER.trace("Not a numeric type we know how to deal with.");
        return Double.NaN;
    }

    public void printCdl(File f) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(f), 0x100000);
        NetcdfDataset ncf = this.ncdataset_.getNjDataset();
        NCdumpW.print(ncf, (Writer)writer, false, false, false, true, this.njvarDS_.getFullName(), null);
        writer.close();
    }

    public void printCsv(File f) throws InvalidRangeException, IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(f), 0x100000);
        if (this.rank_ == 0) {
            this.printScalar(writer);
        } else if (this.rank_ == 1) {
            this.printCsv1D(writer);
        } else {
            this.printCsv2DPlus(writer);
        }
        writer.close();
    }

    private final void printScalar(Writer writer) throws InvalidRangeException, IOException {
        if (!this.isScalar()) {
            LOGGER.warn("Variable is not a scalar.");
        }
        Array array = this.njvarDS_.read();
        Object o = array.getObject(0);
        this.printObject(writer, o);
        writer.write(SYSTEM_EOL);
    }

    private final void printCsv1D(Writer writer) throws InvalidRangeException, IOException {
        int numCols = this.shape_[0];
        int[] sOrigin = new int[]{0};
        int[] sShape = new int[]{numCols};
        Array slice = this.njvarDS_.read();
        for (int j = 0; j < numCols; ++j) {
            Object o = slice.getObject(j);
            writer.write(o.toString());
            if (j >= numCols - 1) continue;
            writer.write(",");
        }
        writer.write(SYSTEM_EOL);
    }

    private final void printCsv2DPlus(Writer writer) throws InvalidRangeException, IOException {
        int rowsThisSlice;
        int rankM1 = this.rank_ - 1;
        int rankM2 = this.rank_ - 2;
        int numRows = this.shape_[rankM2];
        int numCols = this.shape_[rankM1];
        int totalRows = 1;
        for (int i = 0; i < rankM1; ++i) {
            totalRows *= this.shape_[i];
        }
        int[] sOrigin = new int[this.rank_];
        int[] sShape = new int[this.rank_];
        for (int i = 0; i < rankM1; ++i) {
            sOrigin[i] = 0;
            sShape[i] = 1;
        }
        sOrigin[rankM1] = 0;
        sShape[rankM1] = numCols;
        int rowsPerSlice = numRows;
        if (numRows * numCols > 10000000 && (rowsPerSlice = 10000000 / numCols) % 4 > 0) {
            rowsPerSlice -= rowsPerSlice % 4;
        }
        for (int rowNum = 0; rowNum < totalRows; rowNum += rowsThisSlice) {
            if (rankM2 > 0) {
                for (int ii = rankM2; ii > 0; --ii) {
                    if (sOrigin[ii] < this.shape_[ii]) continue;
                    int n = ii - 1;
                    sOrigin[n] = sOrigin[n] + 1;
                    sOrigin[ii] = 0;
                }
                if (sOrigin[rankM2] == 0 && rowNum > 0) {
                    writer.write(SYSTEM_EOL);
                }
            }
            sShape[rankM2] = rowsThisSlice = Math.min(16, numRows - sOrigin[rankM2]);
            Array slice = this.njvarDS_.read(sOrigin, sShape).reduce();
            for (int j = 0; j < rowsThisSlice; ++j) {
                for (int i = 0; i < numCols; ++i) {
                    Object o = slice.getObject(j * numCols + i);
                    writer.write(o.toString());
                    if (i >= numCols - 1) continue;
                    writer.write(",");
                }
                writer.write(SYSTEM_EOL);
            }
            int n = rankM2;
            sOrigin[n] = sOrigin[n] + rowsThisSlice;
        }
    }

    public void printLabeledText(File f) throws InvalidRangeException, IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(f), 0x100000);
        if (this.rank_ == 0) {
            this.printScalar(writer);
        } else if (this.rank_ == 1) {
            this.printLabeledText1D(writer);
        } else {
            this.printLabeledText2DPlus(writer);
        }
        writer.close();
    }

    private final void printLabeledText1D(Writer writer) throws InvalidRangeException, IOException {
        if (this.ncdims_ == null) {
            this.extractDimensions();
        }
        Dimension d = this.njvarDS_.getDimension(0);
        writer.write(d.getShortName() + "\t");
        writer.write(this.njvarDS_.getFullName());
        writer.write(SYSTEM_EOL);
        int numCols = this.shape_[0];
        int[] sOrigin = new int[]{0};
        int[] sShape = new int[]{numCols};
        Array slice = this.njvarDS_.read();
        for (int j = 0; j < numCols; ++j) {
            Object o = slice.getObject(j);
            this.printObject(writer, this.ncdims_[0].valueAt(j));
            writer.write("\t");
            this.printObject(writer, o);
            writer.write(SYSTEM_EOL);
        }
    }

    private final void printLabeledText2DPlus(Writer writer) throws InvalidRangeException, IOException {
        int rowsThisSlice;
        int rankM1 = this.rank_ - 1;
        int rankM2 = this.rank_ - 2;
        int numRows = this.shape_[rankM2];
        int numCols = this.shape_[rankM1];
        int totalRows = 1;
        for (int i = 0; i < rankM1; ++i) {
            totalRows *= this.shape_[i];
        }
        int[] sOrigin = new int[this.rank_];
        int[] sShape = new int[this.rank_];
        for (int i = 0; i < rankM1; ++i) {
            sOrigin[i] = 0;
            sShape[i] = 1;
        }
        sOrigin[rankM1] = 0;
        sShape[rankM1] = numCols;
        if (this.ncdims_ == null) {
            this.extractDimensions();
        }
        Object[][] dimvals = new Object[this.rank_][];
        for (int i = 0; i < this.rank_; ++i) {
            Dimension d = this.njvarDS_.getDimension(i);
            writer.write(d.getShortName() + "\t");
            dimvals[i] = this.ncdims_[i].getValues();
        }
        writer.write(this.njvarDS_.getFullName());
        writer.write(SYSTEM_EOL);
        int rowsPerSlice = numRows;
        if (numRows * numCols > 10000000 && (rowsPerSlice = 10000000 / numCols) % 4 > 0) {
            rowsPerSlice -= rowsPerSlice % 4;
        }
        for (int rowNum = 0; rowNum < totalRows; rowNum += rowsThisSlice) {
            if (rankM2 > 0) {
                for (int ii = rankM2; ii > 0; --ii) {
                    if (sOrigin[ii] < this.shape_[ii]) continue;
                    int n = ii - 1;
                    sOrigin[n] = sOrigin[n] + 1;
                    sOrigin[ii] = 0;
                }
            }
            sShape[rankM2] = rowsThisSlice = Math.min(16, numRows - sOrigin[rankM2]);
            Array slice = this.njvarDS_.read(sOrigin, sShape).reduce();
            for (int j = 0; j < rowsThisSlice; ++j) {
                for (int i = 0; i < numCols; ++i) {
                    Object o = slice.getObject(j * numCols + i);
                    for (int ii = 0; ii < rankM2; ++ii) {
                        this.printObject(writer, dimvals[ii][sOrigin[ii]]);
                        writer.write("\t");
                    }
                    this.printObject(writer, dimvals[rankM2][sOrigin[rankM2] + j]);
                    writer.write("\t");
                    this.printObject(writer, dimvals[rankM1][i]);
                    writer.write("\t");
                    this.printObject(writer, o);
                    writer.write(SYSTEM_EOL);
                }
            }
            int n = rankM2;
            sOrigin[n] = sOrigin[n] + rowsThisSlice;
        }
    }

    protected final void printObject(Writer writer, Object o) throws IOException {
        if (!(o instanceof Number)) {
            writer.write("\"");
        }
        writer.write(o.toString());
        if (!(o instanceof Number)) {
            writer.write("\"");
        }
    }
}

